/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.util.HashMap;
import org.eclipse.dali.internal.utility.JDBCTools;
import org.eclipse.dali.internal.utility.JDBCType;
import org.eclipse.dali.internal.utility.JavaType;
import org.eclipse.wst.rdb.internal.models.sql.datatypes.PrimitiveType;

public final class RDBTools {
    private static HashMap PRIMITIVE_TO_JDBC_TYPE_MAPPINGS;
    private static final JDBCType DEFAULT_JDBC_TYPE;

    static {
        DEFAULT_JDBC_TYPE = JDBCType.type((int)12);
    }

    public static JDBCType jdbcTypeForPrimitiveTypeNamed(String primitiveTypeName) {
        PrimitiveToJDBCTypeMapping mapping = RDBTools.primitiveToJDBCTypeMapping(primitiveTypeName);
        return mapping == null ? DEFAULT_JDBC_TYPE : mapping.getJDBCType();
    }

    public static JDBCType jdbcTypeFor(PrimitiveType primitiveType) {
        return RDBTools.jdbcTypeForPrimitiveTypeNamed(primitiveType.getName());
    }

    public static JDBCType jdbcTypeForPrimitiveTypeCode(int primitiveTypeCode) {
        return RDBTools.jdbcTypeFor(PrimitiveType.get((int)primitiveTypeCode));
    }

    public static JavaType javaTypeForPrimitiveTypeNamed(String primitiveTypeName) {
        return JDBCTools.javaTypeFor((JDBCType)RDBTools.jdbcTypeForPrimitiveTypeNamed(primitiveTypeName));
    }

    public static JavaType javaTypeFor(PrimitiveType primitiveType) {
        return JDBCTools.javaTypeFor((JDBCType)RDBTools.jdbcTypeFor(primitiveType));
    }

    public static JavaType javaTypeForPrimitiveTypeCode(int primitiveTypeCode) {
        return JDBCTools.javaTypeFor((JDBCType)RDBTools.jdbcTypeForPrimitiveTypeCode(primitiveTypeCode));
    }

    private static PrimitiveToJDBCTypeMapping primitiveToJDBCTypeMapping(String primitiveTypeName) {
        return (PrimitiveToJDBCTypeMapping)RDBTools.primitiveToJDBCTypeMappings().get(primitiveTypeName);
    }

    private static synchronized HashMap primitiveToJDBCTypeMappings() {
        if (PRIMITIVE_TO_JDBC_TYPE_MAPPINGS == null) {
            PRIMITIVE_TO_JDBC_TYPE_MAPPINGS = RDBTools.buildPrimitiveToJDBCTypeMappings();
        }
        return PRIMITIVE_TO_JDBC_TYPE_MAPPINGS;
    }

    private static HashMap buildPrimitiveToJDBCTypeMappings() {
        HashMap mappings = new HashMap();
        RDBTools.addPrimitiveToJDBCTypeMappingsTo(mappings);
        return mappings;
    }

    private static void addPrimitiveToJDBCTypeMappingsTo(HashMap mappings) {
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BIGINT_LITERAL, -5, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BINARY_LARGE_OBJECT_LITERAL, 2004, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BINARY_LITERAL, -2, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BINARY_VARYING_LITERAL, -3, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.BOOLEAN_LITERAL, 16, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.CHARACTER_LARGE_OBJECT_LITERAL, 2005, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.CHARACTER_LITERAL, 1, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.CHARACTER_VARYING_LITERAL, 12, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.DATALINK_LITERAL, 70, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.DATE_LITERAL, 91, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.DECIMAL_LITERAL, 3, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.DOUBLE_PRECISION_LITERAL, 8, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.FLOAT_LITERAL, 6, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.INTEGER_LITERAL, 4, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.INTERVAL_LITERAL, 1111, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.NATIONAL_CHARACTER_LARGE_OBJECT_LITERAL, 2005, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.NATIONAL_CHARACTER_LITERAL, 1, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.NATIONAL_CHARACTER_VARYING_LITERAL, 12, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.NUMERIC_LITERAL, 2, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.REAL_LITERAL, 7, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.SMALLINT_LITERAL, 5, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.TIME_LITERAL, 92, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.TIMESTAMP_LITERAL, 93, mappings);
        RDBTools.addPrimitiveToJDBCTypeMappingTo(PrimitiveType.XML_TYPE_LITERAL, 1111, mappings);
    }

    private static void addPrimitiveToJDBCTypeMappingTo(PrimitiveType primitiveType, int jdbcTypeCode, HashMap mappings) {
        PrimitiveToJDBCTypeMapping prev = mappings.put(primitiveType.getName(), RDBTools.buildPrimitiveToJDBCTypeMapping(primitiveType, jdbcTypeCode));
        if (prev != null) {
            throw new IllegalArgumentException("duplicate Java class: " + prev.getPrimitiveType().getName());
        }
    }

    private static PrimitiveToJDBCTypeMapping buildPrimitiveToJDBCTypeMapping(PrimitiveType primitiveType, int jdbcTypeCode) {
        return new PrimitiveToJDBCTypeMapping(primitiveType, JDBCType.type((int)jdbcTypeCode));
    }

    private RDBTools() {
        throw new UnsupportedOperationException();
    }

    private static class PrimitiveToJDBCTypeMapping {
        private final PrimitiveType primitiveType;
        private final JDBCType jdbcType;

        PrimitiveToJDBCTypeMapping(PrimitiveType primitiveType, JDBCType jdbcType) {
            this.primitiveType = primitiveType;
            this.jdbcType = jdbcType;
        }

        public PrimitiveType getPrimitiveType() {
            return this.primitiveType;
        }

        public JDBCType getJDBCType() {
            return this.jdbcType;
        }

        public boolean maps(PrimitiveType pt) {
            return this.primitiveType.equals(pt);
        }

        public boolean maps(String primitiveTypeName) {
            return this.primitiveType.getName().equals(primitiveTypeName);
        }

        public boolean maps(int primitiveTypeCode) {
            return this.primitiveType.getValue() == primitiveTypeCode;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            this.appendTo(sb);
            return sb.toString();
        }

        public void appendTo(StringBuffer sb) {
            sb.append(this.primitiveType.getName());
            sb.append(" => ");
            this.jdbcType.appendTo(sb);
        }
    }
}

