/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.internal.utility.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.dali.internal.utility.ClassTools;

public class PeekableIterator
implements Iterator {
    private Iterator nestedIterator;
    private Object next;
    private static final Object END = new Object();

    public PeekableIterator(Iterator nestedIterator) {
        this.nestedIterator = nestedIterator;
        this.loadNext();
    }

    public boolean hasNext() {
        return this.next != END;
    }

    public Object next() {
        if (this.next == END) {
            throw new NoSuchElementException();
        }
        Object result = this.next;
        this.loadNext();
        return result;
    }

    public Object peek() {
        if (this.next == END) {
            throw new NoSuchElementException();
        }
        return this.next;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    private void loadNext() {
        this.next = this.nestedIterator.hasNext() ? this.nestedIterator.next() : END;
    }

    public String toString() {
        return String.valueOf(ClassTools.shortClassNameForObject(this)) + '(' + this.nestedIterator + ')';
    }
}

