/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.gen;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.gen.EntityGenerator;
import org.eclipse.dali.gen.GenTable;
import org.eclipse.dali.internal.utility.iterators.FilteringIterator;

class GenScope {
    private final Map genTables = new HashMap();

    GenScope(Collection tables, EntityGenerator.Config entityConfig) {
        this.initialize(tables, entityConfig);
    }

    private void initialize(Collection tables, EntityGenerator.Config entityConfig) {
        this.buildGenTables(tables, entityConfig);
        this.configureManyToManyRelations();
        this.configureManyToOneRelations();
        this.configureFieldNames();
    }

    private void buildGenTables(Collection tables, EntityGenerator.Config entityConfig) {
        HashSet entityNames = new HashSet(this.genTables.size());
        Iterator stream = tables.iterator();
        while (stream.hasNext()) {
            this.buildGenTable((Table)stream.next(), entityConfig, entityNames);
        }
    }

    private void buildGenTable(Table table, EntityGenerator.Config entityConfig, Collection entityNames) {
        this.genTables.put(table, new GenTable(this, table, entityConfig, entityNames));
    }

    private void configureManyToManyRelations() {
        Iterator stream = this.tables();
        while (stream.hasNext()) {
            ((GenTable)stream.next()).configureManyToManyRelations();
        }
        Set referencedTables = this.buildReferencedTables();
        Iterator stream2 = this.joinTables();
        while (stream2.hasNext()) {
            GenTable joinGenTable = (GenTable)stream2.next();
            if (!referencedTables.contains(joinGenTable)) continue;
            joinGenTable.clearJoinTableRelation();
        }
    }

    private void configureManyToOneRelations() {
        Iterator stream = this.entityTables();
        while (stream.hasNext()) {
            ((GenTable)stream.next()).configureManyToOneRelations();
        }
    }

    private void configureFieldNames() {
        Iterator stream = this.entityTables();
        while (stream.hasNext()) {
            ((GenTable)stream.next()).configureFieldNames();
        }
    }

    Iterator entityTables() {
        return new FilteringIterator(this.tables()){

            protected boolean accept(Object o) {
                return !((GenTable)o).isJoinTable();
            }
        };
    }

    GenTable genTable(Table table) {
        return (GenTable)this.genTables.get(table);
    }

    private Iterator tables() {
        return this.genTables.values().iterator();
    }

    private Iterator joinTables() {
        return new FilteringIterator(this.tables()){

            protected boolean accept(Object o) {
                return ((GenTable)o).isJoinTable();
            }
        };
    }

    private Set buildReferencedTables() {
        HashSet referencedTables = new HashSet(this.genTables.size());
        Iterator stream = this.tables();
        while (stream.hasNext()) {
            ((GenTable)stream.next()).addReferencedTablesTo(referencedTables);
        }
        return referencedTables;
    }
}

