/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.NonOwningMapping;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.adapters.INonOwningMappingModelAdapter;
import org.eclipse.dali.orm.impl.RelationshipMappingImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;

public abstract class NonOwningMappingImpl
extends RelationshipMappingImpl
implements NonOwningMapping {
    protected static final String MAPPED_BY_EDEFAULT = null;
    protected String mappedBy = MAPPED_BY_EDEFAULT;

    protected NonOwningMappingImpl() {
    }

    protected NonOwningMappingImpl(INonOwningMappingModelAdapter adapter) {
        super(adapter);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.NON_OWNING_MAPPING;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedByGen(String newMappedBy) {
        String oldMappedBy = this.mappedBy;
        this.mappedBy = newMappedBy;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, (Object)oldMappedBy, (Object)this.mappedBy));
        }
    }

    public void setMappedBy(String newMappedBy) {
        this.setMappedByGen(newMappedBy);
        ((INonOwningMappingModelAdapter)this.getModelAdapter()).mappedByChanged();
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 6: {
                return this.getMappedBy();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 6: {
                this.setMappedBy((String)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 6: {
                this.setMappedBy(MAPPED_BY_EDEFAULT);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 6: {
                return MAPPED_BY_EDEFAULT == null ? this.mappedBy != null : !MAPPED_BY_EDEFAULT.equals(this.mappedBy);
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (mappedBy: ");
        result.append(this.mappedBy);
        result.append(')');
        return result.toString();
    }

    protected PersistentAttribute getMappedByPersistentAttribute() {
        String targetEntity;
        String mappedBy = this.getMappedBy();
        if (mappedBy != null && (targetEntity = this.getFullyQualifiedTargetEntity()) != null) {
            return this.getPersistenceFile().resolvePersistentAttribute(targetEntity, mappedBy);
        }
        return null;
    }

    protected ITextRange mappedByTextRange() {
        ITextRange textRange = ((INonOwningMappingModelAdapter)this.getModelAdapter()).mappedByTextRange();
        if (textRange != null) {
            return textRange;
        }
        return this.getTextRange();
    }

    protected void addProblemsTo(List problems) {
        super.addProblemsTo(problems);
        this.addMappedByDoesNotExistProblemTo(problems);
        this.addMappedByInvalidMappingTypeProblemTo(problems);
    }

    private void addMappedByDoesNotExistProblemTo(List problems) {
        if (this.getMappedBy() == null) {
            return;
        }
        PersistentAttribute mappedByPersistentAttribute = this.getMappedByPersistentAttribute();
        if (mappedByPersistentAttribute == null) {
            problems.add(this.buildProblem("MappedBy specified for " + this.getPersistentAttribute().getName() + " does not exist on the target entity class", this.mappedByTextRange()));
        }
    }

    private void addMappedByInvalidMappingTypeProblemTo(List problems) {
        PersistentAttribute mappedByPersistentAttribute = this.getMappedByPersistentAttribute();
        if (mappedByPersistentAttribute == null) {
            return;
        }
        if (mappedByPersistentAttribute.getAttributeMapping().isPossibleRelationshipOwner()) {
            return;
        }
        problems.add(this.buildProblem("MappedBy specified on " + this.getPersistentAttribute().getName() + " is not a valid mapping type", this.mappedByTextRange()));
    }
}

