/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.dali.internal.utility.ClassTools;
import org.eclipse.dali.internal.utility.CollectionTools;
import org.eclipse.dali.internal.utility.iterators.CompositeIterator;
import org.eclipse.dali.internal.utility.iterators.TransformationIterator;
import org.eclipse.dali.orm.AccessType;
import org.eclipse.dali.orm.Embeddable;
import org.eclipse.dali.orm.Entity;
import org.eclipse.dali.orm.MappedSuperclass;
import org.eclipse.dali.orm.NullTypeMapping;
import org.eclipse.dali.orm.OrmFactory;
import org.eclipse.dali.orm.OrmPackage;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.orm.PersistentAttribute;
import org.eclipse.dali.orm.PersistentType;
import org.eclipse.dali.orm.TypeMapping;
import org.eclipse.dali.orm.VersionMapping;
import org.eclipse.dali.orm.adapters.IPersistentTypeModelAdapter;
import org.eclipse.dali.orm.adapters.ITypeMappingModelAdapter;
import org.eclipse.dali.orm.impl.PersistenceSourceRefElementImpl;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;

public class PersistentTypeImpl
extends PersistenceSourceRefElementImpl
implements PersistentType {
    protected static final String CLASS_NAME_EDEFAULT = null;
    protected String className = CLASS_NAME_EDEFAULT;
    protected static final String NAME_EDEFAULT = null;
    protected String name = NAME_EDEFAULT;
    protected static final AccessType ACCESS_TYPE_EDEFAULT = AccessType.DEFAULT_LITERAL;
    protected AccessType accessType = ACCESS_TYPE_EDEFAULT;
    protected TypeMapping typeMapping = null;
    protected EList persistentAttributes = null;
    static /* synthetic */ Class class$0;

    protected PersistentTypeImpl() {
    }

    protected PersistentTypeImpl(IPersistentTypeModelAdapter persistentTypeModelAdapter) {
        super(persistentTypeModelAdapter);
        this.typeMapping = OrmFactory.eINSTANCE.createNullTypeMapping(persistentTypeModelAdapter.createNullTypeMappingModelAdapter());
        ((InternalEObject)this.typeMapping).eInverseAdd((InternalEObject)this, -4, null, null);
    }

    protected EClass eStaticClass() {
        return OrmPackage.Literals.PERSISTENT_TYPE;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassNameGen(String newClassName) {
        String oldClassName = this.className;
        this.className = newClassName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldClassName, (Object)this.className));
        }
    }

    public void setClassName(String newClassName) {
        String oldDefaultName = this.getDefaultName();
        this.setClassNameGen(newClassName);
        String newDefaultName = this.getDefaultName();
        if (this.name == null && this.name == oldDefaultName || this.name != null && this.name.equals(oldDefaultName)) {
            this.setName(newDefaultName);
        }
    }

    public String getDefaultName() {
        return this.className == null ? "" : ClassTools.shortNameForClassNamed((String)this.className);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        String oldName = this.name;
        this.name = newName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldName, (Object)this.name));
        }
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public void setAccessTypeGen(AccessType newAccessType) {
        AccessType oldAccessType = this.accessType;
        AccessType accessType = this.accessType = newAccessType == null ? ACCESS_TYPE_EDEFAULT : newAccessType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldAccessType, (Object)this.accessType));
        }
    }

    public void setAccessType(AccessType newAccessType) {
        this.setAccessTypeGen(newAccessType);
        ((IPersistentTypeModelAdapter)this.getModelAdapter()).accessTypeChanged();
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public NotificationChain basicSetTypeMapping(TypeMapping newTypeMapping, NotificationChain msgs) {
        TypeMapping oldTypeMapping = this.typeMapping;
        this.typeMapping = newTypeMapping;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldTypeMapping, (Object)newTypeMapping);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    public void setTypeMappingGen(TypeMapping newTypeMapping) {
        if (newTypeMapping != this.typeMapping) {
            NotificationChain msgs = null;
            if (this.typeMapping != null) {
                msgs = ((InternalEObject)this.typeMapping).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newTypeMapping != null) {
                msgs = ((InternalEObject)newTypeMapping).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetTypeMapping(newTypeMapping, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newTypeMapping, (Object)newTypeMapping));
        }
    }

    public TypeMapping.Key getTypeMappingKey() {
        return this.typeMapping != null ? this.typeMapping.getKey() : null;
    }

    public void setTypeMapping(TypeMapping newTypeMapping) {
        if (this.typeMapping == newTypeMapping) {
            return;
        }
        this.setTypeMappingGen(newTypeMapping);
        this.setName(this.getDefaultName());
        newTypeMapping.initialize(this);
    }

    public void setTypeMappingKey(TypeMapping.Key typeMappingKey) {
        TypeMapping newTypeMapping;
        if (typeMappingKey.equals(this.getTypeMappingKey())) {
            return;
        }
        IPersistentTypeModelAdapter modelAdapter = (IPersistentTypeModelAdapter)this.getModelAdapter();
        if (typeMappingKey.equals(NullTypeMapping.Key.INSTANCE)) {
            newTypeMapping = OrmFactory.eINSTANCE.createNullTypeMapping(modelAdapter.createNullTypeMappingModelAdapter());
        } else if (typeMappingKey.equals(Entity.Key.INSTANCE)) {
            newTypeMapping = OrmFactory.eINSTANCE.createEntity(modelAdapter.createEntityModelAdapter());
        } else if (typeMappingKey.equals(Embeddable.Key.INSTANCE)) {
            newTypeMapping = OrmFactory.eINSTANCE.createEmbeddable(modelAdapter.createEmbeddableModelAdapter());
        } else if (typeMappingKey.equals(MappedSuperclass.Key.INSTANCE)) {
            newTypeMapping = OrmFactory.eINSTANCE.createMappedSuperclass(modelAdapter.createMappedSuperclassModelAdapter());
        } else {
            throw new IllegalArgumentException(typeMappingKey.toString());
        }
        ((ITypeMappingModelAdapter)this.getTypeMapping().getModelAdapter()).disengage();
        this.setTypeMapping(newTypeMapping);
        ((ITypeMappingModelAdapter)newTypeMapping.getModelAdapter()).engage();
    }

    public EList getPersistentAttributes() {
        if (this.persistentAttributes == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.dali.orm.PersistentAttribute");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            this.persistentAttributes = new EObjectContainmentEList((Class)clazz, (InternalEObject)this, 4);
        }
        return this.persistentAttributes;
    }

    public EList getAllPersistentAttributes() {
        ArrayList allPersistentAttributes = new ArrayList();
        PersistentType parentPersistentType = this.getParentPersistentType();
        if (parentPersistentType != null) {
            allPersistentAttributes.addAll(parentPersistentType.getAllPersistentAttributes());
        }
        allPersistentAttributes.addAll(0, this.getPersistentAttributes());
        return new BasicEList.UnmodifiableEList(allPersistentAttributes.size(), allPersistentAttributes.toArray());
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 3: {
                return this.basicSetTypeMapping(null, msgs);
            }
            case 4: {
                return ((InternalEList)this.getPersistentAttributes()).basicRemove((Object)otherEnd, msgs);
            }
            case 5: {
                return ((InternalEList)this.getAllPersistentAttributes()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getClassName();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getAccessType();
            }
            case 3: {
                return this.getTypeMapping();
            }
            case 4: {
                return this.getPersistentAttributes();
            }
            case 5: {
                return this.getAllPersistentAttributes();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setClassName((String)newValue);
                return;
            }
            case 1: {
                this.setName((String)newValue);
                return;
            }
            case 2: {
                this.setAccessType((AccessType)((Object)newValue));
                return;
            }
            case 3: {
                this.setTypeMapping((TypeMapping)newValue);
                return;
            }
            case 4: {
                this.getPersistentAttributes().clear();
                this.getPersistentAttributes().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getAllPersistentAttributes().clear();
                this.getAllPersistentAttributes().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setClassName(CLASS_NAME_EDEFAULT);
                return;
            }
            case 1: {
                this.setName(NAME_EDEFAULT);
                return;
            }
            case 2: {
                this.setAccessType(ACCESS_TYPE_EDEFAULT);
                return;
            }
            case 3: {
                this.setTypeMapping(null);
                return;
            }
            case 4: {
                this.getPersistentAttributes().clear();
                return;
            }
            case 5: {
                this.getAllPersistentAttributes().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return CLASS_NAME_EDEFAULT == null ? this.className != null : !CLASS_NAME_EDEFAULT.equals(this.className);
            }
            case 1: {
                return NAME_EDEFAULT == null ? this.name != null : !NAME_EDEFAULT.equals(this.name);
            }
            case 2: {
                return this.accessType != ACCESS_TYPE_EDEFAULT;
            }
            case 3: {
                return this.typeMapping != null;
            }
            case 4: {
                return this.persistentAttributes != null && !this.persistentAttributes.isEmpty();
            }
            case 5: {
                return !this.getAllPersistentAttributes().isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (className: ");
        result.append(this.className);
        result.append(", name: ");
        result.append(this.name);
        result.append(", accessType: ");
        result.append((Object)this.accessType);
        result.append(')');
        return result.toString();
    }

    public PersistenceSourceRefElement persistenceObjectAt(int offset) {
        return ((IPersistentTypeModelAdapter)this.getModelAdapter()).persistenceObjectAt(offset);
    }

    protected void addProblemsTo(List problems) {
        this.addMultipleVersionMappingsProblemTo(problems);
        CollectionTools.addAll((Collection)problems, (Iterator)this.getTypeMapping().problems());
        if (this.getTypeMappingKey() != NullTypeMapping.Key.INSTANCE) {
            CollectionTools.addAll((Collection)problems, (Iterator)new CompositeIterator(this.persistentAttributeProblems()));
        }
    }

    private void addMultipleVersionMappingsProblemTo(List problems) {
        int numMappings = 0;
        Iterator i = this.getPersistentAttributes().iterator();
        while (i.hasNext()) {
            PersistentAttribute attribute = (PersistentAttribute)i.next();
            if (!(attribute.getAttributeMapping() instanceof VersionMapping)) continue;
            ++numMappings;
        }
        if (numMappings > 1) {
            problems.add(this.buildProblem("Multiple Version properties are not allowed", this.getTextRange()));
        }
    }

    private Iterator persistentAttributeProblems() {
        return new TransformationIterator(this.getPersistentAttributes().iterator()){

            protected Object transform(Object next) {
                return ((PersistentAttribute)next).problems();
            }
        };
    }

    public PersistentType getParentPersistentType() {
        return ((IPersistentTypeModelAdapter)this.getModelAdapter()).getParentPersistentType();
    }
}

