/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.db;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.dali.db.Connection;
import org.eclipse.dali.db.ConnectionListener;
import org.eclipse.dali.db.Database;
import org.eclipse.dali.db.PersistenceDbPlugin;
import org.eclipse.dali.db.Schema;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.internal.utility.StringTools;
import org.eclipse.dali.internal.utility.iterators.CloneIterator;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionInfo;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionManagerListener;
import org.eclipse.wst.rdb.internal.core.connection.ConnectionSharingListener;
import org.eclipse.wst.rdb.internal.core.util.DatabaseProviderHelper;

final class RDBConnectionInfoWrapper
extends Connection {
    final ConnectionInfo rdbConnectionInfo;
    Database database;
    private boolean isConnected;
    private LocalConnectionSharingListener connectionSharingListener;
    private LocalConnectionManagerListener connectionManagerListener;
    private LocalDatabaseListener databaseListener;

    RDBConnectionInfoWrapper(ConnectionInfo rdbConnectionInfo) {
        this.rdbConnectionInfo = rdbConnectionInfo;
        this.isConnected = false;
        this.connectionSharingListener = new LocalConnectionSharingListener();
        this.rdbConnectionInfo.addConnectionSharingListener((ConnectionSharingListener)this.connectionSharingListener);
        this.connectionManagerListener = new LocalConnectionManagerListener();
        PersistenceDbPlugin.getDefault().getConnectionRepository().addListener(this.connectionManagerListener);
        this.databaseListener = new LocalDatabaseListener();
        this.rebuildDatabase();
    }

    void rebuildDatabase() {
        this.database = this.buildDatabase();
    }

    private Database buildDatabase() {
        org.eclipse.wst.rdb.internal.models.sql.schema.Database rdbDatabase = this.rdbConnectionInfo.getSharedDatabase();
        Database database = Database.createDatabase(this, rdbDatabase);
        return database;
    }

    public void connect(String userName, String password) throws Exception {
        this.rdbConnectionInfo.setUserName(userName);
        this.rdbConnectionInfo.setPassword(password);
        this.connect();
    }

    public void connect() throws Exception {
        java.sql.Connection connection = this.rdbConnectionInfo.connect();
        if (connection == null) {
            throw new RuntimeException("connection failed - user name: " + this.getUserName());
        }
        this.rdbConnectionInfo.setSharedConnection(connection);
        new DatabaseProviderHelper().setDatabase(connection, this.rdbConnectionInfo, this.getDatabaseName());
        this.saveConnectionInfo();
    }

    public void disconnect() throws SQLException {
        java.sql.Connection connection = this.rdbConnectionInfo.getSharedConnection();
        if (this.isConnected()) {
            this.rdbConnectionInfo.removeSharedDatabase();
        }
        if (connection != null) {
            this.rdbConnectionInfo.removeSharedConnection();
            connection.close();
        }
    }

    public void saveConnectionInfo() throws FileNotFoundException, IOException {
        this.rdbConnectionInfo.saveConnectionInfo();
    }

    public void connected(java.sql.Connection sqlConnection) {
        this.connectionManagerListener.connected(this.rdbConnectionInfo, sqlConnection);
    }

    public void disconnected(java.sql.Connection sqlConnection) {
        this.connectionManagerListener.disconnected(this.rdbConnectionInfo, sqlConnection);
    }

    void schemaChanged(Schema schema, Database database, int eventType) {
        this.databaseListener.schemaChanged(schema, database, eventType);
    }

    void tableChanged(Table table, Schema schema, Database database, int eventType) {
        this.databaseListener.tableChanged(table, schema, database, eventType);
    }

    public void dispose() {
        this.database.dispose();
        this.rdbConnectionInfo.removeConnectionSharingListener((ConnectionSharingListener)this.connectionSharingListener);
        PersistenceDbPlugin.getDefault().getConnectionRepository().removeListener(this.connectionManagerListener);
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    protected boolean isOffLine() {
        return this.rdbConnectionInfo.getSharedConnection() == null && this.rdbConnectionInfo.getSharedDatabase() != null;
    }

    protected boolean isOnLine() {
        return this.rdbConnectionInfo.getSharedConnection() != null;
    }

    boolean wraps(ConnectionInfo info) {
        return this.rdbConnectionInfo == info;
    }

    public String getName() {
        return this.rdbConnectionInfo.getName();
    }

    public String getUserName() {
        return this.rdbConnectionInfo.getUserName();
    }

    public String getDatabaseProductVersion() {
        return this.rdbConnectionInfo.getDatabaseProductVersion();
    }

    public String getDatabaseName() {
        return this.rdbConnectionInfo.getDatabaseName();
    }

    public Database getDatabase() {
        return this.database;
    }

    public Schema defaultSchema() {
        return this.database.schemaNamed(this.getUserName());
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.getName());
    }

    public void addConnectionListener(ConnectionListener listener) {
        this.connectionSharingListener.addConnectionListener(listener);
        this.connectionManagerListener.addConnectionListener(listener);
        this.databaseListener.addConnectionListener(listener);
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionSharingListener.removeConnectionListener(listener);
        this.connectionManagerListener.removeConnectionListener(listener);
        this.databaseListener.removeConnectionListener(listener);
    }

    private class LocalConnectionSharingListener
    implements ConnectionSharingListener {
        private Collection listeners = new Vector();

        private LocalConnectionSharingListener() {
        }

        void addConnectionListener(ConnectionListener listener) {
            this.listeners.add(listener);
        }

        void removeConnectionListener(ConnectionListener listener) {
            this.listeners.remove(listener);
        }

        public void sharedConnectionAdded(ConnectionInfo info, java.sql.Connection connection) {
            Iterator stream = this.listeners.iterator();
            while (stream.hasNext()) {
                ((ConnectionListener)stream.next()).sharedConnectionAdded(RDBConnectionInfoWrapper.this);
            }
        }

        public void sharedConnectionRemove(ConnectionInfo info, java.sql.Connection connection) {
            CloneIterator stream = new CloneIterator(this.listeners);
            while (stream.hasNext()) {
                ((ConnectionListener)stream.next()).sharedConnectionRemove(RDBConnectionInfoWrapper.this);
            }
        }

        public void sharedDatabaseAdded(ConnectionInfo info, org.eclipse.wst.rdb.internal.models.sql.schema.Database db) {
            RDBConnectionInfoWrapper.this.isConnected = true;
            RDBConnectionInfoWrapper.this.rebuildDatabase();
            Iterator stream = this.listeners.iterator();
            while (stream.hasNext()) {
                ((ConnectionListener)stream.next()).databaseAdded(RDBConnectionInfoWrapper.this, RDBConnectionInfoWrapper.this.database);
            }
        }

        public void sharedDatabaseRemove(ConnectionInfo info, org.eclipse.wst.rdb.internal.models.sql.schema.Database db) {
            Database old = RDBConnectionInfoWrapper.this.database;
            RDBConnectionInfoWrapper.this.isConnected = false;
            RDBConnectionInfoWrapper.this.rebuildDatabase();
            CloneIterator stream = new CloneIterator(this.listeners);
            while (stream.hasNext()) {
                ((ConnectionListener)stream.next()).databaseRemove(RDBConnectionInfoWrapper.this, old);
            }
            old.dispose();
        }

        public void onSQLException(ConnectionInfo info, java.sql.Connection connection, SQLException exception) {
            Iterator stream = this.listeners.iterator();
            while (stream.hasNext()) {
                ((ConnectionListener)stream.next()).onSQLException(RDBConnectionInfoWrapper.this, exception);
            }
        }
    }

    private class LocalConnectionManagerListener
    implements ConnectionManagerListener {
        private Collection listeners = new ArrayList();

        private LocalConnectionManagerListener() {
        }

        void addConnectionListener(ConnectionListener listener) {
            this.listeners.add(listener);
        }

        void removeConnectionListener(ConnectionListener listener) {
            this.listeners.remove(listener);
        }

        public void connectionInfoCreated(ConnectionInfo info) {
        }

        public void connectionInfoRemoved(String name) {
        }

        public void connectionInfoRenamed(String previousName, ConnectionInfo info) {
            if (info == RDBConnectionInfoWrapper.this.rdbConnectionInfo) {
                Iterator stream = this.listeners.iterator();
                while (stream.hasNext()) {
                    ((ConnectionListener)stream.next()).connectionInfoRenamed(previousName, RDBConnectionInfoWrapper.this);
                }
            }
        }

        public void connected(ConnectionInfo info, java.sql.Connection connection) {
            if (!RDBConnectionInfoWrapper.this.isConnected() && info == RDBConnectionInfoWrapper.this.rdbConnectionInfo) {
                RDBConnectionInfoWrapper.this.isConnected = true;
                Iterator stream = this.listeners.iterator();
                while (stream.hasNext()) {
                    ((ConnectionListener)stream.next()).connected(RDBConnectionInfoWrapper.this);
                }
            }
        }

        public void disconnected(ConnectionInfo info, java.sql.Connection connection) {
            if (RDBConnectionInfoWrapper.this.isConnected() && info == RDBConnectionInfoWrapper.this.rdbConnectionInfo) {
                RDBConnectionInfoWrapper.this.isConnected = false;
                Iterator stream = this.listeners.iterator();
                while (stream.hasNext()) {
                    ((ConnectionListener)stream.next()).disconnected(RDBConnectionInfoWrapper.this);
                }
            }
        }
    }

    private class LocalDatabaseListener {
        private Collection listeners = new ArrayList();

        private LocalDatabaseListener() {
        }

        void addConnectionListener(ConnectionListener listener) {
            this.listeners.add(listener);
        }

        void removeConnectionListener(ConnectionListener listener) {
            this.listeners.remove(listener);
        }

        public void schemaChanged(Schema schema, Database database, int eventType) {
            if (database == RDBConnectionInfoWrapper.this.database) {
                Iterator i = this.listeners.iterator();
                while (i.hasNext()) {
                    ((ConnectionListener)i.next()).schemaChanged(schema);
                }
            }
        }

        public void tableChanged(Table table, Schema schema, Database database, int eventType) {
            if (database == RDBConnectionInfoWrapper.this.database) {
                Iterator i = this.listeners.iterator();
                while (i.hasNext()) {
                    ((ConnectionListener)i.next()).tableChanged(table);
                }
            }
        }
    }
}

