/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.Iterator;
import org.eclipse.dali.core.DaliPlugin;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.AttributeMapping;
import org.eclipse.dali.orm.adapters.IAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Attribute;
import org.eclipse.dali.orm.adapters.java.IJavaAttributeMappingModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MarkerAnnotation;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.StringLiteral;

abstract class JavaAttributeMappingModelAdapter
implements IJavaAttributeMappingModelAdapter {
    private AttributeMapping attributeMapping;
    private Attribute attribute;

    protected JavaAttributeMappingModelAdapter() {
    }

    public final AttributeMapping createAttributeMapping(boolean isDefault, Attribute attribute) {
        this.attribute = attribute;
        this.attributeMapping = this.buildAttributeMapping(isDefault);
        return this.attributeMapping;
    }

    protected abstract AttributeMapping buildAttributeMapping(boolean var1);

    public final void engage(CompilationUnit astRoot) {
        this.initialize();
        this.updatePersModel(astRoot);
    }

    protected void initialize() {
    }

    protected AttributeMapping getAttributeMapping() {
        return this.attributeMapping;
    }

    protected Attribute getAttribute() {
        return this.attribute;
    }

    protected IType getType() {
        return this.getAttribute().getJDTMember().getDeclaringType();
    }

    protected String javaPersistentAttributeType(CompilationUnit astRoot) {
        Iterator i = DaliPlugin.getPlugin().possibleAnnotationsMappings();
        while (i.hasNext()) {
            String annotationName = (String)i.next();
            if (!this.containsAnnotation(annotationName, astRoot)) continue;
            return annotationName;
        }
        return null;
    }

    protected String getAnnotationElementString(String annotationElementName, CompilationUnit astRoot) {
        MemberValuePair valuePair = ASTTools.getMemberValuePair(this.attribute.bodyDeclaration(astRoot), ((IAttributeMappingModelAdapter)this.attributeMapping.getModelAdapter()).attributeMappingName(), annotationElementName);
        if (valuePair != null) {
            if (valuePair.getValue().getNodeType() == 40) {
                return ((QualifiedName)valuePair.getValue()).getName().getFullyQualifiedName();
            }
            if (valuePair.getValue().getNodeType() == 45) {
                return ((StringLiteral)valuePair.getValue()).getLiteralValue();
            }
        }
        return null;
    }

    protected void addMappingAnnotation(String mappingName) {
        this.attribute.addAnnotation(mappingName);
    }

    public Annotation getAnnotation(String annotationName, CompilationUnit astRoot) {
        return ASTTools.getAnnotation(this.attribute.bodyDeclaration(astRoot), annotationName);
    }

    public boolean containsAnnotation(String annotationName, CompilationUnit astRoot) {
        return this.getAnnotation(annotationName, astRoot) != null;
    }

    public boolean containsAnnotationElement(String annotationName, String elementName, CompilationUnit astRoot) {
        BodyDeclaration bodyDeclaration = this.attribute.bodyDeclaration(astRoot);
        if (bodyDeclaration != null) {
            return ASTTools.containsAnnotationElement(bodyDeclaration, annotationName, elementName);
        }
        return false;
    }

    public void removeAnnotation(final String annotationName) {
        this.attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                ASTTools.removeAnnotation(bodyDeclaration, annotationName);
            }
        });
    }

    public void removeAnnotationElementNamed(final String annotationName, final String elementName) {
        this.attribute.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                MemberValuePair valuePairToRemove;
                Annotation annotation = ASTTools.getAnnotation(bodyDeclaration, annotationName);
                if (annotation.isNormalAnnotation() && (valuePairToRemove = ASTTools.getMemberValuePair((NormalAnnotation)annotation, elementName)) != null) {
                    if (((NormalAnnotation)annotation).values().size() == 1) {
                        MarkerAnnotation newAnnotation = bodyDeclaration.getAST().newMarkerAnnotation();
                        newAnnotation.setTypeName((Name)bodyDeclaration.getAST().newSimpleName(annotationName));
                        ASTTools.replaceAnnotation(bodyDeclaration, annotation, (Annotation)newAnnotation);
                    } else {
                        ASTTools.removeValuePair((NormalAnnotation)annotation, valuePairToRemove);
                    }
                }
            }
        });
    }

    protected String javaSpecifiedColumn(CompilationUnit astRoot) {
        Annotation annotation = this.getAnnotation("Column", astRoot);
        if (annotation == null || !annotation.isNormalAnnotation()) {
            return null;
        }
        MemberValuePair valuePair = ASTTools.getMemberValuePair((NormalAnnotation)annotation, "name");
        if (valuePair != null && valuePair.getValue().getNodeType() == 45) {
            return ((StringLiteral)valuePair.getValue()).getLiteralValue();
        }
        return null;
    }

    public void addMappingAnnotation() {
        if (!this.attributeMapping.isDefault()) {
            this.addMappingAnnotation(this.attributeMappingName());
        }
    }

    public ITextRange getTextRange() {
        return this.getAttribute().getTextRange(this.attributeMappingName());
    }

    public void updatePersModel(CompilationUnit astRoot) {
    }

    public void postUpdatePersModel(CompilationUnit astRoot) {
    }
}

