/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.orm.adapters.java;

import java.util.List;
import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.core.util.jdt.ASTTools;
import org.eclipse.dali.orm.AttributeOverride;
import org.eclipse.dali.orm.Column;
import org.eclipse.dali.orm.adapters.IColumnModelAdapter;
import org.eclipse.dali.orm.adapters.java.JavaAttributeOverrideModelAdapter;
import org.eclipse.dali.orm.adapters.java.Member;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;

public class JavaAttributeOverrideColumnModelAdapter
implements IColumnModelAdapter {
    private Column column;
    private IColumnModelAdapter.ColumnOwner owner;
    private Member member;

    public JavaAttributeOverrideColumnModelAdapter(IColumnModelAdapter.ColumnOwner owner) {
        this.owner = owner;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    void engage(Member member, CompilationUnit astRoot) {
        this.member = member;
        this.updatePersModel(astRoot);
    }

    void updatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultName();
        this.updatePersSpecifiedName(astRoot);
        this.updatePersSpecifiedTableName(astRoot);
    }

    void postUpdatePersModel(CompilationUnit astRoot) {
        this.updatePersDefaultTableName();
    }

    private void updatePersSpecifiedName(CompilationUnit astRoot) {
        String javaValue = this.javaStringValue(astRoot, "name");
        String persValue = this.column.getSpecifiedName();
        if (javaValue == null && javaValue != persValue || javaValue != null && !javaValue.equals(persValue)) {
            this.column.setSpecifiedName(javaValue);
        }
    }

    private void updatePersDefaultName() {
        String name = this.defaultName();
        String persName = this.column.getDefaultName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultName(name);
        }
    }

    private void updatePersDefaultTableName() {
        String name = this.defaultTableName();
        String persName = this.column.getDefaultTableName();
        if (name == null && name != persName || name != null && !name.equals(persName)) {
            this.column.setDefaultTableName(name);
        }
    }

    private void updatePersSpecifiedTableName(CompilationUnit astRoot) {
        String javaValue = this.javaStringValue(astRoot, "table");
        String persValue = this.column.getSpecifiedTableName();
        if (javaValue == null && javaValue != persValue || javaValue != null && !javaValue.equals(persValue)) {
            this.column.setSpecifiedTableName(javaValue);
        }
    }

    private String defaultName() {
        AttributeOverride attributeOverride = (AttributeOverride)this.column.getParent();
        return attributeOverride.getName();
    }

    private String defaultTableName() {
        return ((IColumnModelAdapter)this.column.getModelAdapter()).getOwner().getTypeMapping().getTable().getName();
    }

    private String javaStringValue(CompilationUnit astRoot, String elementName) {
        MemberValuePair valuePair = this.columnStringValuePair(this.member.bodyDeclaration(astRoot), elementName);
        if (valuePair != null) {
            return ASTTools.stringValue(valuePair);
        }
        return null;
    }

    private MemberValuePair columnStringValuePair(BodyDeclaration bodyDeclaration, String elementName) {
        Expression columnAnnotation;
        MemberValuePair columnValuePair = this.columnValuePair(bodyDeclaration);
        if (columnValuePair != null && (columnAnnotation = columnValuePair.getValue()).getNodeType() == 77) {
            return ASTTools.getMemberValuePair((NormalAnnotation)columnAnnotation, elementName);
        }
        return null;
    }

    private MemberValuePair columnValuePair(BodyDeclaration bodyDeclaration) {
        Annotation attributeOverrideAnnotation = this.getAttributeOverrideAnnotation(bodyDeclaration);
        if (attributeOverrideAnnotation != null) {
            return ASTTools.getMemberValuePair(attributeOverrideAnnotation, "column");
        }
        return null;
    }

    private Annotation getAttributeOverrideAnnotation(BodyDeclaration bodyDeclaration) {
        return ((JavaAttributeOverrideModelAdapter)this.getAttributeOverride().getModelAdapter()).getAttributeOverrideAnnotation(bodyDeclaration);
    }

    public void specifiedNameChanged() {
        String javaName = this.javaStringValue(this.member.createASTRoot(), "name");
        String persName = this.column.getSpecifiedName();
        if (persName == null && javaName != null) {
            this.removeAttributeOverrideAnnotation();
        }
        if (persName != null && !persName.equals(javaName)) {
            this.setJavaValue(persName, "name");
        }
    }

    private void removeAttributeOverrideAnnotation() {
        this.member.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Annotation attributeOverrideAnnotation = JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverrideAnnotation(bodyDeclaration);
                ASTNode parent = attributeOverrideAnnotation.getParent();
                if (parent instanceof MemberValuePair) {
                    MemberValuePair valuePair = (MemberValuePair)parent;
                    if ((parent = valuePair.getParent()) instanceof NormalAnnotation) {
                        List list = (List)((NormalAnnotation)parent).getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
                        list.remove(valuePair);
                        if (list.isEmpty()) {
                            ASTTools.removeAnnotation(bodyDeclaration, (Annotation)((NormalAnnotation)parent));
                        }
                    }
                } else if (parent == bodyDeclaration) {
                    ASTTools.removeAnnotation(bodyDeclaration, attributeOverrideAnnotation);
                } else if (parent instanceof NormalAnnotation) {
                    List list = (List)((NormalAnnotation)parent).getStructuralProperty((StructuralPropertyDescriptor)NormalAnnotation.VALUES_PROPERTY);
                    list.remove(attributeOverrideAnnotation);
                    if (list.isEmpty()) {
                        ASTTools.removeAnnotation(bodyDeclaration, (Annotation)((NormalAnnotation)parent));
                    }
                } else if (parent instanceof ArrayInitializer) {
                    List list = (List)((ArrayInitializer)parent).getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                    list.remove(attributeOverrideAnnotation);
                    if (list.isEmpty()) {
                        if ((parent = parent.getParent()).getNodeType() == 80) {
                            parent = parent.getParent();
                        }
                        ASTTools.removeAnnotation(bodyDeclaration, (Annotation)parent);
                    }
                }
            }
        });
    }

    private void setJavaValue(final String javaValue, final String elementName) {
        this.member.editAnnotation(new Member.IAnnotationEditor(){

            public void edit(BodyDeclaration bodyDeclaration) {
                Expression columnAnnotation;
                MemberValuePair columnNameValuePair;
                AST ast = bodyDeclaration.getAST();
                MemberValuePair columnValuePair = JavaAttributeOverrideColumnModelAdapter.this.columnValuePair(bodyDeclaration);
                if (columnValuePair == null) {
                    NormalAnnotation attributeOverrideAnnotation = (NormalAnnotation)JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverrideAnnotation(bodyDeclaration);
                    if (attributeOverrideAnnotation == null) {
                        attributeOverrideAnnotation = ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), "AttributeOverride");
                        ASTTools.addLiteralMemberValuePair(attributeOverrideAnnotation, elementName, JavaAttributeOverrideColumnModelAdapter.this.getAttributeOverride().getName());
                        Annotation existingAnnotation = ASTTools.getAnnotation(bodyDeclaration, "AttributeOverride");
                        if (existingAnnotation != null) {
                            SingleMemberAnnotation overridesAnnotation = ASTTools.newSingleMemberAnnotation(ast, "AttributeOverrides");
                            ArrayInitializer array = ast.newArrayInitializer();
                            List list = (List)array.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                            ASTTools.removeAnnotation(bodyDeclaration, existingAnnotation);
                            list.add(existingAnnotation);
                            list.add(attributeOverrideAnnotation);
                            overridesAnnotation.setValue((Expression)array);
                            ASTTools.addAnnotation(bodyDeclaration, (Annotation)overridesAnnotation);
                        } else {
                            existingAnnotation = ASTTools.getAnnotation(bodyDeclaration, "AttributeOverrides");
                            if (existingAnnotation != null) {
                                if (existingAnnotation.isSingleMemberAnnotation()) {
                                    Expression expression = ((SingleMemberAnnotation)existingAnnotation).getValue();
                                    if (expression.getNodeType() == 4) {
                                        ((List)((ArrayInitializer)expression).getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY)).add(attributeOverrideAnnotation);
                                    } else {
                                        ArrayInitializer array = ast.newArrayInitializer();
                                        List list = (List)array.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                                        ((SingleMemberAnnotation)existingAnnotation).setValue((Expression)array);
                                        list.add(expression);
                                        list.add(attributeOverrideAnnotation);
                                    }
                                } else if (existingAnnotation.isNormalAnnotation()) {
                                    Expression existingValue;
                                    MemberValuePair valuePair = ASTTools.getMemberValuePair((NormalAnnotation)existingAnnotation, "value");
                                    if (valuePair == null) {
                                        valuePair = ast.newMemberValuePair();
                                        valuePair.setName(ast.newSimpleName("value"));
                                        ASTTools.addValuePair((NormalAnnotation)existingAnnotation, valuePair);
                                    }
                                    if ((existingValue = valuePair.getValue()) != null && existingValue.getNodeType() == 4) {
                                        ((List)((ArrayInitializer)existingValue).getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY)).add(attributeOverrideAnnotation);
                                    } else {
                                        ArrayInitializer array = ast.newArrayInitializer();
                                        List list = (List)array.getStructuralProperty((StructuralPropertyDescriptor)ArrayInitializer.EXPRESSIONS_PROPERTY);
                                        valuePair.setValue((Expression)array);
                                        if (existingValue != null) {
                                            list.add(existingValue);
                                        }
                                        list.add(attributeOverrideAnnotation);
                                    }
                                }
                            } else {
                                ASTTools.addAnnotation(bodyDeclaration, (Annotation)attributeOverrideAnnotation);
                            }
                        }
                    }
                    columnValuePair = bodyDeclaration.getAST().newMemberValuePair();
                    columnValuePair.setName(bodyDeclaration.getAST().newSimpleName("column"));
                    ASTTools.addValuePair(attributeOverrideAnnotation, columnValuePair);
                    NormalAnnotation columnAnnotation2 = ASTTools.newNormalAnnotation(bodyDeclaration.getAST(), "Column");
                    columnValuePair.setValue((Expression)columnAnnotation2);
                }
                if ((columnNameValuePair = ASTTools.getMemberValuePair((Annotation)(columnAnnotation = columnValuePair.getValue()), elementName)) == null) {
                    columnNameValuePair = bodyDeclaration.getAST().newMemberValuePair();
                    columnNameValuePair.setName(bodyDeclaration.getAST().newSimpleName(elementName));
                    ASTTools.addValuePair((NormalAnnotation)columnAnnotation, columnNameValuePair);
                }
                columnNameValuePair.setValue((Expression)ASTTools.newStringLiteral(bodyDeclaration.getAST(), javaValue));
            }
        });
    }

    public void specifiedTableNameChanged() {
        String javaName = this.javaStringValue(this.member.createASTRoot(), "table");
        String persName = this.column.getSpecifiedTableName();
        if (persName != null && !persName.equals(javaName)) {
            this.setJavaValue(persName, "table");
        }
    }

    private AttributeOverride getAttributeOverride() {
        return (AttributeOverride)this.column.getParent();
    }

    public ITextRange getTextRange() {
        MemberValuePair valuePair = this.columnValuePair(this.member.bodyDeclaration());
        if (valuePair != null) {
            return ASTTools.getTextRange((ASTNode)valuePair);
        }
        return this.getAttributeOverride().getTextRange();
    }

    public ITextRange nameTextRange() {
        MemberValuePair valuePair = this.columnStringValuePair(this.member.bodyDeclaration(), "name");
        if (valuePair != null) {
            return ASTTools.getTextRange((ASTNode)valuePair);
        }
        return this.getTextRange();
    }

    public ITextRange tableNameTextRange() {
        MemberValuePair valuePair = this.columnStringValuePair(this.member.bodyDeclaration(), "table");
        if (valuePair != null) {
            return ASTTools.getTextRange((ASTNode)valuePair);
        }
        return this.getTextRange();
    }

    public IColumnModelAdapter.ColumnOwner getOwner() {
        return this.owner;
    }
}

