/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.wizards;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.dali.db.Table;
import org.eclipse.dali.ui.DaliUiMessages;
import org.eclipse.dali.ui.wizards.GenerateEntitiesWizard;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

class GenerateEntitiesWizardPage
extends NewTypeWizardPage {
    private ListViewer tablesListViewer;

    GenerateEntitiesWizardPage() {
        super(true, "Generate Entities");
        this.setTitle(DaliUiMessages.GenerateEntitiesWizardPage_generateEntities);
        this.setMessage(DaliUiMessages.GenerateEntitiesWizardPage_chooseEntityTable);
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.dali.ui.dialog_generateEntities");
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        Group tablesGroup = new Group(composite, 16);
        tablesGroup.setLayout((Layout)new FillLayout());
        tablesGroup.setText(DaliUiMessages.GenerateEntitiesWizardPage_tables);
        this.tablesListViewer = new ListViewer((Composite)tablesGroup);
        this.tablesListViewer.setContentProvider(this.buildListContentProvider());
        this.tablesListViewer.setLabelProvider(this.buildListLabelProvider());
        this.tablesListViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                return ((Table)e1).getName().compareTo(((Table)e2).getName());
            }
        });
        this.tablesListViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                GenerateEntitiesWizardPage.this.handleTablesListSelectionChanged(event);
            }
        });
        GenerateEntitiesWizard generateEntitiesWizard = (GenerateEntitiesWizard)this.getWizard();
        this.tablesListViewer.setInput((Object)generateEntitiesWizard.getPossibleTables());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.tablesListViewer.getList(), "org.eclipse.dali.ui.dialog_generateEntities_tables");
        GridData data = new GridData();
        data.horizontalSpan = 4;
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        tablesGroup.setLayoutData((Object)data);
        this.setControl((Control)composite);
        this.setPageComplete(false);
    }

    void handleTablesListSelectionChanged(SelectionChangedEvent event) {
        this.setPageComplete(true);
        if (!this.hasTablesSelected()) {
            this.setPageComplete(false);
        }
    }

    private IContentProvider buildListContentProvider() {
        return new IStructuredContentProvider(){

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                return ((Collection)inputElement).toArray();
            }
        };
    }

    private IBaseLabelProvider buildListLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                return ((Table)element).getName();
            }
        };
    }

    Collection getSelectedTables() {
        return ((StructuredSelection)this.tablesListViewer.getSelection()).toList();
    }

    private boolean hasTablesSelected() {
        if (this.tablesListViewer == null) {
            return false;
        }
        return this.getSelectedTables().size() > 0;
    }

    void updateTablesListViewer(Collection possibleTables) {
        if (this.tablesListViewer != null) {
            this.tablesListViewer.setInput((Object)possibleTables);
        }
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.fPackageStatus};
        this.updateStatus(status);
    }

    protected void updateStatus(IStatus status) {
        super.updateStatus(status);
        if (this.isPageComplete() && !this.hasTablesSelected()) {
            this.setPageComplete(false);
        }
    }
}

