/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dali.ui.selection;

import org.eclipse.dali.core.ITextRange;
import org.eclipse.dali.orm.PersistenceFile;
import org.eclipse.dali.orm.PersistenceSourceRefElement;
import org.eclipse.dali.ui.PersistenceUiPlugin;
import org.eclipse.dali.ui.selection.AbstractSelectionParticipant;
import org.eclipse.dali.ui.selection.ISelectionManager;
import org.eclipse.dali.ui.selection.Selection;
import org.eclipse.dali.ui.selection.SelectionEvent;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorSelectionParticipant
extends AbstractSelectionParticipant {
    private ITextEditor editor;
    private IPropertyListener editorInputListener;
    private ISelectionChangedListener editorSelectionListener;
    private Selection currentSelection;

    public TextEditorSelectionParticipant(ISelectionManager theSelectionManager, ITextEditor theEditor) {
        super(theSelectionManager);
        this.editor = theEditor;
        this.editorInputListener = new EditorInputListener();
        this.editor.addPropertyListener(this.editorInputListener);
        this.editorSelectionListener = new EditorSelectionListener();
        ((IPostSelectionProvider)this.editor.getSelectionProvider()).addPostSelectionChangedListener(this.editorSelectionListener);
    }

    private void editorInputChanged() {
        Selection newSelection = this.getSelection();
        if (!newSelection.equals(this.currentSelection)) {
            this.currentSelection = newSelection;
            this.selectionManager.select(newSelection);
        }
    }

    private void editorSelectionChanged() {
        Selection newSelection = this.getSelection();
        if (!newSelection.equals(this.currentSelection)) {
            this.currentSelection = newSelection;
            this.selectionManager.select(newSelection);
        }
    }

    public Selection getSelection() {
        PersistenceFile pfile = PersistenceUiPlugin.getPlugin().getPersistenceManager().persistenceFileForInput(this.editor.getEditorInput());
        ISelection selection = this.editor.getSite().getSelectionProvider().getSelection();
        if (pfile == null || !(selection instanceof ITextSelection)) {
            return Selection.NULL_SELECTION;
        }
        PersistenceSourceRefElement selectedObject = pfile.persistenceObjectAt(((ITextSelection)selection).getOffset());
        return new Selection(selectedObject);
    }

    public void selectionChanged(SelectionEvent evt) {
        Selection newSelection = evt.getSelection();
        if (this.getSelection().equals(newSelection) || newSelection == Selection.NULL_SELECTION) {
            return;
        }
        PersistenceSourceRefElement selectedElement = newSelection.getSelectedElement();
        ITextRange range = selectedElement.getTextRange();
        if (range != null) {
            this.editor.selectAndReveal(range.getOffset(), range.getLength());
        }
    }

    public boolean disposeOnHide() {
        return true;
    }

    public void dispose() {
        this.editor.removePropertyListener(this.editorInputListener);
        ((IPostSelectionProvider)this.editor.getSelectionProvider()).removePostSelectionChangedListener(this.editorSelectionListener);
    }

    private class EditorInputListener
    implements IPropertyListener {
        private EditorInputListener() {
        }

        public void propertyChanged(Object source, int propId) {
            if (TextEditorSelectionParticipant.this.editor == source && propId == 258) {
                TextEditorSelectionParticipant.this.editorInputChanged();
            }
        }
    }

    private class EditorSelectionListener
    implements ISelectionChangedListener {
        private EditorSelectionListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            TextEditorSelectionParticipant.this.editorSelectionChanged();
        }
    }
}

