/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.wtp.jsf.facesconfig.editor.common.CommonPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.IStringButtonAdapter;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StatusInfo;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringButtonDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.logging.Logger;

public class PackageButtonDialogField
extends StringButtonDialogField {
    private static Logger log;
    private IPackageFragmentRoot fCurrRoot;
    private IPackageFragment fCurrPackage;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.PackageButtonDialogField");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = CommonPlugin.getLogger(clazz);
    }

    public PackageButtonDialogField(IPackageFragmentRoot packageRoot) {
        super(null);
        this.setPackageFragmentRoot(packageRoot);
        this.setLabelText(DialogFieldResources.getInstance().getString("PackageButtonDialogField.package.label"));
        this.setButtonLabel(DialogFieldResources.getInstance().getString("PackageButtonDialogField.package.button"));
        this.setStringButtonAdapter(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                PackageButtonDialogField.this.packageChangeControlPressed(field);
            }
        });
    }

    protected void packageChangeControlPressed(DialogField field) {
        IPackageFragment pack = this.choosePackage();
        if (pack != null) {
            this.setPackageFragment(pack, true);
        }
    }

    public void setPackageFragmentRoot(IPackageFragmentRoot root) {
        this.fCurrRoot = root;
        this.enableButton(this.getPackageFragmentRoot() != null);
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return this.fCurrRoot;
    }

    private IPackageFragment choosePackage() {
        IPackageFragmentRoot froot = this.getPackageFragmentRoot();
        Object[] packages = null;
        try {
            if (froot != null && froot.exists()) {
                packages = froot.getChildren();
            }
        }
        catch (JavaModelException e) {
            log.error(e);
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT));
        dialog.setIgnoreCase(false);
        dialog.setTitle(DialogFieldResources.getInstance().getString("PackageButtonDialogField.ChoosePackageDialog.title"));
        dialog.setMessage(DialogFieldResources.getInstance().getString("PackageButtonDialogField.ChoosePackageDialog.description"));
        dialog.setEmptyListMessage(DialogFieldResources.getInstance().getString("PackageButtonDialogField.ChoosePackageDialog.empty"));
        dialog.setElements(packages);
        IPackageFragment pack = this.getPackageFragment();
        if (pack != null) {
            dialog.setInitialSelections(new Object[]{pack});
        }
        if (dialog.open() == 0) {
            return (IPackageFragment)dialog.getFirstResult();
        }
        return null;
    }

    public IPackageFragment getPackageFragment() {
        return this.fCurrPackage;
    }

    public void setPackageFragment(IPackageFragment pack, boolean canBeModified) {
        this.fCurrPackage = pack;
        String str = pack == null ? "" : pack.getElementName();
        this.setText(str);
        this.setEnabled(canBeModified);
    }

    public String getPackageText() {
        return this.getText();
    }

    public IStatus getChangedStatus() {
        IPackageFragmentRoot root;
        StatusInfo status = new StatusInfo();
        String packName = this.getPackageText();
        if (packName.length() > 0) {
            IStatus val = JavaConventions.validatePackageName((String)packName);
            if (val.getSeverity() == 4) {
                status.setError(DialogFieldResources.getInstance().getString("PackageButtonDialogField.error.InvalidPackageName", val.getMessage()));
                return status;
            }
            if (val.getSeverity() == 2) {
                status.setWarning(DialogFieldResources.getInstance().getString("PackageButtonDialogField.warning.DiscouragedPackageName", val.getMessage()));
            }
        } else {
            status.setWarning(DialogFieldResources.getInstance().getString("PackageButtonDialogField.warning.DefaultPackageDiscouraged"));
        }
        if ((root = this.getPackageFragmentRoot()) != null) {
            if (root.getJavaProject().exists() && packName.length() > 0) {
                try {
                    IPath packagePath;
                    IPath rootPath = root.getPath();
                    IPath outputPath = root.getJavaProject().getOutputLocation();
                    if (rootPath.isPrefixOf(outputPath) && !rootPath.equals((Object)outputPath) && outputPath.isPrefixOf(packagePath = rootPath.append(packName.replace('.', '/')))) {
                        status.setError(DialogFieldResources.getInstance().getString("PackageButtonDialogField.error.ClashOutputLocation"));
                        return status;
                    }
                }
                catch (JavaModelException e) {
                    log.error(e);
                }
            }
            this.fCurrPackage = root.getPackageFragment(packName);
        } else {
            status.setError("");
        }
        return status;
    }
}

