/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class ImageContainer
extends Composite {
    private Image image = null;
    private boolean bCleanupImage;

    public ImageContainer(Composite parent) {
        super(parent, 0);
        this.setBackground(ColorConstants.white);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (ImageContainer.this.image != null) {
                    e.gc.drawImage(ImageContainer.this.image, 0, 0);
                }
            }
        });
        this.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                ImageContainer.this.setSize(((ImageContainer)ImageContainer.this).image.getBounds().width, ((ImageContainer)ImageContainer.this).image.getBounds().height);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ImageContainer.this.bCleanupImage && ImageContainer.this.image != null && !ImageContainer.this.image.isDisposed()) {
                    ImageContainer.this.image.dispose();
                }
            }
        });
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isCleanupImage() {
        return this.bCleanupImage;
    }

    public void setImage(Image image) {
        this.setImage(image, false);
    }

    public void setImage(Image image, boolean bCleanupImage) {
        this.image = image;
        this.bCleanupImage = bCleanupImage;
        this.setSize(image.getBounds().width, image.getBounds().height);
    }
}

