/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.SWTUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.NewPage;

public class AddLocaleWizardPage
extends NewPage {
    private static EditorResources resource = EditorResources.getInstance();
    private List existedLocaleList;
    private List itemsList;
    private Text inputText;
    private TableViewer tableViewer;
    private String newLocale;
    private static final int TEXT_MINI_WIDTH = 50;
    private static final int TABLEVIEWER_MINI_WIDTH = 50;

    public AddLocaleWizardPage(String pageName) {
        super(pageName);
        this.setTitle(resource.getString("OthersPage.Application.LocaleConfigSection.Wizard.Page.Title"));
        this.setDescription(resource.getString("OthersPage.Application.LocaleConfigSection.Wizard.Page.Description"));
    }

    public AddLocaleWizardPage(String pageName, List arrayList) {
        this(pageName);
        this.existedLocaleList = arrayList;
        Locale[] locales = Locale.getAvailableLocales();
        this.itemsList = new ArrayList(locales.length);
        int i = 0;
        int n = locales.length;
        while (i < n) {
            this.itemsList.add(locales[i].toString());
            ++i;
        }
    }

    public void createControl(Composite parent) {
        Composite composite = SWTUtils.createComposite((Composite)parent, (int)1);
        SWTUtils.createLabel((Composite)composite, (String)resource.getString("OthersPage.Application.LocaleConfigSection.Wizard.Page.LabelText"), (int)1);
        this.inputText = SWTUtils.createTextBox((Composite)composite, (int)1);
        GridData gd = new GridData(768);
        gd.widthHint = 50;
        this.inputText.setLayoutData((Object)gd);
        this.inputText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                AddLocaleWizardPage.this.newLocale = AddLocaleWizardPage.this.inputText.getText();
                AddLocaleWizardPage.this.tableViewer.resetFilters();
                AddLocaleWizardPage.this.tableViewer.addFilter((ViewerFilter)new LocaleViewerFilter(AddLocaleWizardPage.this.newLocale));
                AddLocaleWizardPage.this.tableViewer.add(AddLocaleWizardPage.this.itemsList.toArray());
                if (AddLocaleWizardPage.this.isCurrentPage()) {
                    AddLocaleWizardPage.this.getContainer().updateButtons();
                }
            }
        });
        this.createTableViewer(composite);
        this.initialize();
        this.updateStatus(null);
        this.dialogChanged();
        this.setControl((Control)composite);
    }

    private void createTableViewer(Composite composite) {
        this.tableViewer = new TableViewer(composite, 2816);
        GridData gd = new GridData(1808);
        gd.heightHint = 50;
        this.tableViewer.getControl().setLayoutData((Object)gd);
        this.tableViewer.add(this.itemsList.toArray());
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                String text;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (text = (String)selection.getFirstElement()) != null && text.length() > 0) {
                    AddLocaleWizardPage.this.newLocale = text;
                    AddLocaleWizardPage.this.inputText.setText(text);
                    if (AddLocaleWizardPage.this.isCurrentPage()) {
                        AddLocaleWizardPage.this.getContainer().updateButtons();
                    }
                }
            }
        });
    }

    public String getText() {
        return this.newLocale;
    }

    protected void dialogChanged() {
    }

    protected void initialize() {
    }

    protected boolean canFinish() {
        if (this.getText() == null || this.getText().length() == 0) {
            this.setMessage(null);
            this.setErrorMessage(null);
            return false;
        }
        if (this.existedLocaleList != null && this.existedLocaleList.contains(this.getText())) {
            this.setErrorMessage(null);
            this.setErrorMessage(resource.getString("OthersPage.Application.LocaleConfigSection.Wizard.Page.AlreadyExistsError"));
            return false;
        }
        if (this.itemsList.contains(this.getText())) {
            this.setMessage(null);
            this.setErrorMessage(null);
            return true;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        return false;
    }

    class LocaleViewerFilter
    extends ViewerFilter {
        private String locale;

        LocaleViewerFilter(String locale) {
            this.locale = locale;
        }

        public boolean select(Viewer v, Object parent, Object object) {
            if (object instanceof String) {
                if (this.locale == null || this.locale.length() == 0) {
                    return true;
                }
                String aLocale = (String)object;
                return aLocale.startsWith(this.locale);
            }
            return false;
        }
    }
}

