/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.LayoutUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StatusInfo;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.StringDialogField;
import org.eclipse.wtp.jsf.facesconfig.editor.common.guiutils.SWTUtils;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.ValueEditGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.MapEntriesRecorder;

public class MapEntryEditGroup
extends ValueEditGroup {
    private StringDialogField keyField;
    private String key;
    private MapEntriesRecorder entries;

    public MapEntryEditGroup(MapEntriesRecorder entries, String key, String valueType, String value) {
        super(valueType, value);
        this.key = key;
        this.entries = entries;
    }

    public void initialize() {
        this.keyField = new StringDialogField();
        this.keyField.setLabelText(EditorResources.getInstance().getString("MapEntryEditGroup.Key"));
        this.keyField.setDialogFieldChangeListener(this.getDefaultChangeListener());
        super.initialize();
    }

    public void refreshData() {
        this.keyField.setTextWithoutUpdate(this.key);
        super.refreshData();
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        GridData gd = new GridData(1808);
        parent.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        gl.verticalSpacing = 0;
        gl.numColumns = 1;
        gl.marginHeight = 0;
        parent.setLayout((Layout)gl);
        this.layoutKeySection(toolkit, parent);
        Composite valueSection = null;
        if (toolkit != null) {
            valueSection = toolkit.createComposite(parent);
            toolkit.paintBordersFor(valueSection);
        } else {
            valueSection = SWTUtils.createComposite((Composite)parent, (int)0);
        }
        super.layoutDialogFields(toolkit, valueSection);
    }

    public void layoutKeySection(FormToolkit toolkit, Composite parent) {
        Composite keySection = null;
        if (toolkit != null) {
            keySection = toolkit.createComposite(parent);
            toolkit.paintBordersFor(keySection);
        } else {
            keySection = SWTUtils.createComposite((Composite)parent, (int)0);
        }
        GridData gd = new GridData(768);
        keySection.setLayoutData((Object)gd);
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        keySection.setLayout((Layout)gl);
        this.keyField.doFillIntoGrid(toolkit, keySection, numberOfColumns);
        LayoutUtil.setGrabHorizontal((Control)this.keyField.getTextControl(toolkit, keySection), (boolean)true);
    }

    public IStatus[] validateDialogFields() {
        StatusInfo nameStatus = new StatusInfo();
        StatusInfo classStatus = new StatusInfo();
        IStatus[] status = new IStatus[]{nameStatus, classStatus};
        if (this.keyField.getText().length() == 0) {
            nameStatus.setError(EditorResources.getInstance().getString("MapEntryEditGroup.error.EmptyKey"));
        } else if (this.isDuplicateKey(this.keyField.getText())) {
            nameStatus.setError(EditorResources.getInstance().getString("MapEntryEditGroup.error.DuplicateKey", this.keyField.getText()));
        }
        return status;
    }

    private boolean isDuplicateKey(String newKey) {
        Iterator iter = this.entries.getMapEntries().iterator();
        while (iter.hasNext()) {
            MapEntriesRecorder.MapEntry entry = (MapEntriesRecorder.MapEntry)iter.next();
            if (!entry._key.equals(newKey)) continue;
            return true;
        }
        return false;
    }

    public String getKey() {
        return this.keyField.getText();
    }
}

