/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.dialogs;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.common.dialogfield.DialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.dialogs.IDialogFieldGroup;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedProperty;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedPropertyRecorder;

public class PropertyInitializationEditGroup
extends DialogFieldGroup
implements IDialogFieldGroup {
    private static EditorResources resource = EditorResources.getInstance();
    private Table propertyTable;
    private static final int TABLE_DEFAULT_HEIGHT = 160;
    private Composite generalSection;
    private Button addPropertyButton;
    private Button removePropertyButton;
    private Button editPropertyButton;
    private IDOMNode managedBean;

    public void initialize() {
    }

    public void refreshData() {
        this.clearGeneralClassPropertyTable();
        this.appendExisitingMangedBeansProperty();
        this.updatePropertyButtons();
    }

    public void layoutDialogFields(FormToolkit toolkit, Composite parent) {
        this.createPropertyEntry(parent, toolkit);
    }

    public IStatus[] validateDialogFields() {
        return null;
    }

    private void createPropertyEntry(Composite container, FormToolkit toolkit) {
        this.createGeneralClassPage(container, toolkit);
    }

    private void createGeneralClassPage(Composite container, FormToolkit toolkit) {
        this.generalSection = toolkit.createComposite(container);
        this.generalSection.setLayoutData((Object)new GridData(1808));
        toolkit.paintBordersFor(this.generalSection);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        gl.numColumns = 2;
        this.generalSection.setLayout((Layout)gl);
        this.createPropertyTableSection(this.generalSection, toolkit);
        this.createPropertyButtonsSection(this.generalSection, toolkit);
    }

    private void createPropertyTableSection(Composite container, FormToolkit toolkit) {
        Composite propertyContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1808);
        propertyContainer.setLayoutData((Object)gd);
        toolkit.paintBordersFor(propertyContainer);
        GridLayout gl = new GridLayout();
        propertyContainer.setLayout((Layout)gl);
        this.propertyTable = new Table(propertyContainer, 66304);
        gd = new GridData(1808);
        gd.horizontalSpan = 1;
        gd.heightHint = 160;
        this.propertyTable.setLayoutData((Object)gd);
        this.propertyTable.setHeaderVisible(true);
        this.propertyTable.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        this.propertyTable.setLayout((Layout)layout);
        TableColumn propertyCol = new TableColumn(this.propertyTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
        propertyCol.setText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.PropertyTable.Name"));
        propertyCol.setResizable(true);
        TableColumn classCol = new TableColumn(this.propertyTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
        classCol.setText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.PropertyTable.Class"));
        classCol.setResizable(true);
        TableColumn valueCol = new TableColumn(this.propertyTable, 0);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
        valueCol.setText(resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.PropertyTable.Value"));
        valueCol.setResizable(true);
        this.propertyTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertyInitializationEditGroup.this.handlePropertySelection(e);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                PropertyInitializationEditGroup.this.handlePropertySelection(e);
            }
        });
    }

    protected void handlePropertySelection(SelectionEvent e) {
        this.updatePropertyButtons();
    }

    private void updatePropertyButtons() {
        if (this.propertyTable.getSelectionCount() > 0) {
            this.editPropertyButton.setEnabled(true);
            this.removePropertyButton.setEnabled(true);
        } else {
            this.editPropertyButton.setEnabled(false);
            this.removePropertyButton.setEnabled(false);
        }
    }

    private void createPropertyButtonsSection(Composite container, FormToolkit toolkit) {
        Composite operationContainer = toolkit.createComposite(container);
        GridData gd = new GridData(1042);
        operationContainer.setLayoutData((Object)gd);
        GridLayout gl = new GridLayout();
        operationContainer.setLayout((Layout)gl);
        this.addPropertyButton = toolkit.createButton(operationContainer, resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.Button.Add.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.addPropertyButton.setLayoutData((Object)gd);
        this.editPropertyButton = toolkit.createButton(operationContainer, resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.Button.Edit.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.editPropertyButton.setLayoutData((Object)gd);
        this.removePropertyButton = toolkit.createButton(operationContainer, resource.getString("ManagedBeansPage.ManagedBeanInitializationSection.Button.Remove.Name"), 8);
        gd = new GridData(770);
        gd.grabExcessHorizontalSpace = false;
        this.removePropertyButton.setLayoutData((Object)gd);
    }

    public Button getEditButton() {
        return this.editPropertyButton;
    }

    public Button getAddButton() {
        return this.addPropertyButton;
    }

    public Button getRemoveButton() {
        return this.removePropertyButton;
    }

    public Table getPropertyTable() {
        return this.propertyTable;
    }

    private void appendExisitingMangedBeansProperty() {
        ManagedBean bean = new ManagedBean(this.managedBean);
        boolean bHasProperty = false;
        Iterator iter = bean.getManagedPropertyList().iterator();
        while (iter.hasNext()) {
            ManagedProperty beanProperty = (ManagedProperty)iter.next();
            this.addPropertyItem(beanProperty);
            bHasProperty = true;
        }
        if (bHasProperty) {
            this.propertyTable.select(0);
        }
    }

    private void addPropertyItem(ManagedProperty beanProperty) {
        TableItem item = new TableItem(this.propertyTable, 0);
        item.setText(0, beanProperty.getPropertyName());
        item.setText(1, beanProperty.getPropertyClass());
        if (beanProperty.getPropertyValueType().equalsIgnoreCase("value")) {
            item.setText(2, beanProperty.getPropertyValue());
        } else if (beanProperty.getPropertyValueType().equalsIgnoreCase("null-value")) {
            item.setText(2, "[null-value]");
        } else if (beanProperty.getPropertyValueType().equalsIgnoreCase("map-entries")) {
            ManagedPropertyRecorder propertyRecorder = new ManagedPropertyRecorder(beanProperty, new ManagedBean(this.managedBean));
            item.setText(2, propertyRecorder.getMapEntries().toString());
        } else if (beanProperty.getPropertyValueType().equalsIgnoreCase("list-entries")) {
            ManagedPropertyRecorder propertyRecorder = new ManagedPropertyRecorder(beanProperty, new ManagedBean(this.managedBean));
            item.setText(2, propertyRecorder.getListEntries().toString());
        }
        item.setData((Object)beanProperty);
    }

    private void clearGeneralClassPropertyTable() {
        this.propertyTable.removeAll();
    }

    public void setInput(Object newInput) {
        if (newInput != null && newInput instanceof IDOMNode) {
            this.managedBean = (IDOMNode)newInput;
            this.refreshData();
        }
    }

    public Object getInput() {
        return this.managedBean;
    }

    public void setPropertyName(IDOMNode node, String newName) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.propertyTable.getItem(itemIndex).setText(0, newName);
            this.propertyTable.select(itemIndex);
        }
    }

    public void setPropertyClass(IDOMNode node, String newClass) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.propertyTable.getItem(itemIndex).setText(1, newClass);
            this.propertyTable.select(itemIndex);
        }
    }

    public void setPropertyValue(IDOMNode node, String newValue) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.propertyTable.getItem(itemIndex).setText(2, newValue);
            this.propertyTable.select(itemIndex);
        }
    }

    public void removeItem(IDOMNode node) {
        int itemIndex;
        if (node != null && (itemIndex = this.findItem(node)) >= 0) {
            this.propertyTable.remove(itemIndex);
            this.propertyTable.select(itemIndex - 1);
            this.updatePropertyButtons();
        }
    }

    public void addItem(IDOMNode node) {
        if (node != null && this.findItem(node) < 0) {
            this.addPropertyItem(new ManagedProperty(node));
            this.propertyTable.select(this.propertyTable.getItemCount() - 1);
        }
    }

    protected int findItem(IDOMNode node) {
        int itemIndex = -1;
        TableItem[] items = this.propertyTable.getItems();
        int i = 0;
        while (i < this.propertyTable.getItemCount()) {
            if (((ManagedProperty)items[i].getData()).getNode() == node) {
                itemIndex = i;
                break;
            }
            ++i;
        }
        return itemIndex;
    }
}

