/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout;

import java.util.Iterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.Edge;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.EdgeList;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.Subgraph;

public class Node {
    Object[] workingData = new Object[3];
    int[] workingInts = new int[4];
    public Object data;
    boolean flag;
    public int height = 40;
    public int rowOrder = -1;
    public EdgeList incoming = new EdgeList();
    public int incomingOffset = -1;
    int index;
    int nestingIndex = -1;
    public EdgeList outgoing = new EdgeList();
    Insets padding;
    private Subgraph parent;
    int rank;
    public double sortValue;
    public int outgoingOffset = -1;
    public int width = 50;
    public int x;
    public int y;

    public Node() {
    }

    public Node(Object data) {
        this(data, null);
    }

    public Node(Subgraph parent) {
        this(null, parent);
    }

    public Node(Object data, Subgraph parent) {
        this.data = data;
        this.parent = parent;
        if (parent != null) {
            parent.addMember(this);
        }
    }

    public int getOffsetIncoming() {
        if (this.incomingOffset == -1) {
            return this.width / 2;
        }
        return this.incomingOffset;
    }

    public int getOffsetOutgoing() {
        if (this.outgoingOffset == -1) {
            return this.width / 2;
        }
        return this.outgoingOffset;
    }

    public Insets getPadding() {
        return this.padding;
    }

    public Subgraph getParent() {
        return this.parent;
    }

    boolean isNested(Node node) {
        return node == this;
    }

    public void setPadding(Insets padding) {
        this.padding = padding;
    }

    public void setParent(Subgraph parent) {
        this.parent = parent;
    }

    public void setRowConstraint(int value) {
        this.rowOrder = value;
    }

    public int getRowConstraint() {
        return this.rowOrder;
    }

    public void setSize(Dimension size) {
        this.width = size.width;
        this.height = size.height;
    }

    public String toString() {
        return "N(" + this.data + ")";
    }

    Iterator iteratorNeighbors() {
        return new Iterator(){
            int offset;
            EdgeList list;
            {
                this.list = Node.this.outgoing;
            }

            public Object next() {
                Edge edge = this.list.getEdge(this.offset++);
                if (this.offset < this.list.size()) {
                    return edge.opposite(Node.this);
                }
                if (this.list == Node.this.outgoing) {
                    this.list = Node.this.incoming;
                    this.offset = 0;
                } else {
                    this.list = null;
                }
                return edge.opposite(Node.this);
            }

            public boolean hasNext() {
                if (this.list == null) {
                    return false;
                }
                if (this.offset < this.list.size()) {
                    return true;
                }
                if (this.list == Node.this.outgoing) {
                    this.list = Node.this.incoming;
                    this.offset = 0;
                }
                return this.offset < this.list.size();
            }

            public void remove() {
                throw new RuntimeException("Remove not supported");
            }
        };
    }
}

