/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.NavigationRule;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.layout.PageflowLayoutManager;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.Pageflow;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PageflowFactory;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.PageflowModelManager;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.PageflowTransform;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.StructuredModelUtil;
import org.w3c.dom.Document;

public class FacesConfigModelAdapter
implements INodeAdapter {
    private boolean isDirtyFacesConfig = false;
    private boolean isDirtyPageflow = false;
    private PageflowModelManager pageflowManager;
    private IStructuredModel facesConfigSSEModel;
    static /* synthetic */ Class class$0;

    public void dispose() {
        this.removeNavigationRuleAdapters();
    }

    public boolean isAdapterForType(Object type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.FacesConfigModelAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return type == clazz;
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
        boolean bNeedUpdateAdapters = false;
        if (eventType == 3) {
            if (changedFeature instanceof IDOMNode) {
                if (((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("faces-config")) {
                    bNeedUpdateAdapters = true;
                }
                if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("faces-config") && ((IDOMNode)changedFeature).getNodeName().equalsIgnoreCase("navigation-rule")) {
                    bNeedUpdateAdapters = true;
                }
            }
        } else if (eventType == 2) {
            if (newValue instanceof IDOMNode) {
                if (((IDOMNode)newValue).getNodeName().equalsIgnoreCase("faces-config")) {
                    bNeedUpdateAdapters = true;
                }
                if (((IDOMNode)notifier).getNodeName().equalsIgnoreCase("faces-config") && ((IDOMNode)newValue).getNodeName().equalsIgnoreCase("navigation-rule")) {
                    bNeedUpdateAdapters = true;
                }
            }
        } else if (!(eventType != 5 && eventType != 4 || ((IDOMNode)notifier).getNodeName().equalsIgnoreCase("faces-config"))) {
            this.setFacesConfigDirty(true);
        }
        if (bNeedUpdateAdapters) {
            this.setFacesConfigDirty(true);
            this.addNavigationRuleAdapters();
        }
    }

    private void addNavigationRuleAdapters() {
        if (this.getFacesConfigModel() != null) {
            List navigationRules;
            FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)((IDOMModel)this.getFacesConfigModel()).getDocument());
            ((IDOMModel)this.getFacesConfigModel()).getDocument().addAdapter((INodeAdapter)this);
            if (documentWrap.getFacesConfig() == null) {
                return;
            }
            IDOMNode iDOMNode = documentWrap.getFacesConfig().getNode();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.FacesConfigModelAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (iDOMNode.getAdapterFor((Object)clazz) == null) {
                documentWrap.getFacesConfig().getNode().addAdapter((INodeAdapter)this);
            }
            if ((navigationRules = documentWrap.getFacesConfig().getNavigationList()) != null) {
                Iterator iter = navigationRules.iterator();
                while (iter.hasNext()) {
                    NavigationRule navigationRule = (NavigationRule)iter.next();
                    IDOMNode iDOMNode2 = navigationRule.getNode();
                    Class<?> clazz2 = class$0;
                    if (clazz2 == null) {
                        try {
                            clazz2 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils.FacesConfigModelAdapter");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StructuredModelUtil.propagateAddAdapter(iDOMNode2, this, clazz2);
                }
            }
        }
    }

    private void removeNavigationRuleAdapters() {
        if (this.getFacesConfigModel() != null) {
            FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)((IDOMModel)this.getFacesConfigModel()).getDocument());
            ((IDOMModel)this.getFacesConfigModel()).getDocument().removeAdapter((INodeAdapter)this);
            if (documentWrap.getFacesConfig() == null) {
                return;
            }
            documentWrap.getFacesConfig().getNode().removeAdapter((INodeAdapter)this);
            List navigationRules = documentWrap.getFacesConfig().getNavigationList();
            if (navigationRules != null) {
                Iterator iter = navigationRules.iterator();
                while (iter.hasNext()) {
                    NavigationRule navigationRule = (NavigationRule)iter.next();
                    StructuredModelUtil.propagateRemoveAdapter(navigationRule.getNode(), this);
                }
            }
        }
    }

    public IStructuredModel getFacesConfigModel() {
        return this.facesConfigSSEModel;
    }

    public void setFacesConfigModel(IStructuredModel model) {
        this.facesConfigSSEModel = model;
        this.addNavigationRuleAdapters();
    }

    public PageflowModelManager getPageflowManager() {
        return this.pageflowManager;
    }

    public void setPageflowManager(PageflowModelManager pageflowManager) {
        this.pageflowManager = pageflowManager;
    }

    public boolean isFacesConfigDirty() {
        return this.isDirtyFacesConfig;
    }

    public boolean isPageflowDirty() {
        return this.isDirtyPageflow;
    }

    public void setFacesConfigDirty(boolean isDirtyFacesConfig) {
        if (this.isDirtyFacesConfig != isDirtyFacesConfig) {
            this.isDirtyFacesConfig = isDirtyFacesConfig;
        }
    }

    public void setPageflowDirty(boolean dirty) {
        if (this.isDirtyPageflow != dirty) {
            this.isDirtyPageflow = dirty;
        }
    }

    public void setPageflowSynchronizeState(boolean isSynchronized) {
        if (isSynchronized) {
            this.isDirtyFacesConfig = false;
            this.isDirtyPageflow = false;
        }
    }

    public boolean updateFacesConfigFromPageflow(InputStream inputStreamOfFacesConfig) {
        if (this.facesConfigSSEModel == null) {
            return false;
        }
        PageflowTransform.getInstance().updateFacesConfigModel(this.pageflowManager.getModel(), this.facesConfigSSEModel);
        return true;
    }

    public void updatePageflowFromFacesConfig() {
        if (this.pageflowManager == null) {
            return;
        }
        if (!PageflowTransform.getInstance().updatePageflowModel(this.pageflowManager.getModel(), this.facesConfigSSEModel)) {
            return;
        }
        PageflowLayoutManager.getInstance().layoutPageflow(this.pageflowManager.getModel());
    }

    public Pageflow getPageflowFromFacesConfig() throws IOException {
        PageflowFactory factory = PageflowModelManager.getFactory();
        Pageflow pageflow = factory.createPageflow();
        if (PageflowTransform.getInstance().updatePageflowModel(pageflow, this.facesConfigSSEModel)) {
            PageflowTransform.updatePageflowModelInfo(pageflow, this.pageflowManager.getModel());
            PageflowLayoutManager.getInstance().layoutPageflow(pageflow);
            PageflowLayoutManager.getInstance().updatePageflowLayout(pageflow, this.pageflowManager.getModel());
            return pageflow;
        }
        return null;
    }
}

