/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.pageflow.utils;

import java.util.Iterator;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorResources;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFAction;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFBegin;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFEnd;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFLink;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PFPage;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.Pageflow;
import org.eclipse.wtp.jsf.facesconfig.editor.pageflow.model.PageflowNode;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.FacesConfigUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.WebrootUtil;

public class PageflowValidation {
    private static PageflowValidation instance;
    private static EditorResources resources;

    static {
        resources = EditorResources.getInstance();
    }

    private PageflowValidation() {
    }

    public static PageflowValidation getInstance() {
        if (instance == null) {
            instance = new PageflowValidation();
        }
        return instance;
    }

    public boolean isValidLinkForCreation(PageflowNode source, PageflowNode target) {
        PFLink link;
        if (source == null || target == null) {
            return false;
        }
        if (source instanceof PFPage && target instanceof PFAction && (link = source.findLinkTo(target)) != null) {
            return false;
        }
        return !(target instanceof PFBegin) && !(source instanceof PFEnd) && (!(source instanceof PFAction) || !(target instanceof PFAction));
    }

    public boolean isValidLinkForProperty(PFLink link) {
        return !(link.getSource() instanceof PFPage && link.getTarget() instanceof PFAction || link.getSource() instanceof PFBegin || link.getSource() instanceof PFEnd || link.getTarget() instanceof PFBegin || link.getTarget() instanceof PFEnd || link.getSource() instanceof PFAction && link.getTarget() instanceof PFAction);
    }

    public boolean isValidLinkForNavigationRule(PFLink link) {
        return !(link.getSource() instanceof PFBegin) && !(link.getSource() instanceof PFEnd) && !(link.getTarget() instanceof PFBegin) && !(link.getTarget() instanceof PFEnd) && (!(link.getSource() instanceof PFAction) || !(link.getTarget() instanceof PFAction));
    }

    public String isValidLink(PFLink link) {
        String outcome;
        String errorMessage = null;
        if ((!(link.getSource() instanceof PFAction) || !(link.getTarget() instanceof PFPage)) && link.getSource() instanceof PFPage && link.getTarget() instanceof PFPage && (outcome = link.getOutcome()) != null && outcome.length() >= 0) {
            String webPath = ((PFPage)link.getSource()).getPath();
            if (webPath != null) {
                String projectPath = WebrootUtil.getProjectPath(link, webPath);
                Path resourcePath = new Path(projectPath);
                IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                IResource resource = workspaceRoot.findMember((IPath)resourcePath);
                if (resource == null || !resource.exists()) {
                    errorMessage = resources.getString("Pageflow.Validation.UndefinedOutcome", outcome, webPath);
                }
            } else {
                errorMessage = resources.getString("Pageflow.Validation.MissingSourcePage");
            }
        }
        return errorMessage;
    }

    public boolean isExistedPage(Pageflow pageflow, PFPage page) {
        if (pageflow == null || page == null || page.getPath() == null) {
            return false;
        }
        return this.isExistedPage(pageflow, page.getPath());
    }

    public boolean isExistedPage(Pageflow pageflow, String pagePath) {
        if (pageflow == null || pagePath == null) {
            return false;
        }
        Iterator iter = pageflow.getNodes().iterator();
        while (iter.hasNext()) {
            PageflowNode existedNode = (PageflowNode)iter.next();
            if (!(existedNode instanceof PFPage) || ((PFPage)existedNode).getPath() == null || !((PFPage)existedNode).getPath().equalsIgnoreCase(pagePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isExistedAction(Pageflow pageflow, PFAction action) {
        if (pageflow == null || action == null || action.getAction() == null) {
            return false;
        }
        return this.isExistedAction(pageflow, action.getAction());
    }

    public boolean isExistedAction(Pageflow pageflow, String actionEL) {
        if (pageflow == null || actionEL == null) {
            return false;
        }
        Iterator iter = pageflow.getNodes().iterator();
        while (iter.hasNext()) {
            PageflowNode existedNode = (PageflowNode)iter.next();
            if (!(existedNode instanceof PFAction) || ((PFAction)existedNode).getAction() == null || !((PFAction)existedNode).getAction().equalsIgnoreCase(actionEL)) continue;
            return true;
        }
        return false;
    }

    public String isValidPage(PFPage page) {
        String errorMessage = null;
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        String pagePath = page.getPath();
        if (pagePath != null && pagePath.length() > 0) {
            String resourceName = WebrootUtil.getProjectPath(page, pagePath);
            Path resourcePath = new Path(resourceName);
            IResource resource = workspaceRoot.findMember((IPath)resourcePath);
            if (resource != null && resource.exists()) {
                if (resourcePath.getFileExtension() != null && !WebrootUtil.isValidWebFile((IPath)resourcePath)) {
                    errorMessage = resources.getString("Pageflow.Validation.InvalidWebPage", pagePath);
                }
            } else {
                errorMessage = resources.getString("Pageflow.Validation.NotExitedWebPage", pagePath);
            }
        } else {
            errorMessage = resources.getString("Pageflow.Validation.MissingWebPage");
        }
        return errorMessage;
    }

    public String isValidAction(PFAction action) {
        String errorMessage = null;
        String managedBeanName = PageflowValidation.getManagedBeanforAction(action.getAction());
        if (managedBeanName != null) {
            if (!FacesConfigUtil.isExsitedBean(WebrootUtil.getProject(action), managedBeanName)) {
                errorMessage = resources.getString("Pageflow.Validation.MissingManagedBean", managedBeanName);
            }
        } else if (action.getAction() == null || action.getAction().length() == 0) {
            errorMessage = resources.getString("Pageflow.Validation.MissingAction");
        }
        return errorMessage;
    }

    public static boolean isValidActionEL(String actionEL) {
        return actionEL != null && actionEL.length() > 3 && actionEL.substring(0, 2).equalsIgnoreCase("#{") && actionEL.substring(actionEL.length() - 1, actionEL.length()).equalsIgnoreCase("}");
    }

    public static String getManagedBeanforAction(String actionEL) {
        String managedBeanName = null;
        if (PageflowValidation.isValidActionEL(actionEL)) {
            actionEL = actionEL.substring(2, actionEL.length() - 1);
            String[] actionParts = actionEL.split("[.]");
            managedBeanName = actionParts[0];
        }
        return managedBeanName;
    }
}

