/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wtp.jsf.facesconfig.editor.EditorPlugin;
import org.eclipse.wtp.jsf.facesconfig.editor.common.logging.Logger;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.FacesConfigDocumentWrap;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedBean;
import org.eclipse.wtp.jsf.facesconfig.editor.model.xml.ManagedPropertyRecorder;
import org.eclipse.wtp.jsf.facesconfig.editor.utils.SelectionUtil;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.WizardSummaryPage;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.JavaSelectionWizardPage;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.ManagedBeanConfiguration;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.ManagedBeanPropertyWizardPage;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.NewClassWizardPage;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.NewManagedBeanWizardBase;
import org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.WizardsResources;
import org.w3c.dom.Document;

public class NewJavaManagedBeanWizard
extends NewManagedBeanWizardBase {
    private static final String PROPERTY_EMPTY_VALUE = "";
    private static final Logger log;
    private JavaSelectionWizardPage javaSourceSelectionPage;
    private NewClassWizardPage newClassPage;
    private ManagedBeanPropertyWizardPage propertyPage;
    private WizardSummaryPage summaryPage;
    private ManagedBeanConfiguration mbConfig;
    private List mbProperties;
    private boolean bCreateNewJavaClass;
    private IStructuredModel sseModel;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wtp.jsf.facesconfig.editor.wizards.managedbean.NewJavaManagedBeanWizard");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = EditorPlugin.getLogger(clazz);
    }

    public void addPages() {
        this.setDialogSettings(EditorPlugin.getDefault().getDialogSettings());
        super.addPages();
        this.javaSourceSelectionPage = new JavaSelectionWizardPage((IStructuredSelection)this.getSelection());
        this.addPage((IWizardPage)this.javaSourceSelectionPage);
        this.newClassPage = new NewClassWizardPage((IStructuredSelection)this.getSelection(), this.javaSourceSelectionPage);
        this.addPage((IWizardPage)this.newClassPage);
        this.propertyPage = new ManagedBeanPropertyWizardPage((IStructuredSelection)this.getSelection());
        this.addPage((IWizardPage)this.propertyPage);
        this.summaryPage = new WizardSummaryPage(this);
        this.addPage((IWizardPage)this.summaryPage);
        this.summaryPage.setDescription(WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.SummaryPage.Description"));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.sseModel = SelectionUtil.getModel(selection);
    }

    public boolean canFinish() {
        IWizardPage page = this.getContainer().getCurrentPage();
        return page instanceof WizardSummaryPage;
    }

    private void createJavaField(IType createdType, ManagedPropertyRecorder property) {
        if (createdType == null || property == null) {
            return;
        }
        StringBuffer strFieldContent = new StringBuffer("\t/**\n");
        strFieldContent.append("\t * property ").append(property.getPropertyName()).append("\n");
        strFieldContent.append("\t */\n");
        strFieldContent.append("\tprivate ").append(property.getPropertyClass()).append(" ").append(property.getPropertyName()).append(";\n\n");
        try {
            createdType.createField(strFieldContent.toString(), null, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            log.error("NewJavaManagedBeanWizard.Error.CreateField", (Throwable)e);
        }
    }

    private void createJavaSetMethod(IType createdType, ManagedPropertyRecorder property) {
        if (createdType == null || property == null) {
            return;
        }
        String methodName = property.getPropertyName();
        methodName = String.valueOf(methodName.substring(0, 1).toUpperCase()) + methodName.substring(1);
        StringBuffer strMethodContent = new StringBuffer("\t/**\n");
        strMethodContent.append("\t * setter method for property ").append(property.getPropertyName()).append("\n");
        strMethodContent.append("\t */\n");
        strMethodContent.append("\tpublic void set").append(methodName).append("(").append(property.getPropertyClass()).append(" ").append(property.getPropertyName()).append(")\n");
        strMethodContent.append("\t{\n");
        strMethodContent.append("\t\tthis.").append(property.getPropertyName()).append(" = ").append(property.getPropertyName()).append(";\n");
        strMethodContent.append("\t}\n\n");
        try {
            createdType.createMethod(strMethodContent.toString(), null, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            log.error("NewJavaManagedBeanWizard.Error.CreateMethod", (Throwable)e);
        }
    }

    private void createJavaGetMethod(IType createdType, ManagedPropertyRecorder property) {
        if (createdType == null || property == null) {
            return;
        }
        String methodName = property.getPropertyName();
        methodName = String.valueOf(methodName.substring(0, 1).toUpperCase()) + methodName.substring(1);
        StringBuffer strMethodContent = new StringBuffer("\t/**\n");
        strMethodContent.append("\t * getter method for property ").append(property.getPropertyName()).append("\n");
        strMethodContent.append("\t */\n");
        strMethodContent.append("\tpublic ").append(property.getPropertyClass()).append(" get").append(methodName).append("()\n");
        strMethodContent.append("\t{\n");
        strMethodContent.append("\t\treturn ").append(property.getPropertyName()).append(";\n");
        strMethodContent.append("\t}\n");
        try {
            createdType.createMethod(strMethodContent.toString(), null, false, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            log.error("NewJavaManagedBeanWizard.Error.CreateMethod", (Throwable)e);
        }
    }

    protected void doFinish(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.Task.CreateNewManagedBean"), 1);
        if (this.bCreateNewJavaClass) {
            monitor.setTaskName(WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.Task.CreateNewJavaClass"));
            this.createNewJavaClass();
            monitor.worked(1);
        }
        monitor.setTaskName(WizardsResources.getInstance().getString("NewJavaManagedBeanWizard.Task.CreateNewManagedBean"));
        this.createSSEManagedBean();
        monitor.worked(1);
    }

    protected void setupFinish() {
        this.bCreateNewJavaClass = this.javaSourceSelectionPage.isCreateNewJavaClass();
        this.getManagedBeanInfo();
    }

    public void getManagedBeanInfo() {
        this.mbConfig = this.propertyPage.getManagedBeanConfiguration();
        this.mbProperties = this.propertyPage.getManagedBeanProperty();
    }

    public void createSSEManagedBean() {
        if (this.sseModel != null) {
            FacesConfigDocumentWrap documentWrap = new FacesConfigDocumentWrap((Document)((IDOMModel)this.sseModel).getDocument());
            ManagedBean bean = documentWrap.getFacesConfig().createMangedBean();
            bean.addManagedBeanElement("managed-bean-name", this.mbConfig.getName());
            bean.addManagedBeanElement("managed-bean-class", this.mbConfig.getClassName());
            bean.addManagedBeanElement("managed-bean-scope", this.mbConfig.getScope());
            bean.addManagedBeanElement("description", this.mbConfig.getDescription());
            if (this.mbProperties != null && !this.mbProperties.isEmpty()) {
                Iterator iter = this.mbProperties.iterator();
                while (iter.hasNext()) {
                    ManagedPropertyRecorder managedPropertyRecorder = (ManagedPropertyRecorder)iter.next();
                    managedPropertyRecorder.setBean(bean);
                    managedPropertyRecorder.update();
                }
            }
        }
    }

    private void createNewJavaClass() {
        try {
            this.newClassPage.createType((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            log.info("NewJavaManagedBeanWizard.Error.CreateType", (Throwable)e);
            EditorPlugin.getAlerts().error("NewJavaManagedBeanWizard.Alert.CreateType.Title", "NewJavaManagedBeanWizard.Alert.CreateType.Description");
            return;
        }
        catch (InterruptedException e) {
            log.info("NewJavaManagedBeanWizard.Error.CreateType", (Throwable)e);
            EditorPlugin.getAlerts().error("NewJavaManagedBeanWizard.Alert.CreateType.Title", "NewJavaManagedBeanWizard.Alert.CreateType.Description");
            return;
        }
        IType createdType = this.newClassPage.getCreatedType();
        if (this.mbProperties != null && !this.mbProperties.isEmpty()) {
            Iterator iter = this.mbProperties.iterator();
            while (iter.hasNext()) {
                ManagedPropertyRecorder property = (ManagedPropertyRecorder)iter.next();
                this.createJavaField(createdType, property);
                this.createJavaSetMethod(createdType, property);
                this.createJavaGetMethod(createdType, property);
            }
        }
    }
}

