/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.jsp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jst.jsf.context.resolver.structureddocument.IStructuredDocumentContextResolverFactory;
import org.eclipse.jst.jsf.context.resolver.structureddocument.ITaglibContextResolver;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContextFactory;
import org.eclipse.jst.jsf.context.symbol.IComponentSymbol;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.context.symbol.SymbolFactory;
import org.eclipse.jst.jsf.context.symbol.plugin.SymbolsPlugin;
import org.eclipse.jst.jsf.context.symbol.source.AbstractContextSymbolFactory;
import org.eclipse.jst.jsf.designtime.DesignTimeApplicationManager;
import org.eclipse.jst.jsf.designtime.context.DTFacesContext;
import org.eclipse.jst.jsf.designtime.context.SymbolMap;
import org.eclipse.jst.jsp.core.internal.domdocument.DOMModelForJSP;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.provisional.CMAnnotationHelper;
import org.eclipse.wtp.jsf.contentmodel.annotation.internal.provisional.CMAnnotationPropertyValue;
import org.osgi.framework.Bundle;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import plugin.Activator;

public class JSPModelProcessor {
    private static final String SESSION_PROPERTY_QUALIFIER = "net.eclipse.jst.jsf.jsp";
    private static final String SESSION_PROPERTY_NAME_JSPMODELPROCESSOR = "JSPModelProcessor";
    private static final QualifiedName SESSION_PROPERTY_JSPMODELPROCESSOR_KEY = new QualifiedName("net.eclipse.jst.jsf.jsp", "JSPModelProcessor");
    private final IFile _file;
    private final DOMModelForJSP _model;
    private final ModelListener _modelListener;
    private boolean isDisposed;
    private Map _requestMap;
    private Map _sessionMap;
    private Map _applicationMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSPModelProcessor get(IFile file) throws CoreException, IOException {
        IFile iFile = file;
        synchronized (iFile) {
            JSPModelProcessor processor = (JSPModelProcessor)file.getSessionProperty(SESSION_PROPERTY_JSPMODELPROCESSOR_KEY);
            if (processor == null) {
                processor = new JSPModelProcessor(file);
                file.setSessionProperty(SESSION_PROPERTY_JSPMODELPROCESSOR_KEY, (Object)processor);
            }
            return processor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose(IFile file) {
        try {
            IFile iFile = file;
            synchronized (iFile) {
                JSPModelProcessor processor = JSPModelProcessor.get(file);
                if (processor != null && !processor.isDisposed) {
                    file.setSessionProperty(SESSION_PROPERTY_JSPMODELPROCESSOR_KEY, null);
                    processor.dispose();
                }
            }
        }
        catch (CoreException ce) {
            Platform.getLog((Bundle)Activator.getDefault().getBundle()).log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, "Problem disposing JSPModelProcessor", new Throwable(ce)));
        }
        catch (IOException ioe) {
            Platform.getLog((Bundle)Activator.getDefault().getBundle()).log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), 0, "Problem disposing JSPModelProcessor", new Throwable(ioe)));
        }
    }

    private JSPModelProcessor(IFile file) throws CoreException, IOException {
        this._model = this.getModelForFile(file);
        this._modelListener = new ModelListener();
        this._model.addModelLifecycleListener((IModelLifecycleListener)this._modelListener);
        this._file = file;
    }

    private DOMModelForJSP getModelForFile(IFile file) throws CoreException, IOException {
        IModelManager modelManager = StructuredModelManager.getModelManager();
        IStructuredModel model = modelManager.getModelForRead(file);
        if (model instanceof DOMModelForJSP) {
            return (DOMModelForJSP)model;
        }
        model.releaseFromRead();
        throw new CoreException((IStatus)new Status(4, "org.eclipse.blah", 0, "model not of expected type", new Throwable()));
    }

    private void dispose() {
        if (!this.isDisposed) {
            this._model.releaseFromRead();
            this._model.removeModelLifecycleListener((IModelLifecycleListener)this._modelListener);
            if (this._requestMap != null) {
                this._requestMap.clear();
                this._requestMap = null;
            }
            if (this._sessionMap != null) {
                this._sessionMap.clear();
                this._sessionMap = null;
            }
            if (this._applicationMap != null) {
                this._applicationMap.clear();
                this._applicationMap = null;
            }
            this.isDisposed = true;
        }
    }

    boolean isDisposed() {
        return this.isDisposed;
    }

    void refresh() {
        IStructuredDocumentContext context = IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._model.getStructuredDocument(), -1);
        ITaglibContextResolver taglibResolver = IStructuredDocumentContextResolverFactory.INSTANCE.getTaglibContextResolver(context);
        IDOMDocument document = this._model.getDocument();
        this.getApplicationMap().clear();
        this.getRequestMap().clear();
        this.getSessionMap().clear();
        long curTime = System.currentTimeMillis();
        this.recurseChildNodes(document.getChildNodes(), taglibResolver);
        long netTime = System.currentTimeMillis() - curTime;
        System.out.println("Net time to recurse document: " + netTime);
    }

    private void recurseChildNodes(NodeList nodes, ITaglibContextResolver taglibResolver) {
        int i = 0;
        while (i < nodes.getLength()) {
            Node child = nodes.item(i);
            this.processAttributes(child, taglibResolver);
            this.recurseChildNodes(child.getChildNodes(), taglibResolver);
            ++i;
        }
    }

    private void processAttributes(Node node, ITaglibContextResolver taglibResolver) {
        if (taglibResolver.hasTag(node)) {
            String uri = taglibResolver.getTagURIForNodeName(node);
            String elementName = node.getLocalName();
            int i = 0;
            while (i < node.getAttributes().getLength()) {
                Node attribute = node.getAttributes().item(i);
                this.processSymbolContrib(uri, elementName, attribute);
                this.processSetsLocale(uri, elementName, attribute);
                ++i;
            }
        }
    }

    private void processSymbolContrib(String uri, String elementName, Node attribute) {
        SymbolContribAggregator aggregator = SymbolContribAggregator.create(uri, elementName, attribute.getLocalName());
        if (aggregator != null) {
            AbstractContextSymbolFactory factory = aggregator.getFactory();
            String symbolName = attribute.getNodeValue();
            if (factory != null) {
                long curTime = System.currentTimeMillis();
                ArrayList problems = new ArrayList();
                ISymbol symbol = factory.create(symbolName, 1, (IAdaptable)IStructuredDocumentContextFactory.INSTANCE.getContext((IDocument)this._model.getStructuredDocument(), attribute), problems);
                long netTime = System.currentTimeMillis() - curTime;
                System.out.println("Time to process loadBundle: " + netTime);
                this.updateMap(symbol, aggregator.getScope());
            } else {
                IComponentSymbol componentSymbol = SymbolFactory.eINSTANCE.createIComponentSymbol();
                componentSymbol.setName(symbolName);
                this.updateMap((ISymbol)componentSymbol, aggregator.getScope());
            }
        }
    }

    private void processSetsLocale(String uri, String elementName, Node attribute) {
        DesignTimeApplicationManager dtAppMgr;
        DTFacesContext facesContext;
        LocaleSetAggregator aggregator = LocaleSetAggregator.create(uri, elementName, attribute.getLocalName());
        if (aggregator != null && (facesContext = (dtAppMgr = DesignTimeApplicationManager.getInstance(this._file.getProject())).getFacesContext(this._file)) != null) {
            facesContext.setLocaleString(attribute.getNodeValue());
        }
    }

    public Map getMapForScope(String scopeName) {
        Map map = this.getMapForScopeInternal(scopeName);
        if (map != null) {
            return Collections.unmodifiableMap(map);
        }
        return Collections.EMPTY_MAP;
    }

    private void updateMap(ISymbol symbol, String scopeName) {
        Map map = this.getMapForScopeInternal(scopeName);
        if (map != null) {
            map.put(symbol.getName(), symbol);
        } else {
            Platform.getLog((Bundle)Activator.getDefault().getBundle()).log((IStatus)new Status(4, "FacesContextPrototype", 0, "Scope not found: " + scopeName, new Throwable()));
        }
    }

    private Map getMapForScopeInternal(String scopeName) {
        if ("request".equals(scopeName)) {
            return this.getRequestMap();
        }
        if ("session".equals(scopeName)) {
            return this.getSessionMap();
        }
        if ("application".equals(scopeName)) {
            return this.getApplicationMap();
        }
        Platform.getLog((Bundle)Activator.getDefault().getBundle()).log((IStatus)new Status(4, "FacesContextPrototype", 0, "Scope not found: " + scopeName, new Throwable()));
        return null;
    }

    private Map getRequestMap() {
        if (this._requestMap == null) {
            this._requestMap = new SymbolMap();
        }
        return this._requestMap;
    }

    private Map getSessionMap() {
        if (this._sessionMap == null) {
            this._sessionMap = new SymbolMap();
        }
        return this._sessionMap;
    }

    private Map getApplicationMap() {
        if (this._applicationMap == null) {
            this._applicationMap = new SymbolMap();
        }
        return this._applicationMap;
    }

    private class ModelListener
    implements IModelLifecycleListener {
        private ModelListener() {
        }

        public void processPostModelEvent(ModelLifecycleEvent event) {
            if ((event.getType() & 4) != 0 && !JSPModelProcessor.this._model.isDirty()) {
                JSPModelProcessor.this.refresh();
            }
        }

        public void processPreModelEvent(ModelLifecycleEvent arg0) {
        }
    }

    private static class LocaleSetAggregator {
        private static final String SETS_LOCALE = "sets-locale";

        private LocaleSetAggregator() {
        }

        static LocaleSetAggregator create(String uri, String elementName, String attributeName) {
            List properties = CMAnnotationHelper.getCMAttributeProperties((String)uri, (String)elementName, (String)attributeName, (String)SETS_LOCALE);
            if (properties != null && properties.size() > 0) {
                return new LocaleSetAggregator();
            }
            return null;
        }
    }

    private static class SymbolContribAggregator {
        private static final String CONTRIBUTES_VALUE_BINDING = "contributes-value-binding";
        private static final String VALUE_BINDING_SCOPE = "value-binding-scope";
        private static final String VALUE_BINDING_SYMBOL_FACTORY = "value-binding-symbol-factory";
        private final Map _metadata = new HashMap(4);

        static SymbolContribAggregator create(String uri, String elementName, String attributeName) {
            List properties = CMAnnotationHelper.getCMAttributeProperties((String)uri, (String)elementName, (String)attributeName, (String)CONTRIBUTES_VALUE_BINDING);
            if (properties != null && properties.size() > 0) {
                CMAnnotationPropertyValue scope = null;
                CMAnnotationPropertyValue symbolFactory = null;
                properties = CMAnnotationHelper.getCMAttributeProperties((String)uri, (String)elementName, (String)attributeName, (String)VALUE_BINDING_SCOPE);
                if (properties != null && properties.size() > 0) {
                    scope = (CMAnnotationPropertyValue)properties.get(0);
                    properties = CMAnnotationHelper.getCMAttributeProperties((String)uri, (String)elementName, (String)attributeName, (String)VALUE_BINDING_SYMBOL_FACTORY);
                    if (properties != null && properties.size() > 0) {
                        symbolFactory = (CMAnnotationPropertyValue)properties.get(0);
                    }
                }
                return new SymbolContribAggregator(scope.getPropertyValue(), symbolFactory.getPropertyValue());
            }
            return null;
        }

        SymbolContribAggregator(String scope, String factory) {
            this._metadata.put("scope", scope);
            this._metadata.put("factory", factory);
        }

        public String getScope() {
            return (String)this._metadata.get("scope");
        }

        public AbstractContextSymbolFactory getFactory() {
            return (AbstractContextSymbolFactory)SymbolsPlugin.getSymbolFactories().get(this._metadata.get("factory"));
        }
    }
}

