/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.IJSFAppConfigLocater;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.IJSFAppConfigProvider;
import org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig.JSFAppConfigManager;

public abstract class AbstractJSFAppConfigLocater
implements IJSFAppConfigLocater {
    protected JSFAppConfigManager manager = null;
    protected Set configProviders = new LinkedHashSet();

    public void setJSFAppConfigManager(JSFAppConfigManager manager) {
        this.manager = manager;
    }

    public JSFAppConfigManager getJSFAppConfigManager() {
        return this.manager;
    }

    public abstract void startLocating();

    public abstract void stopLocating();

    public Set getJSFAppConfigProviders() {
        return this.configProviders;
    }

    protected boolean addConfigProvider(IJSFAppConfigProvider configProvider) {
        boolean added = this.configProviders.add(configProvider);
        if (added && this.manager != null) {
            configProvider.setJSFAppConfigLocater(this);
            this.manager.notifyJSFAppConfigProvidersChangeListeners(configProvider, 1);
        }
        return added;
    }

    protected boolean removeConfigProvider(IJSFAppConfigProvider configProvider) {
        boolean removed;
        if (configProvider != null) {
            configProvider.releaseFacesConfigModel();
        }
        if ((removed = this.configProviders.remove(configProvider)) && this.manager != null) {
            this.manager.notifyJSFAppConfigProvidersChangeListeners(configProvider, 2);
        }
        return removed;
    }

    protected void updateConfigProviders(Set newConfigProviders) {
        if (newConfigProviders != null) {
            LinkedHashSet<IJSFAppConfigProvider> oldConfigProviders = new LinkedHashSet<IJSFAppConfigProvider>();
            Iterator itConfigProviders = this.configProviders.iterator();
            while (itConfigProviders.hasNext()) {
                IJSFAppConfigProvider configProvider = (IJSFAppConfigProvider)itConfigProviders.next();
                if (newConfigProviders.remove(configProvider)) continue;
                oldConfigProviders.add(configProvider);
            }
            Iterator itOldConfigProviders = oldConfigProviders.iterator();
            while (itOldConfigProviders.hasNext()) {
                IJSFAppConfigProvider configProvider = (IJSFAppConfigProvider)itOldConfigProviders.next();
                this.removeConfigProvider(configProvider);
            }
            Iterator itNewConfigProviders = newConfigProviders.iterator();
            while (itNewConfigProviders.hasNext()) {
                IJSFAppConfigProvider configProvider = (IJSFAppConfigProvider)itNewConfigProviders.next();
                this.addConfigProvider(configProvider);
            }
        }
    }

    protected void removeAllConfigProviders() {
        this.updateConfigProviders(Collections.EMPTY_SET);
    }

    protected void finalize() {
        this.removeAllConfigProviders();
    }
}

