/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.context.symbol.impl;

import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;

final class SignatureUtil {
    SignatureUtil() {
    }

    static IType resolveType(IType owningType, String typeSignature) {
        String packageName = Signature.getSignatureQualifier((String)typeSignature);
        String typeName = Signature.getSignatureSimpleName((String)typeSignature);
        String fullName = "".equals(packageName) ? typeName : String.valueOf(packageName) + "." + typeName;
        IType resolvedType = null;
        try {
            String[][] resolved = owningType.resolveType(fullName);
            if (resolved != null && resolved.length > 0) {
                resolvedType = owningType.getJavaProject().findType(resolved[0][0], resolved[0][1]);
            }
        }
        catch (JavaModelException javaModelException) {}
        return resolvedType;
    }

    private static String resolveSignatureRelative(IType owningType, String typeSignature) {
        String packageName = Signature.getSignatureQualifier((String)typeSignature);
        String typeName = Signature.getSignatureSimpleName((String)typeSignature);
        String fullName = "".equals(packageName) ? typeName : String.valueOf(packageName) + "." + typeName;
        IType resolvedType = null;
        try {
            String[][] resolved = owningType.resolveType(fullName);
            if (resolved != null && resolved.length > 0) {
                resolvedType = owningType.getJavaProject().findType(resolved[0][0], resolved[0][1]);
            }
        }
        catch (JavaModelException javaModelException) {}
        return resolvedType != null ? Signature.createTypeSignature((String)resolvedType.getFullyQualifiedName(), (boolean)true) : typeSignature;
    }

    static String resolveTypeSignature(IType owningType, String typeSignature) {
        int sigKind = Signature.getTypeSignatureKind((String)typeSignature);
        switch (sigKind) {
            case 2: {
                return typeSignature;
            }
            case 4: {
                String elementType = Signature.getElementType((String)typeSignature);
                if (Signature.getTypeSignatureKind((String)elementType) == 2) {
                    return typeSignature;
                }
                String resolvedElementType = SignatureUtil.resolveSignatureRelative(owningType, elementType);
                String resultType = "";
                int i = 0;
                while (i < Signature.getArrayCount((String)typeSignature)) {
                    resultType = String.valueOf(resultType) + '[';
                    ++i;
                }
                return String.valueOf(resultType) + resolvedElementType;
            }
            case 1: {
                return SignatureUtil.resolveSignatureRelative(owningType, typeSignature);
            }
        }
        return typeSignature;
    }

    static String getSignature(IType type) {
        String fullyQualifiedName = type.getFullyQualifiedName();
        return Signature.createTypeSignature((String)fullyQualifiedName, (boolean)true);
    }
}

