/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.ui.common;

import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jst.ws.internal.ui.WSUIPluginMessages;
import org.eclipse.jst.ws.internal.ui.common.IFilter;
import org.eclipse.jst.ws.internal.ui.plugin.WebServiceUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class DialogResourceBrowser
extends Dialog {
    private final String INFOPOP_RESOURCE_TREE = "org.eclipse.jst.ws.ui.DRES0001";
    private IResource root_;
    private IFilter[] filters_;
    private boolean multipleSelectionEnabled_;
    private IResource[] selection_;
    private Tree resourceTree_;
    private TreeViewer fileViewer_;

    public DialogResourceBrowser(Shell shell, IResource root, IFilter filter) {
        this(shell, root, new IFilter[]{filter});
    }

    public DialogResourceBrowser(Shell shell, IResource root, IFilter[] filters) {
        super(shell);
        IResource moduleRoot = root;
        if (root instanceof IProject) {
            IProject p = (IProject)moduleRoot;
            moduleRoot = p;
        }
        this.root_ = moduleRoot == null ? ResourcesPlugin.getWorkspace().getRoot() : moduleRoot;
        this.filters_ = filters == null ? new IFilter[]{} : filters;
        this.multipleSelectionEnabled_ = false;
        this.setShellStyle(67696);
    }

    public void setMultipleSelectionEnabled(boolean multipleSelectionEnabled) {
        this.multipleSelectionEnabled_ = multipleSelectionEnabled;
    }

    public IResource[] getSelection() {
        return this.selection_;
    }

    public IResource getFirstSelection() {
        if (this.selection_ != null && this.selection_.length > 0) {
            return this.selection_[0];
        }
        return null;
    }

    protected void cancelPressed() {
        this.selection_ = null;
        this.setReturnCode(1);
        super.cancelPressed();
    }

    protected void okPressed() {
        ISelection selection = this.fileViewer_.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            this.selection_ = new IResource[structuredSelection.size()];
            int i = 0;
            Iterator it = structuredSelection.iterator();
            while (it.hasNext()) {
                Object object = it.next();
                if (!(object instanceof IResource)) continue;
                this.selection_[i++] = (IResource)object;
            }
        }
        this.setReturnCode(0);
        super.okPressed();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WSUIPluginMessages.DIALOG_TITLE_RESOURCE_BROWSER);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 300;
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)gd);
        this.resourceTree_ = this.multipleSelectionEnabled_ ? new Tree(composite, 2818) : new Tree(composite, 2820);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        gd.grabExcessHorizontalSpace = true;
        this.resourceTree_.setLayoutData((Object)gd);
        this.resourceTree_.setToolTipText(WSUIPluginMessages.TOOLTIP_RESOURCE_TREE);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.resourceTree_, "org.eclipse.jst.ws.ui.DRES0001");
        this.fileViewer_ = new TreeViewer(this.resourceTree_);
        this.fileViewer_.setContentProvider((IContentProvider)new WorkbenchContentProvider());
        this.fileViewer_.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new WorkbenchLabelProvider(), WebServiceUIPlugin.getInstance().getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fileViewer_.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentObject, Object object) {
                if (object instanceof IResource && ((IResource)object).getType() != 1) {
                    return true;
                }
                int i = 0;
                while (i < DialogResourceBrowser.this.filters_.length) {
                    if (DialogResourceBrowser.this.filters_[i].accepts(object)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }
        });
        this.fileViewer_.setInput((Object)this.root_);
        return composite;
    }
}

