/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.javascript.ui.internal.common.preferences.ui;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.javascript.core.internal.JavaScriptCorePlugin;
import org.eclipse.wst.javascript.ui.internal.common.JSCommonUIMessages;
import org.eclipse.wst.javascript.ui.internal.common.preferences.JSCommonUIPreferenceNames;
import org.eclipse.wst.javascript.ui.internal.editor.JSEditorPlugin;
import org.eclipse.wst.sse.ui.internal.preferences.ui.AbstractPreferencePage;

public class JavaScriptSourcePreferencePage
extends AbstractPreferencePage
implements ModifyListener,
SelectionListener,
IWorkbenchPreferencePage {
    protected Label fLineWidthLabel;
    protected Text fLineWidthText;
    protected Button fSplitMultiAttrs;
    protected Button fIndentUsingTabs;
    private Button fIndentUsingSpaces;
    private Spinner fIndentationSize;
    private final int MAX_INDENTATION_SIZE = 16;
    private final int MIN_INDENTATION_SIZE = 0;
    protected Button fClearAllBlankLines;
    protected Button fAutoPropose;
    protected Label fAutoProposeLabel;
    protected Text fAutoProposeText;
    protected Button fUseInferredGrammar;

    protected Preferences getModelPreferences() {
        return JavaScriptCorePlugin.getDefault().getPluginPreferences();
    }

    protected Control createContents(Composite parent) {
        Composite composite = (Composite)super.createContents(parent);
        this.createContentsForFormattingGroup(composite);
        this.createContentsForContentAssistGroup(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.wst.javascript.ui.webx0041");
        this.setSize(composite);
        this.loadPreferences();
        return composite;
    }

    protected void createContentsForContentAssistGroup(Composite parent) {
        Group contentAssistGroup = this.createGroup(parent, 2);
        contentAssistGroup.setText(JSCommonUIMessages.Content_assist_UI_);
        this.fAutoPropose = this.createCheckBox((Composite)contentAssistGroup, JSCommonUIMessages.Automatically_make_suggest_UI_);
        ((GridData)this.fAutoPropose.getLayoutData()).horizontalSpan = 2;
        this.fAutoPropose.addSelectionListener((SelectionListener)this);
        this.fAutoProposeLabel = this.createLabel((Composite)contentAssistGroup, JSCommonUIMessages.Prompt_when_these_characte_UI_);
        this.fAutoProposeText = this.createTextField((Composite)contentAssistGroup);
    }

    protected void performDefaults() {
        this.performDefaultsForContentAssistGroup();
        this.performDefaultsForFormattingGroup();
        this.validateValues();
        this.enableValues();
        super.performDefaults();
    }

    protected void performDefaultsForContentAssistGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getDefaultBoolean(JSCommonUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getDefaultString(JSCommonUIPreferenceNames.AUTO_PROPOSE_CODE));
    }

    protected void initializeValues() {
        this.initializeValuesForFormattingGroup();
        this.initializeValuesForContentAssistGroup();
    }

    protected void initializeValuesForContentAssistGroup() {
        this.fAutoPropose.setSelection(this.getPreferenceStore().getBoolean(JSCommonUIPreferenceNames.AUTO_PROPOSE));
        this.fAutoProposeText.setText(this.getPreferenceStore().getString(JSCommonUIPreferenceNames.AUTO_PROPOSE_CODE));
    }

    protected void validateValues() {
        boolean isError = false;
        String widthText = null;
        if (this.fLineWidthText != null) {
            try {
                widthText = this.fLineWidthText.getText();
                int formattingLineWidth = Integer.parseInt(widthText);
                if (formattingLineWidth < 0 || formattingLineWidth > 999) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException numberFormatException) {
                this.setInvalidInputMessage(widthText);
                this.setValid(false);
                isError = true;
            }
        }
        if (!isError) {
            this.setErrorMessage(null);
            this.setValid(true);
        }
    }

    protected void enableValues() {
        if (this.fAutoPropose != null) {
            if (this.fAutoPropose.getSelection()) {
                this.fAutoProposeLabel.setEnabled(true);
                this.fAutoProposeText.setEnabled(true);
            } else {
                this.fAutoProposeLabel.setEnabled(false);
                this.fAutoProposeText.setEnabled(false);
            }
        }
    }

    protected void storeValues() {
        this.storeValuesForContentAssistGroup();
        this.storeValuesForFormattingGroup();
    }

    protected void storeValuesForContentAssistGroup() {
        this.getPreferenceStore().setValue(JSCommonUIPreferenceNames.AUTO_PROPOSE, this.fAutoPropose.getSelection());
        this.getPreferenceStore().setValue(JSCommonUIPreferenceNames.AUTO_PROPOSE_CODE, this.fAutoProposeText.getText());
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return JSEditorPlugin.getDefault().getPreferenceStore();
    }

    protected void doSavePreferenceStore() {
        JSEditorPlugin.getDefault().savePluginPreferences();
    }

    protected void createContentsForFormattingGroup(Composite parent) {
        Group formattingGroup = this.createGroup(parent, 2);
        formattingGroup.setText(JSCommonUIMessages.Formatting_UI_);
        this.fIndentUsingTabs = this.createRadioButton((Composite)formattingGroup, JSCommonUIMessages.Indent_using_tabs);
        ((GridData)this.fIndentUsingTabs.getLayoutData()).horizontalSpan = 2;
        this.fIndentUsingSpaces = this.createRadioButton((Composite)formattingGroup, JSCommonUIMessages.Indent_using_spaces);
        ((GridData)this.fIndentUsingSpaces.getLayoutData()).horizontalSpan = 2;
        this.createLabel((Composite)formattingGroup, JSCommonUIMessages.Indentation_size);
        this.fIndentationSize = new Spinner((Composite)formattingGroup, 2056);
        GridData gd = new GridData(32);
        this.fIndentationSize.setLayoutData((Object)gd);
        this.fIndentationSize.setMinimum(0);
        this.fIndentationSize.setMaximum(16);
        this.fIndentationSize.setIncrement(1);
        this.fIndentationSize.setPageIncrement(4);
        this.fIndentationSize.addModifyListener((ModifyListener)this);
    }

    protected void performDefaultsForFormattingGroup() {
        if ("tab".equals(this.getPreferenceStore().getDefaultString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getPreferenceStore().getDefaultInt("indentationSize"));
    }

    protected void initializeValuesForFormattingGroup() {
        if ("tab".equals(this.getPreferenceStore().getString("indentationChar"))) {
            this.fIndentUsingTabs.setSelection(true);
            this.fIndentUsingSpaces.setSelection(false);
        } else {
            this.fIndentUsingSpaces.setSelection(true);
            this.fIndentUsingTabs.setSelection(false);
        }
        this.fIndentationSize.setSelection(this.getPreferenceStore().getInt("indentationSize"));
    }

    protected void storeValuesForFormattingGroup() {
        if (this.fIndentUsingTabs.getSelection()) {
            this.getPreferenceStore().setValue("indentationChar", "tab");
        } else {
            this.getPreferenceStore().setValue("indentationChar", "space");
        }
        this.getPreferenceStore().setValue("indentationSize", this.fIndentationSize.getSelection());
    }

    protected void createContentsForGrammarConstraintsGroup(Composite parent) {
    }

    protected void performDefaultsForGrammarConstraintsGroup() {
    }

    protected void initializeValuesForGrammarConstraintsGroup() {
    }

    protected void storeValuesForGrammarConstraintsGroup() {
    }

    public boolean performOk() {
        boolean result = super.performOk();
        this.doSavePreferenceStore();
        return result;
    }
}

