/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.wizard;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog2;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jst.j2ee.internal.dialogs.TypeSearchEngine;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIMessages;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.internal.datamodel.ui.DataModelWizardPage;

public class NewJavaClassOptionsWizardPage
extends DataModelWizardPage {
    protected Button publicButton;
    protected Button abstractButton;
    protected Button finalButton;
    protected ListViewer interfaceViewer;
    protected Button addButton;
    protected Button removeButton;
    protected Button inheritButton;
    protected Button constructorButton;
    protected Button mainMethodButton;

    public NewJavaClassOptionsWizardPage(IDataModel model, String pageName, String pageDesc, String pageTitle) {
        super(model, pageName);
        this.setDescription(pageDesc);
        this.setTitle(pageTitle);
        this.setInfopopID("org.eclipse.jst.j2ee.ui.NEW_JAVA_CLASS_OPTION_WIZARD_PAGE1");
    }

    protected String[] getValidationPropertyNames() {
        return new String[]{"NewJavaClassDataModel.MODIFIER_ABSTRACT", "NewJavaClassDataModel.MODIFIER_FINAL"};
    }

    protected Composite createTopLevelComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.widthHint = 300;
        composite.setLayoutData((Object)data);
        this.createModifierControls(composite);
        this.createInterfaceControls(composite);
        Label seperator = new Label(composite, 258);
        data = new GridData(256);
        data.horizontalSpan = 2;
        seperator.setLayoutData((Object)data);
        this.createStubsComposite(composite);
        this.publicButton.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, this.getInfopopID());
        return composite;
    }

    protected void createModifierControls(Composite parent) {
        Label modifiersLabel = new Label(parent, 0);
        modifiersLabel.setText(J2EEUIMessages.JAVA_CLASS_MODIFIERS_LABEL);
        modifiersLabel.setLayoutData((Object)new GridData(32));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.publicButton = new Button(composite, 32);
        this.publicButton.setText(J2EEUIMessages.JAVA_CLASS_PUBLIC_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.publicButton, "NewJavaClassDataModel.MODIFIER_PUBLIC", null);
        this.abstractButton = new Button(composite, 32);
        this.abstractButton.setText(J2EEUIMessages.JAVA_CLASS_ABSTRACT_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.abstractButton, "NewJavaClassDataModel.MODIFIER_ABSTRACT", null);
        this.finalButton = new Button(composite, 32);
        this.finalButton.setText(J2EEUIMessages.JAVA_CLASS_FINAL_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.finalButton, "NewJavaClassDataModel.MODIFIER_FINAL", null);
    }

    protected void createInterfaceControls(Composite parent) {
        Label interfaceLabel = new Label(parent, 0);
        interfaceLabel.setText(J2EEUIMessages.JAVA_CLASS_INTERFACES_LABEL);
        interfaceLabel.setLayoutData((Object)new GridData(34));
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        this.interfaceViewer = new ListViewer(composite);
        this.interfaceViewer.getList().setLayoutData((Object)new GridData(1808));
        this.interfaceViewer.setContentProvider((IContentProvider)this.getInterfaceContentProvider());
        this.interfaceViewer.setLabelProvider((IBaseLabelProvider)this.getInterfaceLabelProvider());
        this.interfaceViewer.setInput(this.model.getProperty("NewJavaClassDataModel.INTERFACES"));
        Composite buttonCompo = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonCompo.setLayout((Layout)layout);
        buttonCompo.setLayoutData((Object)new GridData(1042));
        this.addButton = new Button(buttonCompo, 8);
        this.addButton.setText(J2EEUIMessages.ADD_BUTTON_LABEL);
        this.addButton.setLayoutData((Object)new GridData(258));
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                NewJavaClassOptionsWizardPage.this.handleInterfaceAddButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton = new Button(buttonCompo, 8);
        this.removeButton.setText(J2EEUIMessages.REMOVE_BUTTON);
        this.removeButton.setLayoutData((Object)new GridData(258));
        this.removeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                NewJavaClassOptionsWizardPage.this.handleInterfaceRemoveButtonSelected();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.removeButton.setEnabled(false);
        this.interfaceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                NewJavaClassOptionsWizardPage.this.removeButton.setEnabled(!selection.isEmpty());
            }
        });
    }

    protected void createStubsComposite(Composite parent) {
        Label stubLabel = new Label(parent, 0);
        stubLabel.setText(J2EEUIMessages.JAVA_CLASS_METHOD_STUBS_LABEL);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        stubLabel.setLayoutData((Object)data);
        Composite buttonCompo = new Composite(parent, 0);
        buttonCompo.setLayout((Layout)new GridLayout());
        data = new GridData(256);
        data.horizontalSpan = 2;
        data.horizontalIndent = 15;
        buttonCompo.setLayoutData((Object)data);
        this.mainMethodButton = new Button(buttonCompo, 32);
        this.mainMethodButton.setText(J2EEUIMessages.JAVA_CLASS_MAIN_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.mainMethodButton, "NewJavaClassDataModel.MAIN_METHOD", null);
        this.inheritButton = new Button(buttonCompo, 32);
        this.inheritButton.setText(J2EEUIMessages.JAVA_CLASS_INHERIT_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.inheritButton, "NewJavaClassDataModel.ABSTRACT_METHODS", null);
        this.constructorButton = new Button(buttonCompo, 32);
        this.constructorButton.setText(J2EEUIMessages.JAVA_CLASS_CONSTRUCTOR_CHECKBOX_LABEL);
        this.synchHelper.synchCheckbox(this.constructorButton, "NewJavaClassDataModel.CONSTRUCTOR", null);
    }

    protected IStructuredContentProvider getInterfaceContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                Object[] ret = new Object[]{};
                if (inputElement instanceof ArrayList) {
                    ret = ((ArrayList)inputElement).toArray();
                }
                return ret;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        };
    }

    protected ILabelProvider getInterfaceLabelProvider() {
        return new ILabelProvider(){

            public Image getImage(Object element) {
                return J2EEUIPlugin.getDefault().getImage("full/obj16/interface_obj");
            }

            public String getText(Object element) {
                String ret = "";
                if (element instanceof String) {
                    ret = (String)element;
                }
                return ret;
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        };
    }

    protected void handleInterfaceAddButtonSelected() {
        IProject project = (IProject)this.model.getProperty("NewJavaClassDataModel.PROJECT");
        IWorkbenchWindow context = Workbench.getInstance().getActiveWorkbenchWindow();
        IJavaProject javaProject = JemProjectUtilities.getJavaProject((IProject)project);
        IJavaSearchScope scope = TypeSearchEngine.createJavaSearchScopeForAProject(javaProject, true, true);
        TypeSelectionDialog2 dialog = new TypeSelectionDialog2(this.getShell(), false, (IRunnableContext)context, scope, 6);
        dialog.setTitle(J2EEUIMessages.INTERFACE_SELECTION_DIALOG_TITLE);
        if (dialog.open() == 0) {
            IType type = (IType)dialog.getFirstResult();
            String superclassFullPath = "";
            if (type != null) {
                superclassFullPath = type.getFullyQualifiedName();
            }
            this.interfaceViewer.add((Object)superclassFullPath);
        }
        List<String> valueList = Arrays.asList(this.interfaceViewer.getList().getItems());
        this.model.setProperty("NewJavaClassDataModel.INTERFACES", valueList);
    }

    protected void handleInterfaceRemoveButtonSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.interfaceViewer.getSelection();
        List items = selection.toList();
        if (!items.isEmpty()) {
            String[] array = this.interfaceViewer.getList().getItems();
            ArrayList<String> valueList = new ArrayList<String>();
            int i = 0;
            while (i < array.length) {
                valueList.add(array[i]);
                ++i;
            }
            i = 0;
            while (i < items.size()) {
                valueList.remove(items.get(i));
                ++i;
            }
            this.interfaceViewer.setInput(valueList);
            this.model.setProperty("NewJavaClassDataModel.INTERFACES", valueList);
        }
    }
}

