/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import com.ibm.icu.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.ui.internal.catalog.ImageFactory;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;

public class XMLCatalogTreeViewer
extends TreeViewer {
    protected static Image xmlCatalogImage = ImageFactory.INSTANCE.getImage("icons/obj16/xmlcatalog_obj.gif");
    protected static Image errorImage = ImageFactory.INSTANCE.getImage("icons/ovr16/error-overlay.gif");
    protected static Image entryImage = ImageFactory.INSTANCE.getImage("icons/obj16/entry_obj.gif");
    protected static Image nextCatalogImage = ImageFactory.INSTANCE.getImage("icons/obj16/nextCatalog_obj.gif");
    protected static String ERROR_STATE_KEY = "errorstatekey";
    protected ICatalog fWorkingUserCatalog;
    protected ICatalog fSystemCatalog;
    public static String USER_SPECIFIED_ENTRIES_OBJECT = XMLCatalogMessages.UI_LABEL_USER_SPECIFIED_ENTRIES;
    public static String PLUGIN_SPECIFIED_ENTRIES_OBJECT = XMLCatalogMessages.UI_LABEL_PLUGIN_SPECIFIED_ENTRIES;

    public XMLCatalogTreeViewer(Composite parent, ICatalog workingUserCatalog, ICatalog systemCatalog) {
        super(parent, 0);
        this.fWorkingUserCatalog = workingUserCatalog;
        this.fSystemCatalog = systemCatalog;
        this.setContentProvider((IContentProvider)new CatalogEntryContentProvider());
        this.setLabelProvider((IBaseLabelProvider)new CatalogEntryLabelProvider());
    }

    public void setFilterExtensions(String[] extensions) {
        this.resetFilters();
        this.addFilter(new XMLCatalogTableViewerFilter(extensions));
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        Action action = new Action("hello"){

            public void run() {
                System.out.println("run!");
            }
        };
        menuManager.add((IAction)action);
    }

    public class CatalogEntryContentProvider
    implements ITreeContentProvider {
        protected Object[] roots = new Object[2];

        public CatalogEntryContentProvider() {
            this.roots[0] = USER_SPECIFIED_ENTRIES_OBJECT;
            this.roots[1] = PLUGIN_SPECIFIED_ENTRIES_OBJECT;
        }

        public boolean isRoot(Object object) {
            return object instanceof String || object instanceof INextCatalog;
        }

        public Object[] getElements(Object element) {
            return this.roots;
        }

        public Object[] getChildren(Object parentElement) {
            Object[] result = new Object[]{};
            if (parentElement == this.roots[0]) {
                result = this.getChildrenHelper(XMLCatalogTreeViewer.this.fWorkingUserCatalog);
            } else if (parentElement == this.roots[1]) {
                result = this.getChildrenHelper(XMLCatalogTreeViewer.this.fSystemCatalog);
            } else if (parentElement instanceof INextCatalog) {
                ICatalog nextCatalog = ((INextCatalog)parentElement).getReferencedCatalog();
                result = this.getChildrenHelper(nextCatalog);
            }
            return result;
        }

        protected Object[] getChildrenHelper(ICatalog catalog) {
            ICatalogEntry[] entries = catalog.getCatalogEntries();
            if (entries.length > 0) {
                Comparator comparator = new Comparator(this){
                    final /* synthetic */ CatalogEntryContentProvider this$1;
                    {
                        this.this$1 = catalogEntryContentProvider;
                    }

                    public int compare(Object o1, Object o2) {
                        int result = 0;
                        if (o1 instanceof ICatalogEntry && o2 instanceof ICatalogEntry) {
                            ICatalogEntry entry1 = (ICatalogEntry)o1;
                            ICatalogEntry entry2 = (ICatalogEntry)o2;
                            result = Collator.getInstance().compare(entry1.getKey(), entry2.getKey());
                        }
                        return result;
                    }
                };
                Arrays.sort(entries, comparator);
            }
            Vector<Object> result = new Vector<Object>();
            result.addAll(Arrays.asList(entries));
            INextCatalog[] nextCatalogs = catalog.getNextCatalogs();
            List<INextCatalog> nextCatalogsList = Arrays.asList(nextCatalogs);
            result.addAll(nextCatalogsList);
            return result.toArray(new ICatalogElement[result.size()]);
        }

        public Object getParent(Object element) {
            return element instanceof String ? null : USER_SPECIFIED_ENTRIES_OBJECT;
        }

        public boolean hasChildren(Object element) {
            return this.isRoot(element) ? this.getChildren(element).length > 0 : false;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object old, Object newobj) {
        }

        public boolean isDeleted(Object object) {
            return false;
        }
    }

    public class CatalogEntryLabelProvider
    extends LabelProvider {
        protected HashMap imageTable = new HashMap();

        public String getText(Object object) {
            String result = null;
            if (object instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)object;
                result = catalogEntry.getKey();
            } else if (object instanceof INextCatalog) {
                INextCatalog nextCatalog = (INextCatalog)object;
                result = nextCatalog.getCatalogLocation();
            }
            return result != null ? result : object.toString();
        }

        public Image getImage(Object object) {
            Image result = null;
            Image base = null;
            if (object instanceof String) {
                result = xmlCatalogImage;
            } else if (object instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)object;
                String uri = catalogEntry.getURI();
                IEditorRegistry er = PlatformUI.getWorkbench().getEditorRegistry();
                ImageDescriptor imageDescriptor = er.getImageDescriptor(uri);
                Image image = (Image)this.imageTable.get(imageDescriptor);
                if (image == null) {
                    image = imageDescriptor.createImage();
                    this.imageTable.put(imageDescriptor, image);
                }
                if ((base = image) != null) {
                    result = URIHelper.isReadableURI((String)uri, (boolean)true) ? base : ImageFactory.INSTANCE.createCompositeImage(base, errorImage, 3);
                }
            } else if (object instanceof INextCatalog) {
                result = nextCatalogImage;
            }
            return result;
        }
    }

    class XMLCatalogTableViewerFilter
    extends ViewerFilter {
        protected String[] extensions;

        public XMLCatalogTableViewerFilter(String[] extensions1) {
            this.extensions = extensions1;
        }

        public boolean isFilterProperty(Object element, Object property) {
            return false;
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            boolean result = false;
            if (element instanceof ICatalogEntry) {
                ICatalogEntry catalogEntry = (ICatalogEntry)element;
                int i = 0;
                while (i < this.extensions.length) {
                    if (catalogEntry.getURI().endsWith(this.extensions[i])) {
                        result = true;
                        break;
                    }
                    ++i;
                }
            } else if (element.equals(PLUGIN_SPECIFIED_ENTRIES_OBJECT) || element.equals(USER_SPECIFIED_ENTRIES_OBJECT)) {
                return true;
            }
            return result;
        }
    }
}

