/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.asd.design.editparts;

import java.util.Iterator;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDEditorPlugin;
import org.eclipse.wst.wsdl.ui.internal.asd.ASDMultiPageEditor;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.connections.CenteredConnectionAnchor;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelCellEditorLocator;
import org.eclipse.wst.wsdl.ui.internal.asd.design.directedit.LabelEditManager;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.IFeedbackHandler;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.INamedEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDLabelDirectEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ComponentReferenceConnection;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IEndPoint;

public class EndPointEditPart
extends BaseEditPart
implements IFeedbackHandler,
INamedEditPart {
    protected Label nameLabel;
    protected Label addressLabel;
    protected Figure addressBoxFigure;
    protected ComponentReferenceConnection connectionFigure;
    protected static final int MAX_ADDRESS_WIDTH = 150;
    private DirectEditManager manager;
    private Point cursorLocation;
    static /* synthetic */ Class class$0;

    protected IFigure createFigure() {
        this.figure = new Panel();
        this.figure.setBorder((Border)new MarginBorder(4));
        ToolbarLayout layout = new ToolbarLayout(false);
        layout.setStretchMinorAxis(true);
        this.figure.setLayoutManager((LayoutManager)layout);
        this.nameLabel = new Label();
        this.nameLabel.setIcon(((IEndPoint)this.getModel()).getImage());
        this.nameLabel.setLabelAlignment(1);
        this.figure.add((IFigure)this.nameLabel);
        Figure f1 = new Figure();
        f1.setBorder((Border)new MarginBorder(0, 20, 0, 0));
        f1.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.figure.add((IFigure)f1);
        this.addressBoxFigure = new RectangleFigure();
        this.addressBoxFigure.setForegroundColor(ColorConstants.lightGray);
        this.addressBoxFigure.setLayoutManager((LayoutManager)new ToolbarLayout(){

            protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
                Dimension d = super.calculatePreferredSize(container, wHint, hHint);
                d.width = Math.min(d.width, 150);
                return d;
            }
        });
        f1.add((IFigure)this.addressBoxFigure);
        this.addressLabel = new Label();
        this.addressLabel.setForegroundColor(ColorConstants.black);
        this.addressLabel.setBorder((Border)new MarginBorder(2, 6, 2, 6));
        this.addressLabel.setLabelAlignment(1);
        this.addressBoxFigure.add((IFigure)this.addressLabel);
        return this.figure;
    }

    protected void createEditPolicies() {
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ASDLabelDirectEditPolicy());
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    public void performDirectEdit(Point cursorLocation) {
        this.cursorLocation = cursorLocation;
        if (this.hitTest(this.getLabelFigure(), cursorLocation) && !this.isReadOnly()) {
            this.manager = new LabelEditManager((GraphicalEditPart)this, new LabelCellEditorLocator(this, cursorLocation));
            this.manager.show();
        } else if (this.hitTest(this.getLabelFigure(), cursorLocation) && this.isReadOnly()) {
            this.doOpenNewEditor();
        }
    }

    public Label getLabelFigure() {
        if (this.translateBounds(this.nameLabel.getBounds()).contains(this.cursorLocation)) {
            return this.nameLabel;
        }
        if (this.translateBounds(this.addressLabel.getBounds()).contains(this.cursorLocation)) {
            return this.addressLabel;
        }
        return null;
    }

    protected Rectangle translateBounds(Rectangle bounds) {
        ASDMultiPageEditor editor = (ASDMultiPageEditor)ASDEditorPlugin.getActiveEditor();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gef.GraphicalViewer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        FigureCanvas canvas = (FigureCanvas)((EditPartViewer)editor.getAdapter(clazz)).getControl();
        Point viewLocation = canvas.getViewport().getViewLocation();
        return new Rectangle(bounds.x + viewLocation.x, bounds.y + viewLocation.y, bounds.width, bounds.height);
    }

    protected Object getReferencedModel() {
        IEndPoint endPoint = (IEndPoint)this.getModel();
        return endPoint.getBinding();
    }

    protected void refreshVisuals() {
        IEndPoint endPoint = (IEndPoint)this.getModel();
        this.nameLabel.setText(endPoint.getName());
        this.addressLabel.setText(endPoint.getAddress());
        this.refreshConnections();
        super.refreshVisuals();
        if (this.isReadOnly()) {
            this.nameLabel.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
            this.addressLabel.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
        } else {
            this.nameLabel.setForegroundColor(DesignViewGraphicsConstants.labelColor);
            this.addressLabel.setForegroundColor(DesignViewGraphicsConstants.labelColor);
        }
    }

    public void activate() {
        super.activate();
        this.activateConnection();
    }

    public void deactivate() {
        super.deactivate();
        this.deactivateConnection();
    }

    protected void activateConnection() {
        if (this.createConnectionFigure() != null) {
            this.getLayer("Connection Layer").add((IFigure)this.connectionFigure);
        }
    }

    protected void deactivateConnection() {
        if (this.connectionFigure != null) {
            boolean removed = false;
            removed = this.removeConnectionFigure(this.getLayer("Connection Layer"));
            if (!removed) {
                this.removeConnectionFigure(this.getLayer("Feedback Layer"));
            }
        }
    }

    private boolean removeConnectionFigure(IFigure parent) {
        boolean contains = false;
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            IFigure fig = (IFigure)it.next();
            if (!fig.equals((Object)this.connectionFigure)) continue;
            contains = true;
            break;
        }
        if (contains) {
            parent.remove((IFigure)this.connectionFigure);
        }
        return contains;
    }

    protected boolean shouldDrawConnection() {
        AbstractGraphicalEditPart referenceTypePart;
        Object typeBeingRef = this.getReferencedModel();
        return typeBeingRef != null && (referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef)) != null;
    }

    public ComponentReferenceConnection createConnectionFigure() {
        AbstractGraphicalEditPart referenceTypePart;
        Object typeBeingRef;
        if (this.connectionFigure == null && this.shouldDrawConnection() && (typeBeingRef = this.getReferencedModel()) != null && (referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef)) != null) {
            this.connectionFigure = new ComponentReferenceConnection();
            this.refreshConnections();
        }
        return this.connectionFigure;
    }

    public void refreshConnections() {
        if (this.shouldDrawConnection()) {
            Object typeBeingRef = this.getReferencedModel();
            if (this.connectionFigure != null) {
                AbstractGraphicalEditPart referenceTypePart = (AbstractGraphicalEditPart)this.getViewer().getEditPartRegistry().get(typeBeingRef);
                this.connectionFigure.setSourceAnchor((ConnectionAnchor)new CenteredConnectionAnchor((IFigure)this.addressBoxFigure, 3, 0, 0));
                IFigure targetFigure = referenceTypePart.getFigure();
                this.connectionFigure.setTargetAnchor((ConnectionAnchor)new CenteredConnectionAnchor(targetFigure, 4, 0, 10));
                this.connectionFigure.setHighlight(false);
                this.connectionFigure.setVisible(true);
            } else {
                this.activateConnection();
            }
        } else if (this.connectionFigure != null) {
            this.connectionFigure.setVisible(false);
        }
    }

    private IFigure getFigureForFeedback() {
        return this.figure;
    }

    public void addFeedback() {
        IFigure figure = this.getFigureForFeedback();
        figure.setBackgroundColor(DesignViewGraphicsConstants.tableCellSelectionColor);
        if (this.connectionFigure != null) {
            this.connectionFigure.setHighlight(true);
            this.getLayer("Feedback Layer").add((IFigure)this.connectionFigure);
        }
    }

    public void removeFeedback() {
        IFigure figure = this.getFigureForFeedback();
        figure.setBackgroundColor(figure.getParent().getBackgroundColor());
        if (this.connectionFigure != null) {
            this.connectionFigure.setHighlight(false);
            this.getLayer("Connection Layer").add((IFigure)this.connectionFigure);
        }
    }

    public Command getSetProperLabelCommand(String newValue) {
        if (this.translateBounds(this.nameLabel.getBounds()).contains(this.cursorLocation)) {
            return ((IEndPoint)this.getModel()).getSetNameCommand(newValue);
        }
        if (this.translateBounds(this.addressLabel.getBounds()).contains(this.cursorLocation)) {
            return ((IEndPoint)this.getModel()).getSetAddressCommand(newValue);
        }
        return null;
    }
}

