/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.util;

public class ArtifactType {
    private String type;
    public static final String TYPE_ENVELOPE = "envelope";
    public static final String TYPE_MESSAGE = "message";
    public static final String TYPE_DESCRIPTION = "description";
    public static final String TYPE_DISCOVERY = "discovery";
    public static final ArtifactType ARTIFACT_TYPE_ENVELOPE = new ArtifactType("envelope");
    public static final ArtifactType ARTIFACT_TYPE_MESSAGE = new ArtifactType("message");
    public static final ArtifactType ARTIFACT_TYPE_DESCRIPTION = new ArtifactType("description");
    public static final ArtifactType ARTIFACT_TYPE_DISCOVERY = new ArtifactType("discovery");

    private ArtifactType(String type) {
        this.type = type;
    }

    public boolean isEnvelope() {
        return this.type.equals(TYPE_ENVELOPE);
    }

    public boolean isMessages() {
        return this.type.equals(TYPE_MESSAGE);
    }

    public boolean isDescription() {
        return this.type.equals(TYPE_DESCRIPTION);
    }

    public boolean isDiscovery() {
        return this.type.equals(TYPE_DISCOVERY);
    }

    public String getTypeName() {
        return this.type;
    }

    public static final ArtifactType newArtifactType(String typeName) throws RuntimeException {
        ArtifactType artifactType = null;
        if (typeName.equals(TYPE_DESCRIPTION)) {
            artifactType = ARTIFACT_TYPE_DESCRIPTION;
        } else if (typeName.equals(TYPE_MESSAGE)) {
            artifactType = ARTIFACT_TYPE_MESSAGE;
        } else if (typeName.equals(TYPE_ENVELOPE)) {
            artifactType = ARTIFACT_TYPE_ENVELOPE;
        } else if (typeName.equals(TYPE_DISCOVERY)) {
            artifactType = ARTIFACT_TYPE_DISCOVERY;
        } else {
            throw new RuntimeException("Could not create new artifact type using invalid type name: " + typeName + ".");
        }
        return artifactType;
    }
}

