/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.util;

import java.io.IOException;
import java.io.StringReader;
import java.util.Iterator;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.Text;
import org.eclipse.jst.ws.util.JspUtils;
import org.eclipse.jst.ws.util.SoapElementSaxHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SoapElementHelper {
    public static SOAPElement createSOAPElementFromXMLString(String xmlString) throws ParserConfigurationException, IOException, SAXException {
        StringReader stringReader = new StringReader(xmlString);
        InputSource inputSource = new InputSource(stringReader);
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        SAXParser parser = factory.newSAXParser();
        SoapElementSaxHandler handler = new SoapElementSaxHandler();
        parser.parse(inputSource, (DefaultHandler)handler);
        return handler.getSOAPElement();
    }

    public static String soapElementWriter(SOAPElement node, StringBuffer buffer) {
        if (node == null) {
            return "";
        }
        buffer.append(JspUtils.markup("<" + node.getElementName().getLocalName()));
        Iterator attrs = node.getAllAttributes();
        while (attrs.hasNext()) {
            Name attr = (Name)attrs.next();
            buffer.append(" " + attr.getQualifiedName() + "=\"" + JspUtils.markup(node.getAttributeValue(attr)) + "\"");
        }
        buffer.append(JspUtils.markup(">"));
        Iterator children = node.getChildElements();
        if (children != null) {
            while (children.hasNext()) {
                Node childNode = (Node)children.next();
                if (childNode instanceof SOAPElement) {
                    buffer.append("<br>");
                    SoapElementHelper.soapElementWriter((SOAPElement)childNode, buffer);
                    continue;
                }
                buffer.append(JspUtils.markup(((Text)childNode).getValue()));
            }
            buffer.append(JspUtils.markup("</" + node.getElementName().getLocalName() + ">"));
        }
        return buffer.toString();
    }
}

