/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.archive.operations;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jem.util.emf.workbench.WorkbenchByteArrayOutputStream;
import org.eclipse.jem.util.logger.proxy.Logger;
import org.eclipse.jem.workbench.utility.JemProjectUtilities;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveUtil;
import org.eclipse.jst.j2ee.internal.archive.operations.ComponentSaveStrategyImpl;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;

public abstract class J2EEComponentSaveStrategyImpl
extends ComponentSaveStrategyImpl {
    protected Map importedClassFiles;
    protected IFolder importedClassesFolder;

    public J2EEComponentSaveStrategyImpl(IVirtualComponent vComponent) {
        super(vComponent);
    }

    protected void saveFiles() throws SaveFailureException {
        this.setImportedClassFilesIfNecessary();
        super.saveFiles();
        this.linkImportedClassesFolderIfNecessary();
    }

    public boolean endsWithClassType(String aFileName) {
        return aFileName.endsWith(".class");
    }

    protected boolean shouldSave(File aFile) {
        String uri = aFile.getURI();
        if (this.endsWithClassType(uri)) {
            return false;
        }
        return super.shouldSave(aFile);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void save(ArchiveManifest aManifest) throws SaveFailureException {
        IVirtualFolder rootFolder = this.vComponent.getRootFolder();
        IVirtualFile vFile = rootFolder.getFile((IPath)new Path("META-INF/MANIFEST.MF"));
        IFile iFile = vFile.getUnderlyingFile();
        this.validateEdit(iFile);
        WorkbenchByteArrayOutputStream out = new WorkbenchByteArrayOutputStream(iFile);
        try {
            try {
                aManifest.write((OutputStream)out);
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                out.close();
                throw throwable;
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException e) {
            Logger.getLogger().logError((Throwable)e);
            return;
        }
        out.close();
    }

    protected void linkImportedClassesFolderIfNecessary() {
        if (this.importedClassesFolder != null) {
            try {
                this.vComponent.getRootFolder().getFolder(this.getImportedClassesRuntimePath()).createLink(this.importedClassesFolder.getProjectRelativePath(), 0, null);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void setImportedClassFilesIfNecessary() throws SaveFailureException {
        Map classFiles = this.getClassFilesWithoutSource();
        if (classFiles == null) return;
        if (classFiles.isEmpty()) {
            return;
        }
        this.importedClassFiles = classFiles;
        IContainer jarParent = this.vComponent.getRootFolder().getUnderlyingFolder().getParent();
        String folderName = "ImportedClasses";
        this.importedClassesFolder = jarParent.getFolder((IPath)new Path(folderName));
        try {
            this.importedClassesFolder.create(true, true, null);
        }
        catch (CoreException e1) {
            Logger.getLogger().logError((Throwable)e1);
        }
        IJavaProject javaProject = null;
        try {
            try {
                Iterator keys = this.importedClassFiles.keySet().iterator();
                String uri = null;
                File file = null;
                IFile iFile = null;
                InputStream inputStream = null;
                while (true) {
                    Object var11_16;
                    block20: {
                        if (keys.hasNext()) break block20;
                        this.importedClassesFolder.refreshLocal(2, null);
                        if (this.shouldAddImportedClassesToClasspath() && JemProjectUtilities.getJavaProject((IProject)this.vComponent.getProject()) != null) {
                            javaProject = JavaCore.create((IProject)this.vComponent.getProject());
                            IClasspathEntry[] javaClasspath = javaProject.getRawClasspath();
                            IClasspathEntry[] newJavaClasspath = new IClasspathEntry[javaClasspath.length + 1];
                            System.arraycopy(javaClasspath, 0, newJavaClasspath, 0, javaClasspath.length);
                            newJavaClasspath[newJavaClasspath.length - 1] = JavaCore.newLibraryEntry((IPath)this.importedClassesFolder.getFullPath(), null, null, (boolean)true);
                            javaProject.setRawClasspath(newJavaClasspath, (IProgressMonitor)new NullProgressMonitor());
                        }
                        break;
                    }
                    uri = (String)keys.next();
                    file = (File)this.importedClassFiles.get(uri);
                    try {
                        try {
                            iFile = this.importedClassesFolder.getFile((IPath)new Path(uri));
                            inputStream = file.getInputStream();
                            this.saveToIFile(iFile, inputStream);
                        }
                        catch (Exception e) {
                            Logger.getLogger().logError((Throwable)e);
                        }
                    }
                    catch (Throwable throwable) {
                        var11_16 = null;
                        if (inputStream == null) throw throwable;
                        inputStream.close();
                        throw throwable;
                    }
                    {
                        var11_16 = null;
                        if (inputStream == null) continue;
                    }
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (JavaModelException e) {
                Logger.getLogger().logError((Throwable)e);
            }
            catch (CoreException e) {
                Logger.getLogger().logError((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            try {
                if (javaProject == null) throw throwable;
                javaProject.getProject().refreshLocal(2, null);
                throw throwable;
            }
            catch (CoreException ex) {
                Logger.getLogger().logError((Throwable)ex);
            }
            throw throwable;
        }
        {
            Object var13_20 = null;
        }
        try {}
        catch (CoreException ex) {
            Logger.getLogger().logError((Throwable)ex);
            return;
        }
        if (javaProject == null) return;
        javaProject.getProject().refreshLocal(2, null);
    }

    protected boolean shouldAddImportedClassesToClasspath() {
        return true;
    }

    protected IPath getImportedClassesRuntimePath() {
        return new Path("/");
    }

    protected Map getClassFilesWithoutSource() {
        EList files = this.archive.getFiles();
        HashMap<String, File> result = new HashMap<String, File>();
        int i = 0;
        while (i < files.size()) {
            File aFile = (File)files.get(i);
            if (this.isClassWithoutSource(aFile)) {
                result.put(this.getImportedClassesURI(aFile), aFile);
            }
            ++i;
        }
        return result;
    }

    protected String getImportedClassesURI(File aFile) {
        return aFile.getURI();
    }

    protected boolean isClassWithoutSource(File aFile) {
        String javaUri = ArchiveUtil.classUriToJavaUri((String)aFile.getURI());
        if (javaUri == null) {
            return false;
        }
        return !this.archive.containsFile(javaUri);
    }
}

