/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.core.search;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.common.core.search.ISearchOptions;
import org.eclipse.wst.common.core.search.SearchParticipant;
import org.eclipse.wst.common.core.search.SearchPlugin;
import org.eclipse.wst.common.core.search.SearchRequestor;
import org.eclipse.wst.common.core.search.document.SearchDocumentSet;
import org.eclipse.wst.common.core.search.internal.Messages;
import org.eclipse.wst.common.core.search.internal.SearchDocumentSetImpl;
import org.eclipse.wst.common.core.search.pattern.SearchPattern;
import org.eclipse.wst.common.core.search.scope.SearchScope;

public class SearchEngine
implements ISearchOptions {
    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void search(SearchPattern pattern, SearchRequestor requestor, SearchParticipant[] participants, SearchScope scope, Map searchOptions, IProgressMonitor monitor) throws CoreException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (monitor != null) {
            monitor.beginTask(Messages.engine_searching, 100);
        }
        SearchDocumentSetImpl set = new SearchDocumentSetImpl();
        try {
            SubProgressMonitor subMonitor;
            SearchParticipant participant;
            int l;
            SearchScope[] scopeArray = new SearchScope[participants.length];
            int i = 0;
            int n = l = participants == null ? 0 : participants.length;
            while (true) {
                if (i >= l) {
                    i = 0;
                    int n2 = l = participants == null ? 0 : participants.length;
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                participant = participants[i];
                SubProgressMonitor subProgressMonitor = subMonitor = monitor == null ? null : new SubProgressMonitor(monitor, 1000);
                if (subMonitor != null) {
                    subMonitor.beginTask("", 1000);
                }
                try {
                    SearchScope newScope;
                    if (subMonitor != null) {
                        subMonitor.subTask(Messages.bind((String)Messages.engine_searching_locatingDocuments, (Object[])new String[]{participant.getDescription()}));
                    }
                    participant.beginSearching(pattern, searchOptions);
                    scopeArray[i] = newScope = participant.selectDocumentLocations(pattern, scope, searchOptions, monitor);
                    participant.createSearchDocuments(set, pattern, newScope, searchOptions, (IProgressMonitor)subMonitor);
                }
                catch (Exception exception) {}
                ++i;
            }
            while (i < l) {
                Object var13_13;
                if (monitor != null && monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                participant = participants[i];
                SubProgressMonitor subProgressMonitor = subMonitor = monitor == null ? null : new SubProgressMonitor(monitor, 1000);
                if (subMonitor != null && subMonitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                try {
                    if (subMonitor != null) {
                        subMonitor.subTask(Messages.bind((String)Messages.engine_searching_matching, (Object[])new String[]{participant.getDescription()}));
                    }
                    participant.locateMatches(set, pattern, scopeArray[i], requestor, searchOptions, (IProgressMonitor)subMonitor);
                }
                catch (Throwable throwable) {
                    var13_13 = null;
                    participant.doneSearching(pattern, searchOptions);
                    throw throwable;
                }
                {
                    var13_13 = null;
                    participant.doneSearching(pattern, searchOptions);
                    ++i;
                }
            }
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            ((SearchDocumentSet)set).dispose();
            if (monitor == null) throw throwable;
            monitor.done();
            throw throwable;
        }
        {
            Object var15_17 = null;
            ((SearchDocumentSet)set).dispose();
            if (monitor == null) return;
        }
        monitor.done();
    }

    public void search(SearchPattern pattern, SearchRequestor requestor, SearchScope scope, Map searchOptions, IProgressMonitor monitor) throws CoreException {
        SearchParticipant[] participants = this.getApplicableParticipants(pattern, searchOptions);
        this.search(pattern, requestor, participants, scope, searchOptions, monitor);
    }

    public SearchParticipant[] getApplicableParticipants(SearchPattern pattern, Map searchOptions) {
        return SearchPlugin.getDefault().loadSearchParticipants(pattern, searchOptions);
    }
}

