/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.commands.AddExtensionCommand;
import org.eclipse.wst.xsd.ui.internal.common.properties.sections.appinfo.SpecificationForExtensionsSchema;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AddExtensionElementCommand
extends AddExtensionCommand {
    XSDElementDeclaration element;
    Element appInfo;
    Element newElement;

    public AddExtensionElementCommand(String label, XSDConcreteComponent input, XSDElementDeclaration element) {
        super(label);
        this.component = input;
        this.element = element;
    }

    public void execute() {
        super.execute();
        this.addAnnotationSet(this.component.getSchema(), this.extensionsSchemaSpec);
    }

    public void undo() {
        super.undo();
        XSDAnnotation xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation(this.component, false);
        xsdAnnotation.getElement().removeChild(this.appInfo);
        EList appInfos = xsdAnnotation.getApplicationInformation();
        appInfos.remove(this.appInfo);
        xsdAnnotation.updateElement();
    }

    public void setSchemaProperties(SpecificationForExtensionsSchema spec) {
        this.extensionsSchemaSpec = spec;
    }

    public void addAnnotationSet(XSDSchema xsdSchema, SpecificationForExtensionsSchema spec) {
        XSDAnnotation xsdAnnotation = XSDCommonUIUtils.getInputXSDAnnotation(this.component, true);
        this.addAnnotationSet(spec, xsdAnnotation);
    }

    private void addAnnotationSet(SpecificationForExtensionsSchema spec, XSDAnnotation xsdAnnotation) {
        this.appInfo = xsdAnnotation.createApplicationInformation(spec.getNamespaceURI());
        if (this.appInfo != null) {
            Document doc = this.appInfo.getOwnerDocument();
            Element rootElement = doc.createElementNS(spec.getNamespaceURI(), this.element.getName());
            String prefix = this.createUniquePrefix(this.component);
            rootElement.setPrefix(prefix);
            this.newElement = rootElement;
            Attr nsURIAttribute = doc.createAttribute("xmlns:" + prefix);
            nsURIAttribute.setValue(spec.getNamespaceURI());
            rootElement.setAttributeNode(nsURIAttribute);
            this.appInfo.appendChild(rootElement);
            xsdAnnotation.getElement().appendChild(this.appInfo);
            EList appInfos = xsdAnnotation.getApplicationInformation();
            appInfos.add(this.appInfo);
            xsdAnnotation.updateElement();
        }
    }

    public Object getNewObject() {
        return this.newElement;
    }

    protected String createUniquePrefix(XSDConcreteComponent component) {
        String prefix = "p";
        Map prefMapper = component.getSchema().getQNamePrefixToNamespaceMap();
        if (prefMapper.get(prefix) != null) {
            int i = 1;
            while (prefMapper.get(String.valueOf(prefix) + i) != null) {
                ++i;
            }
            prefix = String.valueOf(prefix) + i;
        }
        return prefix;
    }
}

