/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xsd.ui.internal.common.commands;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.xsd.ui.internal.common.commands.BaseCommand;
import org.eclipse.wst.xsd.ui.internal.common.util.XSDCommonUIUtils;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDConcreteComponent;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.util.XSDSchemaBuildingTools;
import org.w3c.dom.Text;

public class AddXSDElementCommand
extends BaseCommand {
    XSDComplexTypeDefinition xsdComplexTypeDefinition;
    XSDModelGroupDefinition xsdModelGroupDefinition;
    XSDModelGroup xsdModelGroup;
    XSDSchema xsdSchema;
    boolean isReference;
    private String nameToAdd;

    public AddXSDElementCommand() {
    }

    public AddXSDElementCommand(String label, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        super(label);
        this.xsdComplexTypeDefinition = xsdComplexTypeDefinition;
        this.xsdModelGroup = this.getModelGroup(xsdComplexTypeDefinition);
    }

    public AddXSDElementCommand(String label, XSDModelGroupDefinition xsdModelGroupDefinition) {
        super(label);
        this.xsdModelGroupDefinition = xsdModelGroupDefinition;
        this.xsdModelGroup = this.getModelGroup(xsdModelGroupDefinition);
    }

    public AddXSDElementCommand(String label, XSDModelGroup xsdModelGroup, XSDComplexTypeDefinition xsdComplexTypeDefinition) {
        super(label);
        this.xsdModelGroup = xsdModelGroup;
        this.xsdComplexTypeDefinition = xsdComplexTypeDefinition;
    }

    public AddXSDElementCommand(String label, XSDModelGroup xsdModelGroup) {
        super(label);
        this.xsdModelGroup = xsdModelGroup;
    }

    public AddXSDElementCommand(String label, XSDSchema xsdSchema) {
        super(label);
        this.xsdSchema = xsdSchema;
    }

    public void setReference(boolean isReference) {
        this.isReference = isReference;
    }

    public void setNameToAdd(String name) {
        this.nameToAdd = name;
    }

    public void execute() {
        if (this.xsdSchema != null) {
            XSDElementDeclaration element = this.createGlobalXSDElementDeclaration();
            Text textNode = this.xsdSchema.getDocument().createTextNode("\n");
            this.xsdSchema.getElement().appendChild(textNode);
            this.xsdSchema.getContents().add((Object)element);
            this.addedXSDConcreteComponent = element;
        } else if (this.xsdModelGroupDefinition != null) {
            if (this.xsdModelGroup == null) {
                XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
                XSDParticle particle = factory.createXSDParticle();
                this.xsdModelGroup = factory.createXSDModelGroup();
                this.xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                particle.setContent((XSDParticleContent)this.xsdModelGroup);
            }
            this.xsdSchema = this.xsdModelGroup.getSchema();
            if (!this.isReference) {
                this.xsdModelGroup.getContents().add((Object)this.createXSDElementDeclaration());
            } else {
                this.xsdModelGroup.getContents().add((Object)this.createXSDElementReference());
            }
        } else if (this.xsdComplexTypeDefinition == null && this.xsdModelGroup != null) {
            this.xsdSchema = this.xsdModelGroup.getSchema();
            if (!this.isReference) {
                this.xsdModelGroup.getContents().add((Object)this.createXSDElementDeclaration());
            } else {
                this.xsdModelGroup.getContents().add((Object)this.createXSDElementReference());
            }
            this.formatChild(this.xsdModelGroup.getElement());
        } else {
            if (this.xsdModelGroup == null) {
                XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
                XSDParticle particle = factory.createXSDParticle();
                this.xsdModelGroup = factory.createXSDModelGroup();
                this.xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
                particle.setContent((XSDParticleContent)this.xsdModelGroup);
                this.xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)particle);
            }
            this.xsdSchema = this.xsdComplexTypeDefinition.getSchema();
            if (!this.isReference) {
                this.xsdModelGroup.getContents().add((Object)this.createXSDElementDeclarationForComplexType());
            } else {
                this.xsdModelGroup.getContents().add((Object)this.createXSDElementReference());
            }
            this.formatChild(this.xsdModelGroup.getElement());
        }
    }

    protected XSDParticle createXSDElementDeclaration() {
        XSDSimpleTypeDefinition type = this.xsdModelGroup.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string");
        XSDElementDeclaration element = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        ArrayList usedAttributeNames = new ArrayList();
        usedAttributeNames.addAll(XSDCommonUIUtils.getChildElements(this.xsdModelGroup));
        element.setName(XSDCommonUIUtils.createUniqueElementName(this.nameToAdd == null ? "NewElement" : this.nameToAdd, (List)this.xsdSchema.getElementDeclarations()));
        element.setTypeDefinition((XSDTypeDefinition)type);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent((XSDParticleContent)element);
        this.addedXSDConcreteComponent = element;
        return particle;
    }

    protected XSDParticle createXSDElementReference() {
        EList list = this.xsdModelGroup.getSchema().getElementDeclarations();
        XSDElementDeclaration referencedElement = null;
        if (list.size() > 0) {
            referencedElement = (XSDElementDeclaration)list.get(0);
        } else {
            referencedElement = this.createGlobalXSDElementDeclaration();
            Text textNode = this.xsdSchema.getDocument().createTextNode("\n");
            this.xsdSchema.getElement().appendChild(textNode);
            this.xsdSchema.getContents().add((Object)referencedElement);
        }
        XSDElementDeclaration element = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        element.setResolvedElementDeclaration(referencedElement);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent((XSDParticleContent)element);
        this.addedXSDConcreteComponent = element;
        return particle;
    }

    protected XSDParticle createXSDElementDeclarationForComplexType() {
        XSDSimpleTypeDefinition type = this.xsdModelGroup.getSchema().getSchemaForSchema().resolveSimpleTypeDefinition("string");
        XSDElementDeclaration element = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        ArrayList usedAttributeNames = new ArrayList();
        usedAttributeNames.addAll(XSDCommonUIUtils.getAllAttributes(this.xsdComplexTypeDefinition));
        usedAttributeNames.addAll(XSDCommonUIUtils.getInheritedAttributes(this.xsdComplexTypeDefinition));
        element.setName(XSDCommonUIUtils.createUniqueElementName(this.nameToAdd == null ? "NewElement" : this.nameToAdd, usedAttributeNames));
        element.setTypeDefinition((XSDTypeDefinition)type);
        XSDParticle particle = XSDFactory.eINSTANCE.createXSDParticle();
        particle.setContent((XSDParticleContent)element);
        this.addedXSDConcreteComponent = element;
        return particle;
    }

    protected XSDElementDeclaration createGlobalXSDElementDeclaration() {
        AddXSDElementCommand.ensureSchemaElement(this.xsdSchema);
        XSDSimpleTypeDefinition type = this.xsdSchema.getSchemaForSchema().resolveSimpleTypeDefinition("string");
        XSDFactory factory = XSDSchemaBuildingTools.getXSDFactory();
        XSDElementDeclaration element = factory.createXSDElementDeclaration();
        element.setName(XSDCommonUIUtils.createUniqueElementName(this.nameToAdd == null ? "NewElement" : this.nameToAdd, (List)this.xsdSchema.getElementDeclarations()));
        element.setTypeDefinition((XSDTypeDefinition)type);
        return element;
    }

    public XSDModelGroup getModelGroup(XSDModelGroupDefinition modelGroupDef) {
        return modelGroupDef.getModelGroup();
    }

    public XSDModelGroup getModelGroup(XSDComplexTypeDefinition cType) {
        XSDParticle particle = cType.getSyntheticParticle();
        XSDComplexTypeContent xsdComplexTypeContent = cType.getContent();
        if (xsdComplexTypeContent instanceof XSDParticle) {
            particle = (XSDParticle)xsdComplexTypeContent;
        }
        if (particle == null) {
            return null;
        }
        XSDParticleContent particleContent = particle.getContent();
        XSDModelGroup group = null;
        if (particleContent instanceof XSDModelGroupDefinition) {
            group = ((XSDModelGroupDefinition)particleContent).getResolvedModelGroupDefinition().getModelGroup();
        } else if (particleContent instanceof XSDModelGroup) {
            group = (XSDModelGroup)particleContent;
        }
        if (group == null) {
            return null;
        }
        return group;
    }

    public XSDConcreteComponent getAddedComponent() {
        return super.getAddedComponent();
    }
}

