/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.creation.ui.extension;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.consumption.command.common.AssociateModuleWithEARCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.CreateFacetedProjectCommand;
import org.eclipse.jst.ws.internal.consumption.command.common.SkeletonMergeCommand;
import org.eclipse.jst.ws.internal.consumption.common.RequiredFacetVersion;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;
import org.eclipse.wst.ws.internal.wsrt.IContext;
import org.eclipse.wst.ws.internal.wsrt.IWebService;

public class PreServiceAssembleCommand
extends AbstractDataModelOperation {
    private IWebService webService_;
    private String project_;
    private String module_;
    private String earProject_;
    private String ear_;
    private IContext context_;

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        IStatus status = Status.OK_STATUS;
        if (this.context_.getScenario().getValue() == 1) {
            SkeletonMergeCommand skeletonMergeCommand = new SkeletonMergeCommand(this.project_);
            skeletonMergeCommand.setUrls(this.webService_.getWebServiceInfo().getImplURLs());
            skeletonMergeCommand.setEnvironment(environment);
            status = skeletonMergeCommand.execute(monitor, adaptable);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
        }
        if (this.context_.getAssemble()) {
            if (this.earProject_ == null) {
                return Status.OK_STATUS;
            }
            CreateFacetedProjectCommand command = new CreateFacetedProjectCommand();
            command.setProjectName(this.earProject_);
            command.setTemplateId("template.jst.ear");
            command.setRequiredFacetVersions(new RequiredFacetVersion[0]);
            command.setServerFactoryId(this.webService_.getWebServiceInfo().getServerFactoryId());
            command.setServerInstanceId(this.webService_.getWebServiceInfo().getServerInstanceId());
            status = command.execute(monitor, adaptable);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
                return status;
            }
            AssociateModuleWithEARCommand associateCommand = new AssociateModuleWithEARCommand();
            associateCommand.setProject(this.project_);
            associateCommand.setModule(this.module_);
            associateCommand.setEARProject(this.earProject_);
            associateCommand.setEar(this.ear_);
            associateCommand.setEnvironment(environment);
            status = associateCommand.execute(monitor, null);
            if (status.getSeverity() == 4) {
                environment.getStatusHandler().reportError(status);
            }
        }
        return status;
    }

    public void setProject(String project) {
        this.project_ = project;
    }

    public void setModule(String module) {
        this.module_ = module;
    }

    public void setEarProject(String earProject) {
        this.earProject_ = earProject;
    }

    public void setEar(String ear) {
        this.ear_ = ear;
    }

    public void setWebService(IWebService webService) {
        this.webService_ = webService;
    }

    public void setContext(IContext context) {
        this.context_ = context;
    }
}

