/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.servlet.ui.internal.actions;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.internal.web.archive.operations.WebFacetProjectCreationDataModelProvider;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.web.ui.internal.Logger;

public class ConvertToWebModuleTypeAction
extends Action
implements IWorkbenchWindowActionDelegate {
    IStructuredSelection fSelection = null;
    IProject project = null;
    IWorkbenchWindow fWindow;

    protected boolean isValidProject(IProject aProject) {
        return J2EEProjectUtilities.isStaticWebProject((IProject)aProject);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        boolean bEnable = false;
        if (selection instanceof IStructuredSelection) {
            this.fSelection = (IStructuredSelection)selection;
            bEnable = this.validateSelected((ISelection)this.fSelection);
        }
        ((Action)action).setEnabled(bEnable);
    }

    protected boolean validateSelected(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return false;
        }
        this.fSelection = (IStructuredSelection)selection;
        Object selectedProject = this.fSelection.getFirstElement();
        if (!(selectedProject instanceof IProject)) {
            return false;
        }
        this.project = (IProject)selectedProject;
        return this.isValidProject(this.project);
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        try {
            IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)this.project);
            HashSet fixedFacets = new HashSet();
            fixedFacets.addAll(facetedProject.getFixedProjectFacets());
            IProjectFacet webFacet = ProjectFacetsManager.getProjectFacet((String)"wst.web");
            fixedFacets.remove(webFacet);
            facetedProject.setFixedProjectFacets(fixedFacets);
            facetedProject.uninstallProjectFacet(facetedProject.getInstalledVersion(webFacet), null, (IProgressMonitor)new NullProgressMonitor());
            IDataModel model = DataModelFactory.createDataModel((IDataModelProvider)new WebFacetProjectCreationDataModelProvider());
            model.setProperty("IFacetDataModelProperties.FACET_PROJECT_NAME", (Object)this.project.getName());
            model.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (Exception e) {
            Logger.logException((Throwable)e);
        }
    }
}

