/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal.util;

import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileDups {
    private static int sFiles = 0;
    private static int sDups = 0;
    private static int sJARs = 0;
    private static String[] excludedEntryNames = new String[]{"com/ibm/ivj/ejb/runtime/_CopyHelper_Stub.class", "org/omg/stub/javax/ejb/_HomeHandle_Stub.class", "org/omg/stub/javax/ejb/_Handle_Stub.class", "org/omg/stub/javax/ejb/_EJBObject_Stub.class", "org/omg/stub/javax/ejb/_EJBHome_Stub.class", "org/omg/stub/java/lang/_Cloneable_Stub.class", "com/ibm/websphere/csi/_TransactionalObject_Stub.class", "com/ibm/websphere/csi/_CSIServant_Stub.class", "com/ibm/ejs/container/_EJSWrapper_Tie.class", "com/ibm/ejs/container/_EJSWrapper_Stub.class"};
    private static HashSet excluded = new HashSet<String>(Arrays.asList(excludedEntryNames));

    private static void addEntry(String entry, Map map, String jarName) {
        ++sFiles;
        Object current = map.get(entry);
        if (current == null) {
            map.put(entry, jarName);
        } else if (current instanceof String) {
            map.remove(entry);
            String other = (String)current;
            LinkedList<String> list = new LinkedList<String>();
            list.addFirst(other);
            list.addFirst(jarName);
            map.put(entry, list);
            ++sDups;
        } else {
            LinkedList list = (LinkedList)current;
            list.addFirst(jarName);
            ++sDups;
        }
    }

    public static void main(String[] args) {
        if (args.length != 1) {
            StringBuffer sb = new StringBuffer();
            sb.append("FileDups utility\r\n\r\n");
            sb.append("Synopsis:\r\n");
            sb.append("Analyzes JAR and ZIP files in a directory for duplicate entries with the same name.  This excludes all entries in the \"META-INF\" directory of the archive.  This does not check timestamps or size.\r\n\r\n");
            sb.append("Usage: FileDups dirName\r\n");
            System.out.println(sb.toString());
            return;
        }
        TreeMap map = new TreeMap();
        try {
            CharSequence jars;
            int i = 0;
            while (i < args.length) {
                File root = new File(args[i]);
                FileDups.processDirectory(root, map);
                ++i;
            }
            TreeMap outputMap = new TreeMap();
            Set set = map.entrySet();
            Iterator it = set.iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Object o = me.getValue();
                if (!(o instanceof LinkedList)) continue;
                jars = new StringBuffer();
                LinkedList list = (LinkedList)o;
                Iterator entryIter = list.iterator();
                while (entryIter.hasNext()) {
                    ((StringBuffer)jars).append(entryIter.next());
                    ((StringBuffer)jars).append("\r\n");
                }
                LinkedList outputList = (LinkedList)outputMap.get(((StringBuffer)jars).toString());
                if (outputList == null) {
                    outputList = new LinkedList();
                    outputMap.put(((StringBuffer)jars).toString(), outputList);
                }
                outputList.addFirst(me.getKey());
            }
            Set outSet = outputMap.entrySet();
            it = outSet.iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                jars = (String)me.getKey();
                StringTokenizer tokens = new StringTokenizer((String)jars, "\r\n");
                while (tokens.hasMoreTokens()) {
                    System.out.println(tokens.nextToken());
                }
                LinkedList list = (LinkedList)me.getValue();
                Iterator entryIter = list.iterator();
                while (entryIter.hasNext()) {
                    System.out.println("    " + (String)entryIter.next());
                }
            }
            System.out.println("\r\nSearched " + sJARs + " jars, found " + sDups + " dups in " + sFiles + " files.");
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static void processDirectory(File root, Map map) throws IOException {
        File[] files = root.listFiles();
        int i = 0;
        while (i < files.length) {
            File f = files[i];
            if (f.isDirectory()) {
                FileDups.processDirectory(f, map);
            } else {
                String name = f.getName().toLowerCase();
                if (name.endsWith(".zip") || name.endsWith(".jar")) {
                    FileDups.processFile(f, map);
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void processFile(File file, Map map) throws IOException {
        HashSet<String> filesInFile = new HashSet<String>();
        ++sJARs;
        ZipFile zip = null;
        try {
            try {
                zip = new ZipFile(file);
                Enumeration<? extends ZipEntry> eNum = zip.entries();
                while (eNum.hasMoreElements()) {
                    ZipEntry entry = eNum.nextElement();
                    String name = entry.getName();
                    if (name.startsWith("META-INF") || excluded.contains(name)) continue;
                    filesInFile.add(name);
                }
            }
            catch (Exception exception) {
                System.out.println("*Error searching in " + file.getAbsolutePath());
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (zip == null) throw throwable;
                zip.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (zip != null) {
            zip.close();
        }
        String filename = file.getPath();
        Iterator it = filesInFile.iterator();
        while (it.hasNext()) {
            String entryName = (String)it.next();
            FileDups.addEntry(entryName, map, filename);
        }
        return;
    }
}

