/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.provisional.jsfappconfig;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.common.ParamValue;
import org.eclipse.jst.j2ee.web.componentcore.util.WebArtifactEdit;
import org.eclipse.jst.j2ee.webapplication.ContextParam;
import org.eclipse.jst.j2ee.webapplication.WebApp;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class JSFAppConfigUtils {
    public static final String CONFIG_FILES_CONTEXT_PARAM_NAME = "javax.faces.CONFIG_FILES";
    public static final String FACES_CONFIG_IN_JAR_PATH = "META-INF/faces-config.xml";

    public static boolean isValidJSFProject(IProject project) {
        boolean isValid;
        block4: {
            isValid = false;
            if (project != null && project.isAccessible()) {
                try {
                    IFacetedProject facetedProject = ProjectFacetsManager.create((IProject)project);
                    if (facetedProject == null) break block4;
                    Set projectFacets = facetedProject.getProjectFacets();
                    Iterator itProjectFacets = projectFacets.iterator();
                    while (itProjectFacets.hasNext()) {
                        IProjectFacetVersion projectFacetVersion = (IProjectFacetVersion)itProjectFacets.next();
                        IProjectFacet projectFacet = projectFacetVersion.getProjectFacet();
                        if (!"jst.jsf".equals(projectFacet.getId())) continue;
                        isValid = true;
                        break;
                    }
                }
                catch (CoreException ce) {
                    JSFCorePlugin.log(4, ce.getLocalizedMessage(), ce);
                }
            }
        }
        return isValid;
    }

    public static IVirtualFolder getWebContentFolder(IProject project) {
        IVirtualFolder folder = null;
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component != null) {
            folder = component.getRootFolder();
        }
        return folder;
    }

    public static IPath getWebContentFolderRelativePath(IFile file) {
        IVirtualFolder webContentFolder;
        IPath path = null;
        if (file != null && (webContentFolder = JSFAppConfigUtils.getWebContentFolder(file.getProject())) != null) {
            IPath webContentPath = webContentFolder.getProjectRelativePath();
            IPath filePath = file.getProjectRelativePath();
            int matchingFirstSegments = webContentPath.matchingFirstSegments(filePath);
            path = filePath.removeFirstSegments(matchingFirstSegments);
        }
        return path;
    }

    public static List getConfigFilesFromContextParam(IProject project) {
        WebArtifactEdit webArtifactEdit;
        ArrayList<String> filesList = new ArrayList<String>();
        if (JSFAppConfigUtils.isValidJSFProject(project) && (webArtifactEdit = WebArtifactEdit.getWebArtifactEditForRead((IProject)project)) != null) {
            WebApp webApp = null;
            try {
                webApp = webArtifactEdit.getWebApp();
            }
            catch (ClassCastException cce) {
                JSFCorePlugin.log(4, cce.getLocalizedMessage(), cce);
                return filesList;
            }
            if (webApp != null) {
                String filesString = null;
                if (webApp.getVersionID() == 23) {
                    EList contexts = webApp.getContexts();
                    Iterator itContexts = contexts.iterator();
                    while (itContexts.hasNext()) {
                        ContextParam contextParam = (ContextParam)itContexts.next();
                        if (!contextParam.getParamName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
                        filesString = contextParam.getParamValue();
                        break;
                    }
                } else {
                    EList contextParams = webApp.getContextParams();
                    Iterator itContextParams = contextParams.iterator();
                    while (itContextParams.hasNext()) {
                        ParamValue paramValue = (ParamValue)itContextParams.next();
                        if (!paramValue.getName().equals(CONFIG_FILES_CONTEXT_PARAM_NAME)) continue;
                        filesString = paramValue.getValue();
                        break;
                    }
                }
                if (filesString != null && filesString.trim().length() > 0) {
                    StringTokenizer stFilesString = new StringTokenizer(filesString, ",");
                    while (stFilesString.hasMoreTokens()) {
                        String configFile = stFilesString.nextToken().trim();
                        filesList.add(configFile);
                    }
                }
            }
            webArtifactEdit.dispose();
        }
        return filesList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List getConfigFileJARsFromClasspath(IProject project) throws CoreException, IOException {
        ArrayList<String> JARsList;
        block10: {
            IClasspathEntry[] classpathEntries;
            IJavaProject javaProject;
            JARsList = new ArrayList<String>();
            if (!project.hasNature("org.eclipse.jdt.core.javanature") || (javaProject = JavaCore.create((IProject)project)) == null || (classpathEntries = javaProject.getResolvedClasspath(true)) == null || classpathEntries.length <= 0) break block10;
            int i = 0;
            while (i < classpathEntries.length) {
                block9: {
                    Object var10_11;
                    IPath libraryPath;
                    IClasspathEntry classpathEntry = classpathEntries[i];
                    if (classpathEntry.getEntryKind() != 1 || (libraryPath = classpathEntry.getPath()).getFileExtension() == null || libraryPath.getFileExtension().length() <= 0) break block9;
                    if (libraryPath.getDevice() == null) {
                        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
                        IPath workspaceRootPath = workspaceRoot.getLocation();
                        libraryPath = workspaceRootPath.append(libraryPath);
                    }
                    String libraryPathString = libraryPath.toString();
                    JarFile jarFile = null;
                    try {
                        try {
                            JarEntry jarEntry;
                            jarFile = new JarFile(libraryPathString);
                            if (jarFile != null && (jarEntry = jarFile.getJarEntry(FACES_CONFIG_IN_JAR_PATH)) != null) {
                                JARsList.add(libraryPathString);
                            }
                        }
                        catch (IOException ioe) {
                            JSFCorePlugin.log(4, NLS.bind((String)Messages.JSFAppConfigUtils_ErrorOpeningJarFile, (Object)libraryPathString), ioe);
                        }
                    }
                    catch (Throwable throwable) {
                        var10_11 = null;
                        if (jarFile != null) {
                            jarFile.close();
                        }
                        throw throwable;
                    }
                    {
                        var10_11 = null;
                        if (jarFile == null) break block9;
                    }
                    jarFile.close();
                }
                ++i;
            }
        }
        return JARsList;
    }
}

