/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import java.math.BigDecimal;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.core.internal.types.FloatLiteralType;
import org.eclipse.jst.jsf.core.internal.types.IntegerLiteralType;
import org.eclipse.jst.jsf.core.internal.types.LiteralType;
import org.eclipse.jst.jsf.core.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.core.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.core.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.core.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.operators.ArithmeticBinaryOperator;
import org.eclipse.jst.jsf.validation.internal.el.operators.DiagnosticFactory;

class DivArithmeticBinaryOperator
extends ArithmeticBinaryOperator {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    DivArithmeticBinaryOperator() {
    }

    public ValueType performOperation(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return new IntegerLiteralType(0L);
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDouble;".equals(boxedFirstArg) || "Ljava.math.BigDouble;".equals(boxedSecondArg) || "Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.performBigDecimal(firstArg, secondArg);
        }
        return this.performDouble(firstArg, secondArg);
    }

    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) && TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return DiagnosticFactory.create_BINARY_OP_BOTH_OPERANDS_NULL("division");
        }
        String boxedFirstArg = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondArg = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDouble;".equals(boxedFirstArg) || "Ljava.math.BigDouble;".equals(boxedSecondArg) || "Ljava.math.BigInteger;".equals(boxedFirstArg) || "Ljava.math.BigInteger;".equals(boxedSecondArg)) {
            return this.validateBigDecimal(firstArg, secondArg);
        }
        return this.validateDouble(firstArg, secondArg);
    }

    private ValueType performBigDecimal(ValueType firstArg, ValueType secondArg) {
        block6: {
            try {
                Number coercedValue;
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
                if (!(secondArg instanceof LiteralType)) break block6;
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!((BigDecimal)(coercedValue = literalType.coerceToNumber((Class)clazz))).equals(new BigDecimal(0.0))) break block6;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        return new ValueType("Ljava.math.BigDouble;", 2);
    }

    private ValueType performDouble(ValueType firstArg, ValueType secondArg) {
        Number secondValue;
        block11: {
            try {
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
                TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
                secondValue = null;
                if (!(secondArg instanceof LiteralType)) break block11;
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((secondValue = literalType.coerceToNumber((Class)clazz)).doubleValue() != 0.0) break block11;
                return null;
            }
            catch (TypeCoercionException typeCoercionException) {
                return null;
            }
        }
        Number firstValue = null;
        if (firstArg instanceof LiteralType) {
            LiteralType literalType = (LiteralType)firstArg;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            firstValue = literalType.coerceToNumber((Class)clazz);
        }
        if (firstValue != null && secondValue != null) {
            return new FloatLiteralType(firstValue.doubleValue() / secondValue.doubleValue());
        }
        return new ValueType("D", 2);
    }

    private Diagnostic validateBigDecimal(ValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            if (secondArg instanceof LiteralType) {
                Number coercedValue;
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (((BigDecimal)(coercedValue = literalType.coerceToNumber((Class)clazz))).equals(new BigDecimal(0.0))) {
                    return DiagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
                }
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return DiagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION("division");
        }
    }

    private Diagnostic validateDouble(ValueType firstArg, ValueType secondArg) {
        try {
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
            TypeCoercer.coerceToNumber((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
            Number secondValue = null;
            if (secondArg instanceof LiteralType) {
                LiteralType literalType = (LiteralType)secondArg;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((secondValue = literalType.coerceToNumber((Class)clazz)).doubleValue() == 0.0) {
                    return DiagnosticFactory.create_BINARY_OP_POSSIBLE_DIVISION_BY_ZERO();
                }
            }
            Number firstValue = null;
            if (firstArg instanceof LiteralType) {
                LiteralType literalType = (LiteralType)firstArg;
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                firstValue = literalType.coerceToNumber((Class)clazz);
            }
            if (firstValue != null && secondValue != null) {
                String result = Double.toString(firstValue.doubleValue() / secondValue.doubleValue());
                return DiagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME("division", result);
            }
            return Diagnostic.OK_INSTANCE;
        }
        catch (TypeCoercionException typeCoercionException) {
            return DiagnosticFactory.create_BINARY_OP_COULD_NOT_MAKE_NUMERIC_COERCION("division");
        }
    }

    protected BigDecimal doRealOperation(BigDecimal firstArg, BigDecimal secondArg) {
        return firstArg.divide(secondArg, 4);
    }

    protected Double doRealOperation(Double firstArg, Double secondArg) {
        return new Double(firstArg / secondArg);
    }

    protected Long doRealOperation(Long firstArg, Long secondArg) {
        return new Long(firstArg / secondArg);
    }

    protected String getOperatorName() {
        return "division";
    }
}

