/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.validation.internal.el.operators;

import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jst.jsf.core.internal.types.BooleanLiteralType;
import org.eclipse.jst.jsf.core.internal.types.LiteralType;
import org.eclipse.jst.jsf.core.internal.types.TypeCoercer;
import org.eclipse.jst.jsf.core.internal.types.TypeCoercionException;
import org.eclipse.jst.jsf.core.internal.types.TypeTransformer;
import org.eclipse.jst.jsf.core.internal.types.ValueType;
import org.eclipse.jst.jsf.validation.internal.el.operators.DiagnosticFactory;
import org.eclipse.jst.jsf.validation.internal.el.operators.RelationalBinaryOperator;

abstract class EqualityRelationalBinaryOperator
extends RelationalBinaryOperator {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    EqualityRelationalBinaryOperator() {
    }

    protected abstract boolean doRealOperation(Boolean var1, Boolean var2);

    public ValueType performOperation(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) || TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            return BooleanLiteralType.FALSE;
        }
        String boxedFirstType = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondType = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDouble;".equals(boxedFirstType) || "Ljava.math.BigDouble;".equals(boxedSecondType)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.handleNumericComparison(firstArg, secondArg, clazz);
        }
        if ("Ljava.lang.Double;".equals(boxedFirstType) || "Ljava.lang.Float;".equals(boxedFirstType) || "Ljava.lang.Double;".equals(boxedSecondType) || "Ljava.lang.Float;".equals(boxedSecondType)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.handleNumericComparison(firstArg, secondArg, clazz);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstType) || "Ljava.math.BigInteger;".equals(boxedSecondType)) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.handleNumericComparison(firstArg, secondArg, clazz);
        }
        if ("Ljava.lang.Long;".equals(boxedFirstType) || "Ljava.lang.Long;".equals(boxedSecondType) || "Ljava.lang.Integer;".equals(boxedFirstType) || "Ljava.lang.Integer;".equals(boxedSecondType) || "Ljava.lang.Short;".equals(boxedFirstType) || "Ljava.lang.Short;".equals(boxedSecondType) || "Ljava.lang.Byte;".equals(boxedFirstType) || "Ljava.lang.Byte;".equals(boxedSecondType) || "Ljava.lang.Character".equals(boxedFirstType) || "Ljava.lang.Character".equals(boxedSecondType)) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.handleNumericComparison(firstArg, secondArg, clazz);
        }
        if ("Ljava.lang.Boolean;".equals(boxedFirstType) || "Ljava.lang.Boolean;".equals(boxedSecondType)) {
            return this.handleBooleanComparison(firstArg, secondArg);
        }
        if ("Ljava.lang.String;".equals(boxedFirstType) || "Ljava.lang.String;".equals(boxedSecondType)) {
            return this.handleStringComparison(firstArg, secondArg);
        }
        return new ValueType("Z", 2);
    }

    public Diagnostic validate(ValueType firstArg, ValueType secondArg) {
        if (TypeCoercer.typeIsNull((String)firstArg.getSignature()) || TypeCoercer.typeIsNull((String)secondArg.getSignature())) {
            boolean result = this.doRealOperation(new Integer(4), null);
            return DiagnosticFactory.create_BINARY_OP_EQUALITY_COMP_WITH_NULL_ALWAYS_EVAL_SAME(Boolean.toString(result));
        }
        String boxedFirstType = TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature());
        String boxedSecondType = TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature());
        if ("Ljava.math.BigDouble;".equals(boxedFirstType) || "Ljava.math.BigDouble;".equals(boxedSecondType)) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.math.BigDecimal");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.validateNumericComparison(firstArg, secondArg, clazz);
        }
        if ("Ljava.lang.Double;".equals(boxedFirstType) || "Ljava.lang.Float;".equals(boxedFirstType) || "Ljava.lang.Double;".equals(boxedSecondType) || "Ljava.lang.Float;".equals(boxedSecondType)) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.lang.Double");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.validateNumericComparison(firstArg, secondArg, clazz);
        }
        if ("Ljava.math.BigInteger;".equals(boxedFirstType) || "Ljava.math.BigInteger;".equals(boxedSecondType)) {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("java.math.BigInteger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.validateNumericComparison(firstArg, secondArg, clazz);
        }
        if ("Ljava.lang.Long;".equals(boxedFirstType) || "Ljava.lang.Long;".equals(boxedSecondType) || "Ljava.lang.Integer;".equals(boxedFirstType) || "Ljava.lang.Integer;".equals(boxedSecondType) || "Ljava.lang.Short;".equals(boxedFirstType) || "Ljava.lang.Short;".equals(boxedSecondType) || "Ljava.lang.Byte;".equals(boxedFirstType) || "Ljava.lang.Byte;".equals(boxedSecondType) || "Ljava.lang.Character".equals(boxedFirstType) || "Ljava.lang.Character".equals(boxedSecondType)) {
            Class<?> clazz = class$3;
            if (clazz == null) {
                try {
                    clazz = class$3 = Class.forName("java.lang.Long");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return this.validateNumericComparison(firstArg, secondArg, clazz);
        }
        if ("Ljava.lang.Boolean;".equals(boxedFirstType) || "Ljava.lang.Boolean;".equals(boxedSecondType)) {
            return this.validateBooleanComparison(firstArg, secondArg);
        }
        if ("Ljava.lang.String;".equals(boxedFirstType) || "Ljava.lang.String;".equals(boxedSecondType)) {
            return this.validateStringComparison(firstArg, secondArg);
        }
        return Diagnostic.OK_INSTANCE;
    }

    private ValueType handleBooleanComparison(ValueType firstArg, ValueType secondArg) {
        boolean canCoerceFirstArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)firstArg.getSignature()));
        boolean canCoerceSecondArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)secondArg.getSignature()));
        if (!canCoerceFirstArg || !canCoerceSecondArg) {
            return null;
        }
        if (firstArg instanceof LiteralType && secondArg instanceof LiteralType) {
            try {
                Boolean firstValue = ((LiteralType)firstArg).coerceToBoolean();
                Boolean secondValue = ((LiteralType)secondArg).coerceToBoolean();
                if (firstValue != null && secondValue != null) {
                    boolean result = this.doRealOperation(firstValue, secondValue);
                    return result ? BooleanLiteralType.TRUE : BooleanLiteralType.FALSE;
                }
            }
            catch (TypeCoercionException typeCoercionException) {
                throw new AssertionError((Object)"should never get here; have already checked coercability above");
            }
        }
        return new ValueType("Z", 2);
    }

    private Diagnostic validateBooleanComparison(ValueType firstType, ValueType secondType) {
        boolean canCoerceFirstArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)firstType.getSignature()));
        boolean canCoerceSecondArg = TypeCoercer.canCoerceToBoolean((String)TypeTransformer.transformBoxPrimitives((String)secondType.getSignature()));
        if (!canCoerceFirstArg) {
            return DiagnosticFactory.create_BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN("first");
        }
        if (!canCoerceSecondArg) {
            return DiagnosticFactory.create_BINARY_OP_CANNOT_COERCE_ARGUMENT_TO_BOOLEAN("second");
        }
        if (firstType instanceof LiteralType && secondType instanceof LiteralType) {
            try {
                Boolean firstValue = ((LiteralType)firstType).coerceToBoolean();
                Boolean secondValue = ((LiteralType)secondType).coerceToBoolean();
                if (firstValue != null && secondValue != null) {
                    boolean result = this.doRealOperation(firstValue, secondValue);
                    return DiagnosticFactory.create_BINARY_OP_CONSTANT_EXPRESSION_ALWAYS_EVAL_SAME(this.getOperationName(), Boolean.toString(result));
                }
            }
            catch (TypeCoercionException typeCoercionException) {
                throw new AssertionError((Object)"should never get here; have already checked coercability above");
            }
        }
        return Diagnostic.OK_INSTANCE;
    }
}

