/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.common.guiutils;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class Alerts {
    public static boolean noAlerts = false;
    private ResourceBundle rb;
    private String pluginId;

    public Alerts(AbstractUIPlugin plugin, ResourceBundle rb) {
        this.rb = rb;
        if (this.rb == null) {
            throw new NullPointerException("No resource bundle was provided to the Alerts.");
        }
        if (plugin == null) {
            throw new NullPointerException("No plugin was provided to the Alerts.");
        }
        this.pluginId = plugin.getBundle().getSymbolicName();
    }

    public String getInput(String titleKey, String msgKey, String initialValue, IInputValidator validator) {
        if (noAlerts) {
            return null;
        }
        InputDialog inDialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.getResourceString(titleKey), this.getResourceString(msgKey), initialValue, validator);
        inDialog.open();
        return inDialog.getValue();
    }

    public void error(String titleKey, String msgKey) {
        if (noAlerts) {
            return;
        }
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)this.getResourceString(msgKey));
    }

    public void error(String titleKey, String msgKey, Object arg0) {
        if (noAlerts) {
            return;
        }
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)formatter.format(args));
    }

    public void error(String titleKey, String msgKey, Object arg0, Object arg1) {
        if (noAlerts) {
            return;
        }
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)formatter.format(args));
    }

    public void error(String titleKey, String msgKey, Object arg0, Object arg1, Object arg2) {
        if (noAlerts) {
            return;
        }
        Object[] args = new Object[]{arg0, arg1, arg2};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)formatter.format(args));
    }

    public void error(String titleKey, String msgKey, Object arg0, Object arg1, Object arg2, Object arg3) {
        if (noAlerts) {
            return;
        }
        Object[] args = new Object[]{arg0, arg1, arg2, arg3};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)formatter.format(args));
    }

    public void error(Shell shell, String titleKey, String msgKey) {
        if (noAlerts) {
            return;
        }
        MessageDialog.openError((Shell)shell, (String)this.getResourceString(titleKey), (String)this.getResourceString(msgKey));
    }

    public void detailError(String titleKey, String msgKey) {
        if (noAlerts) {
            return;
        }
        Status fstatus = new Status(4, this.pluginId, 0, this.getResourceString(msgKey), null);
        final String ftitle = this.getResourceString(titleKey);
        Display display = this.getStandardDisplay();
        display.asyncExec(new Runnable((IStatus)fstatus){
            private final /* synthetic */ IStatus val$fstatus;
            {
                this.val$fstatus = iStatus;
            }

            public void run() {
                ErrorDialog.openError(null, (String)ftitle, null, (IStatus)this.val$fstatus);
            }
        });
    }

    public void detailError(String titleKey, String msgKey, Throwable tt) {
        if (noAlerts) {
            return;
        }
        this.internalDetailError(this.getResourceString(titleKey), this.getResourceString(msgKey), tt);
    }

    public void detailError(String titleKey, String msgKey, Object arg0, Throwable tt) {
        if (noAlerts) {
            return;
        }
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        this.internalDetailError(this.getResourceString(titleKey), formatter.format(args), tt);
    }

    public void detailError(String titleKey, String msgKey, Object arg0, Object arg1, Throwable tt) {
        if (noAlerts) {
            return;
        }
        Object[] args = new Object[]{arg0};
        args[1] = arg1;
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        this.internalDetailError(this.getResourceString(titleKey), formatter.format(args), tt);
    }

    private void internalDetailError(String title, String msg, Throwable tt) {
        if (noAlerts) {
            return;
        }
        if (tt instanceof InvocationTargetException) {
            tt = ((InvocationTargetException)tt).getTargetException();
        }
        IStatus status = null;
        if (tt instanceof CoreException) {
            status = ((CoreException)tt).getStatus();
            if (!(status instanceof MultiStatus)) {
                Throwable th = status.getException();
                if (th == null) {
                    th = tt;
                }
                status = this.buildStackTraceStatus(4, status.getPlugin(), status.getMessage(), th);
            }
        } else {
            status = this.buildStackTraceStatus(4, this.pluginId, tt.getMessage(), tt);
        }
        final String ftitle = title;
        final IStatus fstatus = status;
        final String fmsg = msg;
        Display display = this.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)ftitle, (String)fmsg, (IStatus)fstatus);
            }
        });
    }

    public IStatus buildStackTraceStatus(int code, String pluginId, String message, Throwable tt) {
        if (tt == null) {
            return new Status(code, pluginId, 0, message, tt);
        }
        MultiStatus mstat = new MultiStatus(pluginId, code, message, tt);
        StackTraceElement[] trace = tt.getStackTrace();
        mstat.add((IStatus)new Status(code, pluginId, 0, tt.toString(), null));
        int ii = 0;
        while (ii < trace.length) {
            mstat.add((IStatus)new Status(code, pluginId, 0, trace[ii].toString(), null));
            ++ii;
        }
        return mstat;
    }

    public void detailError(String title, IStatus status) {
        if (noAlerts) {
            return;
        }
        final IStatus fstatus = status;
        final String ftitle = title;
        Display display = this.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.openError(null, (String)ftitle, null, (IStatus)fstatus);
            }
        });
    }

    public void info(String titleKey, String msgKey) {
        if (noAlerts) {
            return;
        }
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)this.getResourceString(msgKey));
    }

    public void info(String titleKey, String msgKey, Object arg0) {
        if (noAlerts) {
            return;
        }
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)formatter.format(args));
    }

    public boolean confirm(String titleKey, String msgKey) {
        if (noAlerts) {
            return true;
        }
        return MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)this.getResourceString(msgKey));
    }

    public boolean confirm(String titleKey, String msgKey, Object arg0) {
        if (noAlerts) {
            return true;
        }
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        return MessageDialog.openConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)formatter.format(args));
    }

    public boolean question(String titleKey, String msgKey) {
        if (noAlerts) {
            return true;
        }
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)this.getResourceString(msgKey));
    }

    public boolean question(String titleKey, String msgKey, Object arg0) {
        if (noAlerts) {
            return true;
        }
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        return MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)formatter.format(args));
    }

    public void warning(String titleKey, String msgKey) {
        if (noAlerts) {
            return;
        }
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)this.getResourceString(msgKey));
    }

    public void warning(String titleKey, String msgKey, Object arg0) {
        if (noAlerts) {
            return;
        }
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)this.getResourceString(titleKey), (String)formatter.format(args));
    }

    public Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public String getResourceString(String key) {
        if (key == null) {
            return null;
        }
        try {
            return this.rb.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public void throwCoreException(String msgKey) throws CoreException {
        Status status = new Status(4, this.pluginId, 0, this.getResourceString(msgKey), null);
        throw new CoreException((IStatus)status);
    }

    public void throwCoreException(Throwable ee) throws CoreException {
        Status status = new Status(4, this.pluginId, 0, ee.getMessage(), ee);
        throw new CoreException((IStatus)status);
    }

    public void throwCoreException(String msgKey, Throwable ee) throws CoreException {
        Status status = new Status(4, this.pluginId, 0, this.getResourceString(msgKey), ee);
        throw new CoreException((IStatus)status);
    }

    public void throwCoreException(String msgKey, Object arg0) throws CoreException {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        Status status = new Status(4, this.pluginId, 0, formatter.format(args), null);
        throw new CoreException((IStatus)status);
    }

    public void throwCoreException(String msgKey, Object arg0, Throwable ee) throws CoreException {
        Object[] args = new Object[]{arg0};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        Status status = new Status(4, this.pluginId, 0, formatter.format(args), ee);
        throw new CoreException((IStatus)status);
    }

    public void throwCoreException(String msgKey, Object arg0, Object arg1) throws CoreException {
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        Status status = new Status(4, this.pluginId, 0, formatter.format(args), null);
        throw new CoreException((IStatus)status);
    }

    public void throwCoreException(String msgKey, Object arg0, Object arg1, Throwable ee) throws CoreException {
        Object[] args = new Object[]{arg0, arg1};
        MessageFormat formatter = new MessageFormat(this.getResourceString(msgKey));
        Status status = new Status(4, this.pluginId, 0, formatter.format(args), ee);
        throw new CoreException((IStatus)status);
    }
}

