/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.section;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.DialogField;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.IDialogFieldApplyListener;
import org.eclipse.jst.jsf.facesconfig.common.dialogfield.RadiosDialogField;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigPackage;
import org.eclipse.jst.jsf.facesconfig.emf.ManagedBeanType;
import org.eclipse.jst.jsf.facesconfig.ui.EditorMessages;
import org.eclipse.jst.jsf.facesconfig.ui.EditorPlugin;
import org.eclipse.jst.jsf.facesconfig.ui.page.IFacesConfigPage;
import org.eclipse.jst.jsf.facesconfig.ui.section.AbstractFacesConfigSection;
import org.eclipse.jst.jsf.facesconfig.ui.section.ListEntriesEditGroup;
import org.eclipse.jst.jsf.facesconfig.ui.section.ManagedPropertyEditGroup;
import org.eclipse.jst.jsf.facesconfig.ui.section.MapEntriesEditGroup;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.part.PageBook;

public class InitializationSection
extends AbstractFacesConfigSection {
    private static final String MANAGEDBEAN_GENERAL_CLASS = EditorMessages.InitializationSection_ClassType_General;
    private static final String MANAGEDBEAN_MAP = EditorMessages.InitializationSection_ClassType_Map;
    private static final String MANAGEDBEAN_LIST = EditorMessages.InitializationSection_ClassType_List;
    private Composite propertySection;
    private ManagedPropertyEditGroup managedPropertyGroup;
    private Composite mapSection;
    private MapEntriesEditGroup mapEntryGroup;
    private Composite listSection;
    private ListEntriesEditGroup listEntryGroup;
    private PageBook pageBook;
    private RadiosDialogField beanTypeField;
    private int currentPageIndex = 0;

    public InitializationSection(Composite parent, IManagedForm managedForm, IFacesConfigPage page, FormToolkit toolkit) {
        super(parent, managedForm, page, toolkit, null, null);
        this.getSection().setText(EditorMessages.InitializationSection_Name);
        this.getSection().setDescription(EditorMessages.InitializationSection_Description);
    }

    protected void createContents(Composite container, FormToolkit toolkit) {
        int numberOfColumns = 3;
        GridLayout gl = new GridLayout(numberOfColumns, false);
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        container.setLayout((Layout)gl);
        toolkit.paintBordersFor(container);
        this.createBeanTypeEntry(container, toolkit, numberOfColumns);
        this.createInitializationEntry(container, toolkit, numberOfColumns);
    }

    private void createBeanTypeEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.beanTypeField = new RadiosDialogField();
        String[] items = new String[]{MANAGEDBEAN_GENERAL_CLASS, MANAGEDBEAN_MAP, MANAGEDBEAN_LIST};
        this.beanTypeField.setLabelText(EditorMessages.InitializationSection_ClassType);
        this.beanTypeField.setItems(items);
        this.beanTypeField.doFillIntoGrid(toolkit, container, numberOfColumns);
        this.beanTypeField.setDialogFieldApplyListener(new IDialogFieldApplyListener(){

            public void dialogFieldApplied(DialogField field) {
                RadiosDialogField beanTypeField = (RadiosDialogField)field;
                boolean bChangedSuccess = false;
                if (beanTypeField.getSelectedIndex() == 0) {
                    bChangedSuccess = InitializationSection.this.switchPage("managed-property", false);
                } else if (beanTypeField.getSelectedIndex() == 1) {
                    bChangedSuccess = InitializationSection.this.switchPage("map-entries", false);
                } else if (beanTypeField.getSelectedIndex() == 2) {
                    bChangedSuccess = InitializationSection.this.switchPage("list-entries", false);
                }
                if (bChangedSuccess) {
                    InitializationSection.this.currentPageIndex = beanTypeField.getSelectedIndex();
                } else {
                    beanTypeField.setSelectedIndexWithoutUpdate(-1);
                    beanTypeField.setSelectedIndexWithoutUpdate(InitializationSection.this.currentPageIndex);
                }
            }
        });
    }

    private boolean switchPage(String pageID, boolean bForceClearOthers) {
        if (pageID == "managed-property") {
            if (this.clearPage("map-entries", bForceClearOthers) && this.clearPage("list-entries", bForceClearOthers)) {
                this.managedPropertyGroup.refreshAll();
                this.pageBook.showPage((Control)this.propertySection);
                this.getSection().setExpanded(false);
                this.getSection().setExpanded(true);
                return true;
            }
        } else if (pageID == "map-entries") {
            if (this.clearPage("managed-property", bForceClearOthers) && this.clearPage("list-entries", bForceClearOthers)) {
                this.mapEntryGroup.refreshAll();
                this.pageBook.showPage((Control)this.mapSection);
                this.getSection().setExpanded(false);
                this.getSection().setExpanded(true);
                return true;
            }
        } else if (pageID == "list-entries" && this.clearPage("managed-property", bForceClearOthers) && this.clearPage("map-entries", bForceClearOthers)) {
            this.listEntryGroup.refreshAll();
            this.pageBook.showPage((Control)this.listSection);
            this.getSection().setExpanded(false);
            this.getSection().setExpanded(true);
            return true;
        }
        return false;
    }

    private boolean clearPage(String pageID, boolean bForceClear) {
        ManagedBeanType managedBean = (ManagedBeanType)this.getInput();
        if (pageID == "managed-property") {
            if (managedBean.getManagedProperty().size() == 0) {
                return true;
            }
            if (bForceClear || EditorPlugin.getAlerts().confirm("ManagedBeanInitializationSection.Remove.Title", "ManagedBeanInitializationSection.RemoveManagedProperty")) {
                Command cmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedBean, (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_ManagedProperty(), (Object)SetCommand.UNSET_VALUE);
                if (cmd.canExecute()) {
                    this.getEditingDomain().getCommandStack().execute(cmd);
                    return true;
                }
                return false;
            }
        } else if (pageID == "map-entries") {
            Command cmd;
            if (managedBean.getMapEntries() == null) {
                return true;
            }
            if ((bForceClear || EditorPlugin.getAlerts().confirm("ManagedBeanInitializationSection.Remove.Title", "ManagedBeanInitializationSection.RemoveMapEntries")) && (cmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedBean, (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_MapEntries(), (Object)SetCommand.UNSET_VALUE)).canExecute()) {
                this.getEditingDomain().getCommandStack().execute(cmd);
                return true;
            }
        } else if (pageID == "list-entries") {
            Command cmd;
            if (managedBean.getListEntries() == null) {
                return true;
            }
            if ((bForceClear || EditorPlugin.getAlerts().confirm("ManagedBeanInitializationSection.Remove.Title", "ManagedBeanInitializationSection.RemoveListEntries")) && (cmd = SetCommand.create((EditingDomain)this.getEditingDomain(), (Object)managedBean, (Object)FacesConfigPackage.eINSTANCE.getManagedBeanType_ListEntries(), (Object)SetCommand.UNSET_VALUE)).canExecute()) {
                this.getEditingDomain().getCommandStack().execute(cmd);
                return true;
            }
        }
        return false;
    }

    private void createInitializationEntry(Composite container, FormToolkit toolkit, int numberOfColumns) {
        this.pageBook = new PageBook(container, 0);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = numberOfColumns;
        this.pageBook.setLayoutData((Object)gd);
        toolkit.paintBordersFor((Composite)this.pageBook);
        this.managedPropertyGroup = new ManagedPropertyEditGroup(this);
        this.managedPropertyGroup.initialize();
        this.managedPropertyGroup.addSelectionChangedListener(this);
        this.mapEntryGroup = new MapEntriesEditGroup(this);
        this.mapEntryGroup.initialize();
        this.mapEntryGroup.addSelectionChangedListener(this);
        this.listEntryGroup = new ListEntriesEditGroup(this);
        this.listEntryGroup.initialize();
        this.listEntryGroup.addSelectionChangedListener(this);
        this.propertySection = toolkit.createComposite((Composite)this.pageBook);
        GridLayout gl = new GridLayout();
        gl.horizontalSpacing = 0;
        gl.marginWidth = 0;
        this.propertySection.setLayout((Layout)gl);
        gd = new GridData(1808);
        this.propertySection.setLayoutData((Object)gd);
        this.managedPropertyGroup.layoutDialogFields(toolkit, this.propertySection);
        this.mapSection = toolkit.createComposite((Composite)this.pageBook);
        this.mapEntryGroup.layoutDialogFields(toolkit, this.mapSection);
        this.listSection = toolkit.createComposite((Composite)this.pageBook);
        this.listEntryGroup.layoutDialogFields(toolkit, this.listSection);
        this.pageBook.showPage((Control)this.propertySection);
    }

    public void setInput(Object newInput) {
        super.setInput(newInput);
        this.refreshAll();
    }

    public void refreshAll() {
        if (this.getInput() instanceof ManagedBeanType) {
            ManagedBeanType managedBean = (ManagedBeanType)this.getInput();
            this.managedPropertyGroup.setInput(managedBean);
            this.mapEntryGroup.setInput(managedBean);
            this.listEntryGroup.setInput(managedBean);
            if (managedBean.getManagedProperty().size() > 0) {
                this.beanTypeField.setSelectedIndexWithoutUpdate(-1);
                this.beanTypeField.setSelectedIndex(0);
            } else if (managedBean.getMapEntries() != null) {
                this.beanTypeField.setSelectedIndexWithoutUpdate(-1);
                this.beanTypeField.setSelectedIndex(1);
            } else if (managedBean.getListEntries() != null) {
                this.beanTypeField.setSelectedIndexWithoutUpdate(-1);
                this.beanTypeField.setSelectedIndex(2);
            } else {
                this.beanTypeField.setSelectedIndexWithoutUpdate(-1);
                this.beanTypeField.setSelectedIndex(0);
            }
        }
    }

    public void clearAll() {
    }

    public ISelection getSelection() {
        return super.getSelection();
    }
}

