/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IPublishListener;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerEvent;
import org.eclipse.wst.server.core.ServerPort;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.Base;
import org.eclipse.wst.server.core.internal.ChainedJob;
import org.eclipse.wst.server.core.internal.DeletedModule;
import org.eclipse.wst.server.core.internal.IMemento;
import org.eclipse.wst.server.core.internal.IModuleVisitor;
import org.eclipse.wst.server.core.internal.IPublishTask;
import org.eclipse.wst.server.core.internal.Messages;
import org.eclipse.wst.server.core.internal.ModuleType;
import org.eclipse.wst.server.core.internal.ProgressUtil;
import org.eclipse.wst.server.core.internal.PublishInfo;
import org.eclipse.wst.server.core.internal.PublishServerJob;
import org.eclipse.wst.server.core.internal.ResourceManager;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.core.internal.ServerNotificationManager;
import org.eclipse.wst.server.core.internal.ServerPlugin;
import org.eclipse.wst.server.core.internal.ServerPreferences;
import org.eclipse.wst.server.core.internal.ServerPublishInfo;
import org.eclipse.wst.server.core.internal.ServerSchedulingRule;
import org.eclipse.wst.server.core.internal.ServerType;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.InternalInitializer;
import org.eclipse.wst.server.core.model.PublishOperation;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.eclipse.wst.server.core.model.ServerDelegate;
import org.eclipse.wst.server.core.util.SocketUtil;

public class Server
extends Base
implements IServer {
    public static final String ATTR_SERVER_ID = "server-id";
    protected static final List EMPTY_LIST = new ArrayList(0);
    public static final String FILE_EXTENSION = "server";
    public static final int AUTO_PUBLISH_DEFAULT = 0;
    public static final int AUTO_PUBLISH_DISABLE = 1;
    public static final int AUTO_PUBLISH_OVERRIDE = 2;
    protected static final String PROP_HOSTNAME = "hostname";
    protected static final String SERVER_ID = "server-id";
    protected static final String RUNTIME_ID = "runtime-id";
    protected static final String CONFIGURATION_ID = "configuration-id";
    protected static final String MODULE_LIST = "modules";
    protected static final String PROP_DISABLED_PERFERRED_TASKS = "disabled-preferred-publish-tasks";
    protected static final String PROP_ENABLED_OPTIONAL_TASKS = "enabled-optional-publish-tasks";
    public static final String PROP_AUTO_PUBLISH_TIME = "auto-publish-time";
    public static final String PROP_AUTO_PUBLISH_SETTING = "auto-publish-setting";
    protected static final char[] INVALID_CHARS;
    protected IServerType serverType;
    protected ServerDelegate delegate;
    protected ServerBehaviourDelegate behaviourDelegate;
    protected IRuntime runtime;
    protected IFolder configuration;
    protected List modules;
    protected List externalModules;
    protected transient String mode = "run";
    protected transient int serverState = 0;
    protected transient int serverSyncState;
    protected transient boolean serverRestartNeeded;
    protected transient Map moduleState = new HashMap();
    protected transient Map modulePublishState = new HashMap();
    protected transient Map moduleRestartState = new HashMap();
    protected transient IStatus serverStatus;
    protected transient Map moduleStatus = new HashMap();
    protected transient ServerPublishInfo publishInfo;
    protected transient AutoPublishThread autoPublishThread;
    protected transient List publishListeners;
    protected transient ServerNotificationManager notificationManager;
    private static final Comparator PUBLISH_OPERATION_COMPARTOR;
    static /* synthetic */ Class class$0;

    static {
        char[] cArray = new char[12];
        cArray[0] = 92;
        cArray[1] = 47;
        cArray[2] = 58;
        cArray[3] = 42;
        cArray[4] = 63;
        cArray[5] = 34;
        cArray[6] = 60;
        cArray[7] = 62;
        cArray[8] = 124;
        cArray[10] = 64;
        cArray[11] = 38;
        INVALID_CHARS = cArray;
        PUBLISH_OPERATION_COMPARTOR = new Comparator(){

            public int compare(Object leftOp, Object rightOp) {
                PublishOperation left = (PublishOperation)leftOp;
                PublishOperation right = (PublishOperation)rightOp;
                if (left.getOrder() > right.getOrder()) {
                    return 1;
                }
                if (left.getOrder() < right.getOrder()) {
                    return -1;
                }
                return 0;
            }
        };
    }

    public Server(IFile file) {
        super(file);
        this.map.put(PROP_HOSTNAME, "localhost");
    }

    public Server(String id, IFile file, IRuntime runtime, IServerType serverType) {
        super(file, id);
        this.runtime = runtime;
        this.serverType = serverType;
        this.map.put("server-type-id", serverType.getId());
        this.map.put(PROP_HOSTNAME, "localhost");
        if (runtime != null && runtime.getRuntimeType() != null) {
            String name = runtime.getRuntimeType().getName();
            this.map.put("name", name);
        }
        this.serverState = ((ServerType)serverType).getInitialState();
    }

    public IServerType getServerType() {
        return this.serverType;
    }

    public IServerWorkingCopy createWorkingCopy() {
        return new ServerWorkingCopy(this);
    }

    public boolean isWorkingCopy() {
        return false;
    }

    protected void deleteFromFile() throws CoreException {
        super.deleteFromFile();
        ResourceManager.getInstance().removeServer(this);
    }

    protected void deleteFromMetadata() {
        ResourceManager.getInstance().removeServer(this);
    }

    protected void saveToFile(IProgressMonitor monitor) throws CoreException {
        super.saveToFile(monitor);
        ResourceManager.getInstance().addServer(this);
    }

    protected void saveToMetadata(IProgressMonitor monitor) {
        super.saveToMetadata(monitor);
        ResourceManager.getInstance().addServer(this);
    }

    public IRuntime getRuntime() {
        return this.runtime;
    }

    protected String getRuntimeId() {
        return this.getAttribute(RUNTIME_ID, (String)null);
    }

    public IFolder getServerConfiguration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerDelegate getDelegate(IProgressMonitor monitor) {
        if (this.delegate != null || this.serverType == null) {
            return this.delegate;
        }
        Server server = this;
        synchronized (server) {
            if (this.delegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    this.delegate = ((ServerType)this.serverType).createServerDelegate();
                    InternalInitializer.initializeServerDelegate(this.delegate, this, monitor);
                    Trace.trace(10, "Server.getDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getServerType().getId());
                }
                catch (Throwable t) {
                    Trace.trace(3, "Could not create delegate " + this.toString(), t);
                }
            }
        }
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ServerBehaviourDelegate getBehaviourDelegate(IProgressMonitor monitor) {
        if (this.behaviourDelegate != null || this.serverType == null) {
            return this.behaviourDelegate;
        }
        Map map = this.moduleState;
        synchronized (map) {
            if (this.behaviourDelegate == null) {
                try {
                    long time = System.currentTimeMillis();
                    this.behaviourDelegate = ((ServerType)this.serverType).createServerBehaviourDelegate();
                    InternalInitializer.initializeServerBehaviourDelegate(this.behaviourDelegate, this, monitor);
                    Trace.trace(10, "Server.getBehaviourDelegate(): <" + (System.currentTimeMillis() - time) + "> " + this.getServerType().getId());
                    if (this.getServerState() == 2) {
                        this.autoPublish();
                    }
                }
                catch (Throwable t) {
                    Trace.trace(3, "Could not create behaviour delegate " + this.toString(), t);
                }
            }
        }
        return this.behaviourDelegate;
    }

    public void dispose() {
        if (this.delegate != null) {
            this.delegate.dispose();
            this.delegate = null;
        }
        if (this.behaviourDelegate != null) {
            this.behaviourDelegate.dispose();
            this.behaviourDelegate = null;
        }
    }

    public String getHost() {
        return this.getAttribute(PROP_HOSTNAME, "localhost");
    }

    public int getAutoPublishTime() {
        return this.getAttribute(PROP_AUTO_PUBLISH_TIME, -1);
    }

    public int getAutoPublishSetting() {
        return this.getAttribute(PROP_AUTO_PUBLISH_SETTING, 0);
    }

    public List getDisabledPreferredPublishOperationIds() {
        return this.getAttribute(PROP_DISABLED_PERFERRED_TASKS, EMPTY_LIST);
    }

    public List getEnabledOptionalPublishOperationIds() {
        return this.getAttribute(PROP_ENABLED_OPTIONAL_TASKS, EMPTY_LIST);
    }

    public int getServerState() {
        return this.serverState;
    }

    public String getMode() {
        return this.mode;
    }

    public void setServerState(int state) {
        if (state == this.serverState) {
            return;
        }
        this.serverState = state;
        this.fireServerStateChangeEvent();
    }

    public void addServerListener(IServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Trace.trace(8, "Adding server listener " + listener + " to " + this);
        this.getServerNotificationManager().addListener(listener);
    }

    public void addServerListener(IServerListener listener, int eventMask) {
        if (listener == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Trace.trace(8, "Adding server listener " + listener + " to " + this + " with eventMask " + eventMask);
        this.getServerNotificationManager().addListener(listener, eventMask);
    }

    public void removeServerListener(IServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        Trace.trace(8, "Removing server listener " + listener + " from " + this);
        this.getServerNotificationManager().removeListener(listener);
    }

    protected void fireRestartStateChangeEvent() {
        Trace.trace(8, "->- Firing server restart change event: " + this.getName() + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(20, this, this.getServerState(), this.getServerPublishState(), this.getServerRestartState()));
    }

    protected void fireServerStateChangeEvent() {
        Trace.trace(8, "->- Firing server state change event: " + this.getName() + ", " + this.getServerState() + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(17, this, this.getServerState(), this.getServerPublishState(), this.getServerRestartState()));
    }

    protected void fireModuleStateChangeEvent(IModule[] module) {
        Trace.trace(8, "->- Firing module state change event: " + this.getName() + ", " + this.getServerState() + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(33, this, module, this.getModuleState(module), this.getModulePublishState(module), this.getModuleRestartState(module)));
    }

    protected void fireModulePublishStateChangeEvent(IModule[] module) {
        Trace.trace(8, "->- Firing module publish state change event: " + this.getName() + ", " + this.getServerState() + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(34, this, module, this.getModuleState(module), this.getModulePublishState(module), this.getModuleRestartState(module)));
    }

    protected void fireModuleRestartChangeEvent(IModule[] module) {
        Trace.trace(8, "->- Firing module restart change event: " + this.getName() + ", " + this.getServerState() + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(36, this, module, this.getModuleState(module), this.getModulePublishState(module), this.getModuleRestartState(module)));
    }

    public void setMode(String m) {
        if (m == this.mode) {
            return;
        }
        this.mode = m;
        this.fireServerStateChangeEvent();
    }

    public void setModuleState(IModule[] module, int state) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        int oldState = this.getModuleState(module);
        if (oldState == state) {
            return;
        }
        Integer in = new Integer(state);
        this.moduleState.put(this.getKey(module), in);
        this.fireModuleStateChangeEvent(module);
    }

    public void setModulePublishState(IModule[] module, int state) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        int oldState = this.getModulePublishState(module);
        if (oldState == state) {
            return;
        }
        Integer in = new Integer(state);
        if (state == -1) {
            this.modulePublishState.remove(this.getKey(module));
        }
        this.modulePublishState.put(this.getKey(module), in);
        this.fireModulePublishStateChangeEvent(module);
    }

    public void setModuleRestartState(IModule[] module, boolean r) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        boolean oldState = this.getModuleRestartState(module);
        if (oldState == r) {
            return;
        }
        Boolean b = new Boolean(r);
        this.moduleState.put(this.getKey(module), b);
        this.fireModuleRestartChangeEvent(module);
    }

    public void setExternalModules(IModule[] modules) {
        this.externalModules = new ArrayList();
        if (modules != null) {
            int size = modules.length;
            int i = 0;
            while (i < size) {
                this.externalModules.add(modules[i]);
                ++i;
            }
        }
    }

    protected List getExternalModules() {
        return this.externalModules;
    }

    protected void handleModuleProjectChange(IModule module) {
        Trace.trace(5, "> handleDeployableProjectChange() " + this + " " + module);
        Job[] jobs = Job.getJobManager().find(ServerUtil.SERVER_JOB_FAMILY);
        if (jobs != null) {
            int size = jobs.length;
            int i = 0;
            while (i < size) {
                ResourceChangeJob rcj;
                if (jobs[i] instanceof ResourceChangeJob && (rcj = (ResourceChangeJob)jobs[i]).getServer().equals(this) && rcj.getModule().equals(module) && rcj.getState() == 2) {
                    return;
                }
                ++i;
            }
        }
        ResourceChangeJob job = new ResourceChangeJob(module, this);
        job.setSystem(true);
        job.setPriority(40);
        job.schedule();
        Trace.trace(5, "< handleDeployableProjectChange()");
    }

    protected void stopAutoPublish() {
        if (this.autoPublishThread == null) {
            return;
        }
        this.autoPublishThread.stop = true;
        this.autoPublishThread.interrupt();
        this.autoPublishThread = null;
    }

    protected void autoPublish() {
        this.stopAutoPublish();
        if (this.getAutoPublishSetting() == 1) {
            return;
        }
        int time = 0;
        if (this.getAutoPublishSetting() == 0) {
            ServerPreferences pref = ServerPreferences.getInstance();
            boolean local = SocketUtil.isLocalhost(this.getHost());
            if (local && pref.getAutoPublishLocal()) {
                time = pref.getAutoPublishLocalTime();
            } else if (!local && pref.getAutoPublishRemote()) {
                time = pref.getAutoPublishRemoteTime();
            }
        } else {
            time = this.getAutoPublishTime();
        }
        if (time > 0) {
            this.autoPublishThread = new AutoPublishThread();
            this.autoPublishThread.time = time;
            this.autoPublishThread.setPriority(2);
            this.autoPublishThread.start();
        }
    }

    private ServerNotificationManager getServerNotificationManager() {
        if (this.notificationManager == null) {
            this.notificationManager = new ServerNotificationManager();
        }
        return this.notificationManager;
    }

    public int getServerPublishState() {
        return this.serverSyncState;
    }

    public void setServerPublishState(int state) {
        if (state == this.serverSyncState) {
            return;
        }
        this.serverSyncState = state;
        this.firePublishStateChange();
    }

    public void addPublishListener(IPublishListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Trace.trace(8, "Adding publish listener " + listener + " to " + this);
        if (this.publishListeners == null) {
            this.publishListeners = new ArrayList();
        }
        this.publishListeners.add(listener);
    }

    public void removePublishListener(IPublishListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener cannot be null");
        }
        Trace.trace(8, "Removing publish listener " + listener + " from " + this);
        if (this.publishListeners != null) {
            this.publishListeners.remove(listener);
        }
    }

    private void firePublishStarted() {
        Trace.trace(5, "->- Firing publish started event ->-");
        if (this.publishListeners == null || this.publishListeners.isEmpty()) {
            return;
        }
        int size = this.publishListeners.size();
        IPublishListener[] srl = new IPublishListener[size];
        this.publishListeners.toArray(srl);
        int i = 0;
        while (i < size) {
            Trace.trace(5, "  Firing publish started event to " + srl[i]);
            try {
                srl[i].publishStarted(this);
            }
            catch (Exception e) {
                Trace.trace(3, "  Error firing publish started event to " + srl[i], e);
            }
            ++i;
        }
        Trace.trace(5, "-<- Done firing publish started event -<-");
    }

    private void firePublishFinished(IStatus status) {
        Trace.trace(5, "->- Firing publishing finished event: " + status + " ->-");
        if (this.publishListeners == null || this.publishListeners.isEmpty()) {
            return;
        }
        int size = this.publishListeners.size();
        IPublishListener[] srl = new IPublishListener[size];
        this.publishListeners.toArray(srl);
        int i = 0;
        while (i < size) {
            Trace.trace(5, "  Firing publishing finished event to " + srl[i]);
            try {
                srl[i].publishFinished(this, status);
            }
            catch (Exception e) {
                Trace.trace(3, "  Error firing publishing finished event to " + srl[i], e);
            }
            ++i;
        }
        Trace.trace(5, "-<- Done firing publishing finished event -<-");
    }

    protected void firePublishStateChange() {
        Trace.trace(5, "->- Firing publish state change event ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(18, this, this.getServerState(), this.getServerPublishState(), this.getServerRestartState()));
    }

    protected void firePublishStateChange(IModule[] module) {
        Trace.trace(5, "->- Firing publish state change event: " + module + " ->-");
        if (this.notificationManager == null || this.notificationManager.hasListenerEntries()) {
            return;
        }
        this.notificationManager.broadcastChange(new ServerEvent(34, this, module, this.getModuleState(module), this.getModulePublishState(module), this.getModuleRestartState(module)));
    }

    public IStatus canPublish() {
        if (this.getServerType() == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorMissingAdapter, null);
        }
        int state = this.getServerState();
        if (state == 1 || state == 3) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishStarting, null);
        }
        if (this.getServerType().hasServerConfiguration() && this.configuration == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishNoConfiguration, null);
        }
        return Status.OK_STATUS;
    }

    public boolean shouldPublish() {
        if (!this.canPublish().isOK()) {
            return false;
        }
        if (this.getServerPublishState() != 1) {
            return true;
        }
        final boolean[] publish = new boolean[1];
        this.visit(new IModuleVisitor(){

            public boolean visit(IModule[] module) {
                if (Server.this.getModulePublishState(module) != 1) {
                    publish[0] = true;
                    return false;
                }
                return true;
            }
        }, null);
        return publish[0];
    }

    public boolean shouldRestart() {
        if (!this.canPublish().isOK()) {
            return false;
        }
        if (this.getServerRestartState()) {
            return true;
        }
        final boolean[] publish = new boolean[1];
        this.visit(new IModuleVisitor(){

            public boolean visit(IModule[] module) {
                if (Server.this.getModuleRestartState(module)) {
                    publish[0] = true;
                    return false;
                }
                return true;
            }
        }, null);
        return publish[0];
    }

    public ServerPublishInfo getServerPublishInfo() {
        if (this.publishInfo == null) {
            this.publishInfo = PublishInfo.getInstance().getServerPublishInfo(this);
        }
        return this.publishInfo;
    }

    public IStatus publish(int kind, IProgressMonitor monitor) {
        if (this.getServerType() == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorMissingAdapter, null);
        }
        if (this.getServerType().hasServerConfiguration() && this.configuration == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorNoConfiguration, null);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ServerBehaviourDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.loadAdapter(clazz, monitor);
        if (((ServerType)this.getServerType()).startBeforePublish() && this.getServerState() == 4) {
            try {
                this.synchronousStart("run", monitor);
            }
            catch (CoreException ce) {
                Trace.trace(3, "Error starting server", ce);
                return ce.getStatus();
            }
        }
        long time = System.currentTimeMillis();
        this.firePublishStarted();
        IStatus status = this.doPublish(kind, monitor);
        this.firePublishFinished(status);
        Trace.trace(10, "Server.publish(): <" + (System.currentTimeMillis() - time) + "> " + this.getServerType().getId());
        return status;
    }

    protected IStatus doPublish(int kind, IProgressMonitor monitor) {
        Trace.trace(5, "-->-- Publishing to server: " + this.toString() + " -->--");
        this.stopAutoPublish();
        try {
            this.getServerPublishInfo().startCaching();
            IStatus status = this.getBehaviourDelegate(monitor).publish(kind, monitor);
            final ArrayList modules2 = new ArrayList();
            this.visit(new IModuleVisitor(){

                public boolean visit(IModule[] module) {
                    if (Server.this.getModulePublishState(module) == 1) {
                        Server.this.getServerPublishInfo().fill(module);
                    }
                    modules2.add(module);
                    return true;
                }
            }, monitor);
            this.getServerPublishInfo().removeDeletedModulePublishInfo(this, modules2);
            this.getServerPublishInfo().clearCache();
            this.getServerPublishInfo().save();
            return status;
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate publish() " + this.toString(), e);
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorPublishing, (Throwable)e);
        }
    }

    public PublishOperation[] getTasks(int kind, List moduleList, List kindList) {
        ArrayList<PublishOperation> tasks = new ArrayList<PublishOperation>();
        String serverTypeId = this.getServerType().getId();
        IPublishTask[] publishTasks = ServerPlugin.getPublishTasks();
        if (publishTasks != null) {
            List enabledTasks = this.getEnabledOptionalPublishOperationIds();
            List disabledTasks = this.getDisabledPreferredPublishOperationIds();
            TaskModel taskModel = new TaskModel();
            taskModel.putObject(FILE_EXTENSION, this);
            int size = publishTasks.length;
            int i = 0;
            while (i < size) {
                PublishOperation[] tasks2;
                IPublishTask task = publishTasks[i];
                if (task.supportsType(serverTypeId) && (tasks2 = task.getTasks(this, kind, moduleList, kindList)) != null) {
                    int size2 = tasks2.length;
                    int j = 0;
                    while (j < size2) {
                        String opId;
                        if (tasks2[j].getKind() == 2) {
                            tasks.add(tasks2[j]);
                            tasks2[j].setTaskModel(taskModel);
                        } else if (tasks2[j].getKind() == 1) {
                            opId = this.getPublishOperationId(tasks2[j]);
                            if (!disabledTasks.contains(opId)) {
                                tasks.add(tasks2[j]);
                                tasks2[j].setTaskModel(taskModel);
                            }
                        } else if (tasks2[j].getKind() == 0 && enabledTasks.contains(opId = this.getPublishOperationId(tasks2[j]))) {
                            tasks.add(tasks2[j]);
                            tasks2[j].setTaskModel(taskModel);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        Collections.sort(tasks, PUBLISH_OPERATION_COMPARTOR);
        return tasks.toArray(new PublishOperation[tasks.size()]);
    }

    public PublishOperation[] getAllTasks(List moduleList) {
        String serverTypeId = this.getServerType().getId();
        if (serverTypeId == null) {
            return new PublishOperation[0];
        }
        ArrayList<PublishOperation> tasks = new ArrayList<PublishOperation>();
        IPublishTask[] publishTasks = ServerPlugin.getPublishTasks();
        if (publishTasks != null) {
            int size = publishTasks.length;
            int i = 0;
            while (i < size) {
                IPublishTask task = publishTasks[i];
                if (task.supportsType(serverTypeId)) {
                    PublishOperation[] tasks2 = task.getTasks(this, moduleList);
                    tasks.addAll(Arrays.asList(tasks2));
                }
                ++i;
            }
        }
        Collections.sort(tasks, PUBLISH_OPERATION_COMPARTOR);
        return tasks.toArray(new PublishOperation[tasks.size()]);
    }

    public String getPublishOperationId(PublishOperation op) {
        return String.valueOf(this.getId()) + "|" + op.getLabel();
    }

    public List getAllModules() {
        final ArrayList moduleList = new ArrayList();
        IModuleVisitor visitor = new IModuleVisitor(){

            public boolean visit(IModule[] module) {
                if (!moduleList.contains(module)) {
                    moduleList.add(module);
                }
                return true;
            }
        };
        this.visit(visitor, null);
        return moduleList;
    }

    public IModuleResource[] getResources(IModule[] module) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        return this.getServerPublishInfo().getResources(module);
    }

    public IModuleResource[] getPublishedResources(IModule[] module) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        return this.getServerPublishInfo().getModulePublishInfo(module).getResources();
    }

    public IModuleResourceDelta[] getPublishedResourceDelta(IModule[] module) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        return this.getServerPublishInfo().getDelta(module);
    }

    public boolean hasPublishedResourceDelta(IModule[] module) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        return this.getServerPublishInfo().hasDelta(module);
    }

    public Object getAdapter(Class adapter) {
        if (this.delegate != null && adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        if (this.behaviourDelegate != null && adapter.isInstance(this.behaviourDelegate)) {
            return this.behaviourDelegate;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public Object loadAdapter(Class adapter, IProgressMonitor monitor) {
        this.getDelegate(monitor);
        if (adapter.isInstance(this.delegate)) {
            return this.delegate;
        }
        this.getBehaviourDelegate(monitor);
        if (adapter.isInstance(this.behaviourDelegate)) {
            return this.behaviourDelegate;
        }
        return Platform.getAdapterManager().loadAdapter((Object)this, adapter.getName());
    }

    public String toString() {
        return this.getName();
    }

    public IStatus canStart(String mode2) {
        if (this.getServerType() == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorMissingAdapter, null);
        }
        int state = this.getServerState();
        if (state != 4 && state != 0) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.canStartErrorState, null);
        }
        if (!this.getServerType().supportsLaunchMode(mode2)) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorLaunchMode, null);
        }
        return Status.OK_STATUS;
    }

    public ILaunch getExistingLaunch() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int size = launches.length;
        int i = 0;
        while (i < size) {
            ILaunchConfiguration launchConfig = launches[i].getLaunchConfiguration();
            try {
                if (launchConfig != null) {
                    String serverId = launchConfig.getAttribute("server-id", null);
                    if (this.getId().equals(serverId) && !launches[i].isTerminated()) {
                        return launches[i];
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) {
        try {
            this.getBehaviourDelegate(monitor).setupLaunchConfiguration(workingCopy, monitor);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate setupLaunchConfiguration() " + this.toString(), e);
        }
    }

    public ILaunchConfiguration getLaunchConfiguration(boolean create, IProgressMonitor monitor) throws CoreException {
        if (this.getServerType() == null) {
            return null;
        }
        ILaunchConfigurationType launchConfigType = ((ServerType)this.getServerType()).getLaunchConfigurationType();
        if (launchConfigType == null) {
            return null;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] launchConfigs = null;
        try {
            launchConfigs = launchManager.getLaunchConfigurations(launchConfigType);
        }
        catch (CoreException coreException) {}
        if (launchConfigs != null) {
            int size = launchConfigs.length;
            int i = 0;
            while (i < size) {
                block13: {
                    try {
                        String serverId = launchConfigs[i].getAttribute("server-id", null);
                        if (!this.getId().equals(serverId)) break block13;
                        final ILaunchConfigurationWorkingCopy wc = launchConfigs[i].getWorkingCopy();
                        this.setupLaunchConfiguration(wc, monitor);
                        if (wc.isDirty()) {
                            final ILaunchConfiguration[] lc = new ILaunchConfiguration[1];
                            Job job = new Job("Saving launch configuration"){

                                protected IStatus run(IProgressMonitor monitor2) {
                                    try {
                                        lc[0] = wc.doSave();
                                    }
                                    catch (CoreException ce) {
                                        Trace.trace(3, "Error configuring launch", ce);
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.setSystem(true);
                            job.schedule();
                            try {
                                job.join();
                            }
                            catch (Exception e) {
                                Trace.trace(3, "Error configuring launch", e);
                            }
                            if (job.getState() != 0) {
                                job.cancel();
                                lc[0] = wc.doSave();
                            }
                            return lc[0];
                        }
                        return launchConfigs[i];
                    }
                    catch (CoreException e) {
                        Trace.trace(3, "Error configuring launch", e);
                    }
                }
                ++i;
            }
        }
        if (!create) {
            return null;
        }
        String launchName = this.getValidLaunchConfigurationName(this.getName());
        launchName = launchManager.generateUniqueLaunchConfigurationNameFrom(launchName);
        ILaunchConfigurationWorkingCopy wc = launchConfigType.newInstance(null, launchName);
        wc.setAttribute("server-id", this.getId());
        this.setupLaunchConfiguration(wc, monitor);
        return wc.doSave();
    }

    protected String getValidLaunchConfigurationName(String s) {
        if (s == null || s.length() == 0) {
            return "1";
        }
        int size = INVALID_CHARS.length;
        int i = 0;
        while (i < size) {
            s = s.replace(INVALID_CHARS[i], '_');
            ++i;
        }
        return s;
    }

    public void start(String mode2, IProgressMonitor monitor) throws CoreException {
        Trace.trace(5, "Starting server: " + this.toString() + ", launchMode: " + mode2);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ServerBehaviourDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.loadAdapter(clazz, monitor);
        try {
            ILaunchConfiguration launchConfig = this.getLaunchConfiguration(true, monitor);
            ILaunch launch = launchConfig.launch(mode2, monitor);
            Trace.trace(5, "Launch: " + launch);
        }
        catch (CoreException e) {
            Trace.trace(3, "Error starting server " + this.toString(), e);
            throw e;
        }
    }

    protected void deleteMetadata() {
        this.deleteLaunchConfigurations();
        ServerPlugin.getInstance().removeTempDirectory(this.getId());
        PublishInfo.getInstance().removeServerPublishInfo(this);
    }

    protected void deleteLaunchConfigurations() {
        if (this.getServerType() == null) {
            return;
        }
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType launchConfigType = ((ServerType)this.getServerType()).getLaunchConfigurationType();
        ILaunchConfiguration[] configs = null;
        try {
            configs = launchManager.getLaunchConfigurations(launchConfigType);
            int size = configs.length;
            int i = 0;
            while (i < size) {
                try {
                    if (this.getId().equals(configs[i].getAttribute("server-id", null))) {
                        configs[i].delete();
                    }
                }
                catch (Exception exception) {}
                ++i;
            }
        }
        catch (Exception exception) {}
    }

    public IStatus canRestart(String mode2) {
        if (this.getServerType() == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorMissingAdapter, null);
        }
        if (!this.getServerType().supportsLaunchMode(mode2)) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorLaunchMode, null);
        }
        int state = this.getServerState();
        if (state == 2) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorRestartNotStarted, null);
    }

    public boolean getServerRestartState() {
        if (this.getServerState() == 4) {
            return false;
        }
        return this.serverRestartNeeded;
    }

    public synchronized void setServerRestartState(boolean state) {
        if (state == this.serverRestartNeeded) {
            return;
        }
        this.serverRestartNeeded = state;
        this.fireRestartStateChangeEvent();
    }

    public void restart(final String mode2, final IProgressMonitor monitor) {
        if (this.getServerType() == null || this.getServerState() == 4) {
            return;
        }
        Trace.trace(5, "Restarting server: " + this.getName());
        try {
            try {
                this.getBehaviourDelegate(null).restart(mode2);
                return;
            }
            catch (CoreException coreException) {
                Trace.trace(3, "Error calling delegate restart() " + this.toString());
                this.addServerListener(new IServerListener(){

                    public void serverChanged(ServerEvent event) {
                        int eventKind = event.getKind();
                        IServer server = event.getServer();
                        if (eventKind == 17 && server.getServerState() == 4) {
                            server.removeServerListener(this);
                            Thread t = new Thread(this, mode2, monitor){
                                final /* synthetic */ 8 this$1;
                                private final /* synthetic */ String val$mode2;
                                private final /* synthetic */ IProgressMonitor val$monitor;
                                {
                                    this.this$1 = var1_1;
                                    this.val$mode2 = string;
                                    this.val$monitor = iProgressMonitor;
                                }

                                public void run() {
                                    try {
                                        Thread.sleep(250L);
                                    }
                                    catch (Exception exception) {}
                                    ServerType st = (ServerType)8.access$0(this.this$1).getServerType();
                                    if (st.startBeforePublish()) {
                                        try {
                                            8.access$0(this.this$1).start(this.val$mode2, this.val$monitor);
                                        }
                                        catch (Exception e) {
                                            Trace.trace(3, "Error while restarting server", e);
                                        }
                                    }
                                    if (ServerPreferences.getInstance().isAutoPublishing() && 8.access$0(this.this$1).shouldPublish()) {
                                        8.access$0(this.this$1).publish(1, null);
                                    }
                                    if (8.access$0(this.this$1).getServerState() != 2) {
                                        try {
                                            8.access$0(this.this$1).start(this.val$mode2, this.val$monitor);
                                        }
                                        catch (Exception e) {
                                            Trace.trace(3, "Error while restarting server", e);
                                        }
                                    }
                                }
                            };
                            t.setDaemon(true);
                            t.setPriority(3);
                            t.start();
                        }
                    }

                    static /* synthetic */ Server access$0(8 var0) {
                        return var0.Server.this;
                    }
                });
                this.stop(false);
            }
        }
        catch (Exception e) {
            Trace.trace(3, "Error restarting server", e);
        }
    }

    public IStatus canStop() {
        if (this.getServerType() == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorMissingAdapter, null);
        }
        if (this.getServerState() == 4) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorStopAlreadyStopped, null);
        }
        if (!this.getServerType().supportsLaunchMode(this.getMode())) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorLaunchMode, null);
        }
        return Status.OK_STATUS;
    }

    public void stop(boolean force) {
        if (this.getServerState() == 4) {
            return;
        }
        Trace.trace(5, "Stopping server: " + this.toString());
        try {
            this.getBehaviourDelegate(null).stop(force);
        }
        catch (Throwable t) {
            Trace.trace(3, "Error calling delegate stop() " + this.toString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(String mode2, IServer.IOperationListener listener2) {
        if (this.getServerType() == null) {
            return;
        }
        Trace.trace(5, "synchronousStart 1");
        final Object mutex = new Object();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ServerBehaviourDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.loadAdapter(clazz, null);
        IServerListener listener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                int state;
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if (eventKind == 17 && ((state = server.getServerState()) == 2 || state == 4)) {
                    Object object = mutex;
                    synchronized (object) {
                        try {
                            Trace.trace(5, "synchronousStart notify");
                            mutex.notifyAll();
                        }
                        catch (Exception e) {
                            Trace.trace(3, "Error notifying server start", e);
                        }
                    }
                }
            }
        };
        this.addServerListener(listener);
        class Timer {
            boolean timeout;
            boolean alreadyDone;
            final /* synthetic */ Server this$0;

            Timer(Server server) {
                this.this$0 = server;
            }
        }
        final Timer timer = new Timer(this);
        final int serverTimeout = ((ServerType)this.getServerType()).getStartTimeout();
        if (serverTimeout > 0) {
            Thread thread = new Thread("Server start timeout"){
                {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block6: {
                        try {
                            Thread.sleep(serverTimeout);
                            if (timer.alreadyDone) break block6;
                            Object object = mutex;
                            synchronized (object) {
                                Trace.trace(5, "start notify timeout");
                                if (!timer.alreadyDone) {
                                    timer.timeout = true;
                                }
                                mutex.notifyAll();
                            }
                        }
                        catch (Exception e) {
                            Trace.trace(3, "Error notifying server start timeout", e);
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        Trace.trace(5, "synchronousStart 2");
        NullProgressMonitor monitor = new NullProgressMonitor();
        try {
            this.start(mode2, (IProgressMonitor)monitor);
        }
        catch (CoreException e) {
            this.removeServerListener(listener);
            timer.alreadyDone = true;
            listener2.done(e.getStatus());
            return;
        }
        if (monitor.isCanceled()) {
            this.removeServerListener(listener);
            timer.alreadyDone = true;
            listener2.done(Status.CANCEL_STATUS);
            return;
        }
        Trace.trace(5, "synchronousStart 3");
        Object object = mutex;
        synchronized (object) {
            try {
                while (!timer.timeout && this.getServerState() != 2 && this.getServerState() != 4) {
                    mutex.wait();
                }
            }
            catch (Exception e) {
                Trace.trace(3, "Error waiting for server start", e);
            }
            timer.alreadyDone = true;
        }
        this.removeServerListener(listener);
        if (timer.timeout) {
            listener2.done((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorStartTimeout, (Object[])new String[]{this.getName(), String.valueOf(serverTimeout / 1000)}), null));
            this.stop(false);
            return;
        }
        if (this.getServerState() == 4) {
            listener2.done((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorStartFailed, (Object)this.getName()), null));
            return;
        }
        Trace.trace(5, "synchronousStart 4");
        listener2.done(Status.OK_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousStart(String mode2, IProgressMonitor monitor) throws CoreException {
        if (this.getServerType() == null) {
            return;
        }
        Trace.trace(5, "synchronousStart 1");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ServerBehaviourDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.loadAdapter(clazz, monitor);
        final boolean[] notified = new boolean[1];
        monitor = ProgressUtil.getMonitorFor(monitor);
        IServerListener listener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void serverChanged(ServerEvent event) {
                int state;
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if (eventKind != 17 || (state = server.getServerState()) != 2 && state != 4) return;
                boolean[] blArray = notified;
                synchronized (notified) {
                    try {
                        Trace.trace(5, "synchronousStart notify");
                        notified[0] = true;
                        notified.notifyAll();
                    }
                    catch (Exception e) {
                        Trace.trace(3, "Error notifying server start", e);
                    }
                    return;
                }
            }
        };
        this.addServerListener(listener);
        final int serverTimeout = ((ServerType)this.getServerType()).getStartTimeout();
        class Timer {
            boolean timeout;
            boolean alreadyDone;
            final /* synthetic */ Server this$0;

            Timer(Server server) {
                this.this$0 = server;
            }
        }
        final Timer timer = new Timer(this);
        final IProgressMonitor monitor2 = monitor;
        Thread thread = new Thread("Synchronous Server Start"){
            {
            }

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[MONITOR]], but top level block is 8[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        thread.setDaemon(true);
        thread.start();
        Trace.trace(5, "synchronousStart 2");
        try {
            this.start(mode2, monitor);
        }
        catch (CoreException e) {
            this.removeServerListener(listener);
            timer.alreadyDone = true;
            throw e;
        }
        if (monitor.isCanceled()) {
            this.removeServerListener(listener);
            timer.alreadyDone = true;
            return;
        }
        Trace.trace(5, "synchronousStart 3");
        boolean[] blArray = notified;
        synchronized (notified) {
            try {
                while (!(notified[0] || monitor.isCanceled() || timer.timeout || this.getServerState() == 2 || this.getServerState() == 4)) {
                    notified.wait();
                }
            }
            catch (Exception e) {
                Trace.trace(3, "Error waiting for server start", e);
            }
            timer.alreadyDone = true;
            // ** MonitorExit[var9_10] (shouldn't be in output)
            this.removeServerListener(listener);
            if (timer.timeout) {
                this.stop(false);
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorStartTimeout, (Object[])new String[]{this.getName(), String.valueOf(serverTimeout / 1000)}), null));
            }
            if (this.getServerState() == 4) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorStartFailed, (Object)this.getName()), null));
            }
            Trace.trace(5, "synchronousStart 4");
            return;
        }
    }

    public void synchronousRestart(String mode2, IProgressMonitor monitor) throws CoreException {
        this.synchronousStop(true);
        this.synchronousStart(mode2, monitor);
    }

    public void restart(String mode2, IServer.IOperationListener listener) {
        if (this.getServerType() == null) {
            return;
        }
        if (this.getServerState() == 4) {
            return;
        }
        Trace.trace(5, "Restarting server: " + this.getName());
        try {
            final IServer.IOperationListener listener2 = listener;
            IServerListener curListener = new IServerListener(){

                public void serverChanged(ServerEvent event) {
                    int eventKind = event.getKind();
                    IServer server = event.getServer();
                    if (eventKind == 17 && server.getServerState() == 2) {
                        server.removeServerListener(this);
                        listener2.done(Status.OK_STATUS);
                    }
                }
            };
            try {
                this.addServerListener(curListener);
                this.getBehaviourDelegate(null).restart(mode2);
                return;
            }
            catch (CoreException coreException) {
                Trace.trace(3, "Error calling delegate restart() " + this.toString());
                this.removeServerListener(curListener);
                final String mode3 = mode2;
                this.addServerListener(new IServerListener(){

                    public void serverChanged(ServerEvent event) {
                        int eventKind = event.getKind();
                        IServer server = event.getServer();
                        if (eventKind == 17 && server.getServerState() == 4) {
                            server.removeServerListener(this);
                            Thread t = new Thread(this, "Restart thread", mode3, listener2){
                                final /* synthetic */ 15 this$1;
                                private final /* synthetic */ String val$mode3;
                                private final /* synthetic */ IServer.IOperationListener val$listener2;
                                {
                                    this.this$1 = var1_1;
                                    this.val$mode3 = string;
                                    this.val$listener2 = iOperationListener;
                                }

                                public void run() {
                                    try {
                                        Thread.sleep(250L);
                                    }
                                    catch (Exception exception) {}
                                    ServerType st = (ServerType)15.access$0(this.this$1).getServerType();
                                    if (st.startBeforePublish()) {
                                        try {
                                            15.access$0(this.this$1).start(this.val$mode3, this.val$listener2);
                                        }
                                        catch (Exception e) {
                                            Trace.trace(3, "Error while restarting server", e);
                                        }
                                    }
                                    if (ServerPreferences.getInstance().isAutoPublishing() && 15.access$0(this.this$1).shouldPublish()) {
                                        15.access$0(this.this$1).publish(1, null);
                                    }
                                    if (15.access$0(this.this$1).getServerState() != 2) {
                                        try {
                                            15.access$0(this.this$1).start(this.val$mode3, this.val$listener2);
                                        }
                                        catch (Exception e) {
                                            Trace.trace(3, "Error while restarting server", e);
                                        }
                                    }
                                }
                            };
                            t.setDaemon(true);
                            t.setPriority(3);
                            t.start();
                        }
                    }

                    static /* synthetic */ Server access$0(15 var0) {
                        return var0.Server.this;
                    }
                });
                this.stop(false);
            }
        }
        catch (Exception e) {
            Trace.trace(3, "Error restarting server", e);
            listener.done(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(boolean force, IServer.IOperationListener listener2) {
        if (this.getServerType() == null) {
            return;
        }
        if (this.getServerState() == 4) {
            return;
        }
        final Object mutex = new Object();
        IServerListener listener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if (eventKind == 17) {
                    int state = server.getServerState();
                    if (Server.this == server && state == 4) {
                        Object object = mutex;
                        synchronized (object) {
                            try {
                                mutex.notifyAll();
                            }
                            catch (Exception e) {
                                Trace.trace(3, "Error notifying server stop", e);
                            }
                        }
                    }
                }
            }
        };
        this.addServerListener(listener);
        class Timer {
            boolean timeout;
            boolean alreadyDone;
            final /* synthetic */ Server this$0;

            Timer(Server server) {
                this.this$0 = server;
            }
        }
        final Timer timer = new Timer(this);
        final int serverTimeout = ((ServerType)this.getServerType()).getStopTimeout();
        if (serverTimeout > 0) {
            Thread thread = new Thread("Server stop timeout"){
                {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block5: {
                        try {
                            Thread.sleep(serverTimeout);
                            if (timer.alreadyDone) break block5;
                            timer.timeout = true;
                            Object object = mutex;
                            synchronized (object) {
                                Trace.trace(5, "stop notify timeout");
                                mutex.notifyAll();
                            }
                        }
                        catch (Exception e) {
                            Trace.trace(3, "Error notifying server stop timeout", e);
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        this.stop(force);
        Object object = mutex;
        synchronized (object) {
            try {
                while (!timer.timeout && this.getServerState() != 4) {
                    mutex.wait();
                }
            }
            catch (Exception e) {
                Trace.trace(3, "Error waiting for server stop", e);
            }
        }
        this.removeServerListener(listener);
        listener2.done(Status.OK_STATUS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronousStop(boolean force) {
        if (this.getServerType() == null) {
            return;
        }
        if (this.getServerState() == 4) {
            return;
        }
        final Object mutex = new Object();
        IServerListener listener = new IServerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void serverChanged(ServerEvent event) {
                int eventKind = event.getKind();
                IServer server = event.getServer();
                if (eventKind == 17) {
                    int state = server.getServerState();
                    if (Server.this == server && state == 4) {
                        Object object = mutex;
                        synchronized (object) {
                            try {
                                mutex.notifyAll();
                            }
                            catch (Exception e) {
                                Trace.trace(3, "Error notifying server stop", e);
                            }
                        }
                    }
                }
            }
        };
        this.addServerListener(listener);
        class Timer {
            boolean timeout;
            boolean alreadyDone;
            final /* synthetic */ Server this$0;

            Timer(Server server) {
                this.this$0 = server;
            }
        }
        final Timer timer = new Timer(this);
        final int serverTimeout = ((ServerType)this.getServerType()).getStopTimeout();
        if (serverTimeout > 0) {
            Thread thread = new Thread("Synchronous server stop"){
                {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    block5: {
                        try {
                            Thread.sleep(serverTimeout);
                            if (timer.alreadyDone) break block5;
                            timer.timeout = true;
                            Object object = mutex;
                            synchronized (object) {
                                Trace.trace(5, "stop notify timeout");
                                mutex.notifyAll();
                            }
                        }
                        catch (Exception e) {
                            Trace.trace(3, "Error notifying server stop timeout", e);
                        }
                    }
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
        this.stop(force);
        Object object = mutex;
        synchronized (object) {
            try {
                while (!timer.timeout && this.getServerState() != 4) {
                    mutex.wait();
                }
            }
            catch (Exception e) {
                Trace.trace(3, "Error waiting for server stop", e);
            }
        }
        this.removeServerListener(listener);
    }

    public IPath getTempDirectory() {
        return ServerPlugin.getInstance().getTempDirectory(this.getId());
    }

    protected String getXMLRoot() {
        return FILE_EXTENSION;
    }

    protected void loadState(IMemento memento) {
        this.resolve();
    }

    protected void resolve() {
        String runtimeId;
        IServerType oldServerType = this.serverType;
        String serverTypeId = this.getAttribute("server-type-id", (String)null);
        this.serverType = serverTypeId != null ? ServerCore.findServerType(serverTypeId) : null;
        if (this.serverType != null && !this.serverType.equals(oldServerType)) {
            this.serverState = ((ServerType)this.serverType).getInitialState();
        }
        if ((runtimeId = this.getAttribute(RUNTIME_ID, (String)null)) != null) {
            this.runtime = ServerCore.findRuntime(runtimeId);
        }
        String configPath = this.getAttribute(CONFIGURATION_ID, (String)null);
        this.configuration = null;
        if (configPath != null) {
            this.configuration = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(configPath));
        }
    }

    protected void setInternal(ServerWorkingCopy wc) {
        this.map = new HashMap(wc.map);
        this.configuration = wc.configuration;
        this.runtime = wc.runtime;
        this.serverSyncState = wc.serverSyncState;
        this.serverType = wc.serverType;
        this.modules = wc.modules;
        this.delegate = wc.delegate;
        if (this.getServerState() == 2) {
            this.autoPublish();
        }
    }

    protected void saveState(IMemento memento) {
        if (this.serverType != null) {
            memento.putString("server-type", this.serverType.getId());
        }
        if (this.configuration != null) {
            memento.putString(CONFIGURATION_ID, this.configuration.getFullPath().toString());
        } else {
            memento.putString(CONFIGURATION_ID, null);
        }
        if (this.runtime != null) {
            memento.putString(RUNTIME_ID, this.runtime.getId());
        } else {
            memento.putString(RUNTIME_ID, null);
        }
    }

    public IStatus canModifyModules(IModule[] add, IModule[] remove, IProgressMonitor monitor) {
        int i;
        int size;
        if (!(add != null && add.length != 0 || remove != null && remove.length != 0)) {
            throw new IllegalArgumentException("Add and remove cannot both be null/empty");
        }
        if (add != null) {
            size = add.length;
            i = 0;
            while (i < size) {
                if (add[i] == null) {
                    throw new IllegalArgumentException("Cannot add null entries");
                }
                ++i;
            }
        }
        if (remove != null) {
            size = remove.length;
            i = 0;
            while (i < size) {
                if (remove[i] == null) {
                    throw new IllegalArgumentException("Cannot remove null entries");
                }
                ++i;
            }
        }
        if (this.getServerType() == null) {
            return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorMissingAdapter, null);
        }
        if (add != null && add.length > 0) {
            size = add.length;
            i = 0;
            while (i < size) {
                IModuleType moduleType = add[i].getModuleType();
                if (!ServerUtil.isSupportedModule(this.getServerType().getRuntimeType().getModuleTypes(), moduleType)) {
                    return new Status(4, "org.eclipse.wst.server.core", 0, NLS.bind((String)Messages.errorCannotAddModule, (Object[])new Object[]{moduleType.getName(), moduleType.getVersion()}), null);
                }
                ++i;
            }
        }
        try {
            return this.getDelegate(monitor).canModifyModules(add, remove);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate canModifyModules() " + this.toString(), e);
            return new Status(4, "org.eclipse.wst.server.core", 0, e.getMessage(), null);
        }
    }

    public IModule[] getModules() {
        IModule[] modules2;
        List em;
        if (this.modules == null) {
            ArrayList list = this.getAttribute(MODULE_LIST, (List)null);
            if (list == null) {
                list = new ArrayList(1);
            }
            this.modules = new ArrayList(list.size() + 1);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                IModule module;
                String moduleId = (String)iterator.next();
                String name = "<unknown>";
                int index = moduleId.indexOf("::");
                if (index > 0) {
                    name = moduleId.substring(0, index);
                    moduleId = moduleId.substring(index + 2);
                }
                String moduleTypeId = null;
                String moduleTypeVersion = null;
                index = moduleId.indexOf("::");
                if (index > 0) {
                    int index2 = moduleId.indexOf("::", index + 1);
                    moduleTypeId = moduleId.substring(index + 2, index2);
                    moduleTypeVersion = moduleId.substring(index2 + 2);
                    moduleId = moduleId.substring(0, index);
                }
                if ((module = ServerUtil.getModule(moduleId)) == null) {
                    ModuleType moduleType = null;
                    if (moduleTypeId != null) {
                        moduleType = ModuleType.getModuleType(moduleTypeId, moduleTypeVersion);
                    }
                    module = new DeletedModule(moduleId, name, moduleType);
                }
                this.modules.add(module);
            }
        }
        if ((em = this.getExternalModules()) == null || em.isEmpty()) {
            modules2 = new IModule[this.modules.size()];
            this.modules.toArray(modules2);
            return modules2;
        }
        modules2 = new IModule[this.modules.size() + em.size()];
        this.modules.toArray(modules2);
        Object[] obj = em.toArray();
        System.arraycopy(obj, 0, modules2, this.modules.size(), em.size());
        return modules2;
    }

    public int getModuleState(IModule[] module) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        try {
            Integer in = (Integer)this.moduleState.get(this.getKey(module));
            if (in != null) {
                return in;
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public int getModulePublishState(IModule[] module) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        try {
            Integer in = (Integer)this.modulePublishState.get(this.getKey(module));
            if (in != null) {
                return in;
            }
        }
        catch (Exception exception) {}
        return 0;
    }

    public IModule[] getChildModules(IModule[] module, IProgressMonitor monitor) {
        IModule[] children;
        block8: {
            ServerDelegate sd;
            block7: {
                block6: {
                    if (module == null || module.length == 0) {
                        throw new IllegalArgumentException("Module cannot be null or empty");
                    }
                    try {
                        int i = module.length - 1;
                        if (module[i].getProject() != null && module[i].getProject().isAccessible()) break block6;
                        return null;
                    }
                    catch (Exception e) {
                        Trace.trace(3, "Error calling delegate getChildModules() " + this.toString(), e);
                        return null;
                    }
                }
                sd = this.getDelegate(monitor);
                if (sd != null) break block7;
                return null;
            }
            children = sd.getChildModules(module);
            if (children == null || children.length != 1 || !children[0].equals(module[module.length - 1])) break block8;
            return null;
        }
        return children;
    }

    public IModule[] getRootModules(IModule module, IProgressMonitor monitor) throws CoreException {
        if (module == null) {
            throw new IllegalArgumentException("Module cannot be null");
        }
        try {
            return this.getDelegate(monitor).getRootModules(module);
        }
        catch (CoreException se) {
            throw se;
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate getParentModules() " + this.toString(), e);
            return null;
        }
    }

    public IStatus canControlModule(IModule[] module, IProgressMonitor monitor) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        try {
            ServerBehaviourDelegate bd = this.getBehaviourDelegate(monitor);
            if (bd == null) {
                return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorRestartModule, null);
            }
            boolean b = bd.canControlModule(module);
            if (b) {
                return Status.OK_STATUS;
            }
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate canRestartRuntime() " + this.toString(), e);
        }
        return new Status(4, "org.eclipse.wst.server.core", 0, Messages.errorRestartModule, null);
    }

    public boolean getModuleRestartState(IModule[] module) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        try {
            Boolean b = (Boolean)this.moduleRestartState.get(this.getKey(module));
            if (b != null) {
                return b;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public void startModule(IModule[] module, IServer.IOperationListener listener) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty or empty");
        }
        try {
            this.getBehaviourDelegate(null).startModule(module, null);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate restartModule() " + this.toString(), e);
        }
    }

    public void stopModule(IModule[] module, IServer.IOperationListener listener) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty or empty");
        }
        try {
            this.getBehaviourDelegate(null).stopModule(module, null);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate restartModule() " + this.toString(), e);
        }
    }

    public void restartModule(IModule[] module, IServer.IOperationListener listener) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        try {
            this.getBehaviourDelegate(null).restartModule(module, null);
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate restartModule() " + this.toString(), e);
        }
    }

    public ServerPort[] getServerPorts(IProgressMonitor monitor) {
        try {
            return this.getDelegate(monitor).getServerPorts();
        }
        catch (Exception e) {
            Trace.trace(3, "Error calling delegate getServerPorts() " + this.toString(), e);
            return null;
        }
    }

    public void visit(IModuleVisitor visitor, IProgressMonitor monitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Visitor cannot be null");
        }
        IModule[] modules2 = this.getModules();
        if (modules2 != null) {
            int size = modules2.length;
            int i = 0;
            while (i < size) {
                if (!this.visitModule(new IModule[]{modules2[i]}, visitor, monitor)) {
                    return;
                }
                ++i;
            }
        }
    }

    private boolean visitModule(IModule[] module, IModuleVisitor visitor, IProgressMonitor monitor) {
        if (module == null) {
            return true;
        }
        if (!visitor.visit(module)) {
            return false;
        }
        IModule[] children = this.getChildModules(module, monitor);
        if (children != null) {
            int size = children.length;
            int i = 0;
            while (i < size) {
                IModule[] module2 = new IModule[module.length + 1];
                System.arraycopy(module, 0, module2, 0, module.length);
                module2[module.length] = children[i];
                if (!this.visitModule(module2, visitor, monitor)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    protected String getKey(IModule[] module) {
        StringBuffer sb = new StringBuffer();
        if (module != null) {
            int size = module.length;
            int i = 0;
            while (i < size) {
                if (i != 0) {
                    sb.append("#");
                }
                sb.append(module[i].getId());
                ++i;
            }
        }
        return sb.toString();
    }

    public void setModuleStatus(IModule[] module, IStatus status) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        this.moduleStatus.put(this.getKey(module), status);
    }

    public IStatus getModuleStatus(IModule[] module) {
        if (module == null || module.length == 0) {
            throw new IllegalArgumentException("Module cannot be null or empty");
        }
        try {
            return (IStatus)this.moduleStatus.get(this.getKey(module));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setServerStatus(IStatus status) {
        this.serverStatus = status;
    }

    public IStatus getServerStatus() {
        return this.serverStatus;
    }

    public static void switchLocation(Server server, IProgressMonitor monitor) throws CoreException {
        IFile file = server.getFile();
        ServerWorkingCopy wc = (ServerWorkingCopy)server.createWorkingCopy();
        server.delete();
        if (file == null) {
            IProject project = ServerType.getServerProject();
            file = ServerUtil.getUnusedServerFile(project, wc);
            wc.setFile(file);
            server.file = file;
        } else {
            wc.setFile(null);
            server.file = null;
        }
        wc.save(true, monitor);
    }

    public int getServerState(IProgressMonitor monitor) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.server.core.model.ServerBehaviourDelegate");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.loadAdapter(clazz, monitor);
        return this.getServerState();
    }

    public class AutoPublishThread
    extends Thread {
        public boolean stop;
        public int time = 0;

        public AutoPublishThread() {
            super("Automatic Publishing");
        }

        public void run() {
            Trace.trace(5, "Auto-publish thread starting for " + Server.this + " - " + this.time + "s");
            if (this.stop) {
                return;
            }
            try {
                AutoPublishThread.sleep(this.time * 1000);
            }
            catch (Exception exception) {}
            if (this.stop) {
                return;
            }
            Trace.trace(5, "Auto-publish thread publishing " + Server.this);
            if (Server.this.getServerState() != 2) {
                return;
            }
            PublishServerJob publishJob = new PublishServerJob(Server.this, 3, false);
            publishJob.schedule();
        }
    }

    public class ResourceChangeJob
    extends ChainedJob {
        private IModule module;

        public ResourceChangeJob(IModule module, IServer server2) {
            super(NLS.bind((String)Messages.jobUpdateServer, (Object)server2.getName()), server2);
            this.module = module;
            if (module.getProject() == null) {
                this.setRule(new ServerSchedulingRule(server2));
            } else {
                ISchedulingRule[] rules = new ISchedulingRule[2];
                IResourceRuleFactory ruleFactory = ResourcesPlugin.getWorkspace().getRuleFactory();
                rules[0] = ruleFactory.createRule((IResource)module.getProject());
                rules[1] = new ServerSchedulingRule(server2);
                this.setRule(MultiRule.combine((ISchedulingRule[])rules));
            }
        }

        protected IModule getModule() {
            return this.module;
        }

        protected IStatus run(IProgressMonitor monitor) {
            boolean[] changed = new boolean[1];
            ArrayList modules2 = new ArrayList();
            IModuleVisitor visitor = new IModuleVisitor(this, modules2, changed){
                final /* synthetic */ ResourceChangeJob this$1;
                private final /* synthetic */ List val$modules2;
                private final /* synthetic */ boolean[] val$changed;
                {
                    this.this$1 = resourceChangeJob;
                    this.val$modules2 = list;
                    this.val$changed = blArray;
                }

                public boolean visit(IModule[] module2) {
                    this.val$modules2.add(module2);
                    int size = module2.length;
                    IModule m = module2[size - 1];
                    if (m.getProject() == null) {
                        return true;
                    }
                    if (this.this$1.getModule().equals(m) && ResourceChangeJob.access$0(this.this$1).hasPublishedResourceDelta(module2)) {
                        this.val$changed[0] = true;
                        ResourceChangeJob.access$0(this.this$1).setModulePublishState(module2, 2);
                    }
                    return true;
                }
            };
            Server.this.visit(visitor, null);
            if (Server.this.getServerPublishInfo().hasStructureChanged(modules2)) {
                Server.this.setServerPublishState(2);
            }
            if (!changed[0]) {
                return Status.OK_STATUS;
            }
            if (Server.this.getServerState() != 4 && Server.this.behaviourDelegate != null) {
                Server.this.behaviourDelegate.handleResourceChange();
            }
            if (Server.this.getServerState() == 2) {
                Server.this.autoPublish();
            }
            return Status.OK_STATUS;
        }

        static /* synthetic */ Server access$0(ResourceChangeJob resourceChangeJob) {
            return resourceChangeJob.Server.this;
        }
    }
}

