/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.frameworks.datamodel.tests.extended;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.A;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.B;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.C;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.D;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.E;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.F;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.G;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.H;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.R;
import org.eclipse.wst.common.frameworks.datamodel.tests.extended.RootDMProvider;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperation;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperationEvent;
import org.eclipse.wst.common.frameworks.internal.datamodel.IDataModelPausibleOperationListener;

public class ExtendedOperationTests
extends TestCase {
    public static List executionList = new ArrayList();
    public static final String a = A.class.getName();
    public static final String b = B.class.getName();
    public static final String c = C.class.getName();
    public static final String d = D.class.getName();
    public static final String e = E.class.getName();
    public static final String f = F.class.getName();
    public static final String g = G.class.getName();
    public static final String h = H.class.getName();
    public static final String r = R.class.getName();
    protected PauseListener pauseListener = new PauseListener();

    protected void setUp() throws Exception {
        super.setUp();
        executionList.clear();
        this.pauseListener.pausedOperations.clear();
        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject("foo");
        if (!p.exists()) {
            p.create(null);
        }
    }

    public void testAllOn() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RootDMProvider());
        String[] forwardExpectedResults = new String[]{c, a, d, r, e, b, f, g, h};
        String[] forwardExpectedPauseOrder = new String[]{r, a, c, d, b, e, f, h, g};
        this.checkAll(dm, forwardExpectedResults, forwardExpectedPauseOrder);
    }

    public void testAllOff() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RootDMProvider());
        dm.setBooleanProperty("IDataModelProperties.ALLOW_EXTENSIONS", false);
        String[] forwardExpectedResults = new String[]{r};
        String[] forwardExpectedPauseOrder = new String[]{r};
        this.checkAll(dm, forwardExpectedResults, forwardExpectedPauseOrder);
    }

    public void testAOff() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RootDMProvider());
        ArrayList<String> restrictedList = new ArrayList<String>();
        restrictedList.add(a);
        dm.setProperty("IDataModelProperties.RESTRICT_EXTENSIONS", restrictedList);
        String[] forwardExpectedResults = new String[]{r, e, b, f, g, h};
        String[] forwardExpectedPauseOrder = new String[]{r, b, e, f, h, g};
        this.checkAll(dm, forwardExpectedResults, forwardExpectedPauseOrder);
    }

    public void testBOff() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RootDMProvider());
        ArrayList<String> restrictedList = new ArrayList<String>();
        restrictedList.add(b);
        dm.setProperty("IDataModelProperties.RESTRICT_EXTENSIONS", restrictedList);
        String[] forwardExpectedResults = new String[]{c, a, d, r};
        String[] forwardExpectedPauseOrder = new String[]{r, a, c, d};
        this.checkAll(dm, forwardExpectedResults, forwardExpectedPauseOrder);
    }

    public void testCOff() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RootDMProvider());
        ArrayList<String> restrictedList = new ArrayList<String>();
        restrictedList.add(c);
        dm.setProperty("IDataModelProperties.RESTRICT_EXTENSIONS", restrictedList);
        String[] forwardExpectedResults = new String[]{a, d, r, e, b, f, g, h};
        String[] forwardExpectedPauseOrder = new String[]{r, a, d, b, e, f, h, g};
        this.checkAll(dm, forwardExpectedResults, forwardExpectedPauseOrder);
    }

    public void testCFOff() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RootDMProvider());
        ArrayList<String> restrictedList = new ArrayList<String>();
        restrictedList.add(c);
        restrictedList.add(f);
        dm.setProperty("IDataModelProperties.RESTRICT_EXTENSIONS", restrictedList);
        String[] forwardExpectedResults = new String[]{a, d, r, e, b};
        String[] forwardExpectedPauseOrder = new String[]{r, a, d, b, e};
        this.checkAll(dm, forwardExpectedResults, forwardExpectedPauseOrder);
    }

    public void testCBOff() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RootDMProvider());
        ArrayList<String> restrictedList = new ArrayList<String>();
        restrictedList.add(c);
        restrictedList.add(b);
        dm.setProperty("IDataModelProperties.RESTRICT_EXTENSIONS", restrictedList);
        String[] forwardExpectedResults = new String[]{a, d, r};
        String[] forwardExpectedPauseOrder = new String[]{r, a, d};
        this.checkAll(dm, forwardExpectedResults, forwardExpectedPauseOrder);
    }

    public void testAEFOff() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RootDMProvider());
        ArrayList<String> restrictedList = new ArrayList<String>();
        restrictedList.add(a);
        restrictedList.add(e);
        restrictedList.add(f);
        dm.setProperty("IDataModelProperties.RESTRICT_EXTENSIONS", restrictedList);
        String[] forwardExpectedResults = new String[]{r, b};
        String[] forwardExpectedPauseOrder = new String[]{r, b};
        this.checkAll(dm, forwardExpectedResults, forwardExpectedPauseOrder);
    }

    public void testABOff() throws Exception {
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)new RootDMProvider());
        ArrayList<String> restrictedList = new ArrayList<String>();
        restrictedList.add(a);
        restrictedList.add(b);
        dm.setProperty("IDataModelProperties.RESTRICT_EXTENSIONS", restrictedList);
        String[] forwardExpectedResults = new String[]{r};
        String[] forwardExpectedPauseOrder = new String[]{r};
        this.checkAll(dm, forwardExpectedResults, forwardExpectedPauseOrder);
    }

    private void checkAll(IDataModel dm, String[] forwardExpectedResults, String[] expectedPauseOrder) throws Exception {
        String[] undoExpectedResults = this.reverseString(forwardExpectedResults);
        boolean shouldRollBack = false;
        IDataModelPausibleOperation op = (IDataModelPausibleOperation)dm.getDefaultOperation();
        this.checkExecution(op, forwardExpectedResults, null, shouldRollBack);
        this.checkUndo(op, undoExpectedResults, null);
        this.checkRedo(op, forwardExpectedResults, null);
        this.checkUndo(op, undoExpectedResults, null);
        op = (IDataModelPausibleOperation)dm.getDefaultOperation();
        op.addOperationListener((IDataModelPausibleOperationListener)this.pauseListener);
        this.checkExecution(op, forwardExpectedResults, expectedPauseOrder, shouldRollBack);
        this.checkUndo(op, undoExpectedResults, undoExpectedResults);
        this.checkRedo(op, forwardExpectedResults, forwardExpectedResults);
        this.checkUndo(op, undoExpectedResults, undoExpectedResults);
        op = (IDataModelPausibleOperation)dm.getDefaultOperation();
        op.addOperationListener((IDataModelPausibleOperationListener)this.pauseListener);
        shouldRollBack = true;
        this.checkExecution(op, forwardExpectedResults, expectedPauseOrder, shouldRollBack);
        this.checkUndo(op, undoExpectedResults, undoExpectedResults);
        this.checkRedo(op, forwardExpectedResults, forwardExpectedResults);
        this.checkUndo(op, undoExpectedResults, undoExpectedResults);
    }

    private String[] reverseString(String[] forwardString) {
        String[] reverseString = new String[forwardString.length];
        int i = 0;
        while (i < reverseString.length) {
            reverseString[i] = forwardString[forwardString.length - i - 1];
            ++i;
        }
        return reverseString;
    }

    private void checkExecution(IDataModelPausibleOperation op, String[] expectedResults, String[] expectedPauseOrder, boolean rollback) throws Exception {
        ExtendedOperationTests.assertEquals((int)0, (int)op.getExecutionState());
        op.execute(null, null);
        if (expectedPauseOrder != null) {
            if (rollback) {
                ArrayList cachedExecutionList = new ArrayList();
                int i = 0;
                while (i < expectedResults.length) {
                    cachedExecutionList.clear();
                    cachedExecutionList.addAll(executionList);
                    ExtendedOperationTests.assertEquals((int)5, (int)op.getExecutionState());
                    op.rollBack(null, null);
                    ExtendedOperationTests.assertEquals((int)10, (int)op.getExecutionState());
                    this.checkRollBackResults(cachedExecutionList, expectedResults);
                    op.resume(null, null);
                    ++i;
                }
                ExtendedOperationTests.assertEquals((int)9, (int)op.getExecutionState());
                this.checkResults(expectedResults, expectedPauseOrder);
                this.pauseListener.pausedOperations.clear();
                executionList.clear();
                op.execute(null, null);
            }
            int i = 0;
            while (i < expectedResults.length) {
                ExtendedOperationTests.assertEquals((int)5, (int)op.getExecutionState());
                op.resume(null, null);
                ++i;
            }
        }
        ExtendedOperationTests.assertEquals((int)9, (int)op.getExecutionState());
        this.checkResults(expectedResults, expectedPauseOrder);
        executionList.clear();
        this.pauseListener.pausedOperations.clear();
    }

    private void checkUndo(IDataModelPausibleOperation op, String[] expectedResults, String[] expectedPauseOrder) throws Exception {
        if (op.getExecutionState() != 9 && op.getExecutionState() != 12) {
            ExtendedOperationTests.fail((String)("Operation execution state invalid " + op.getExecutionState()));
        }
        op.undo(null, null);
        if (expectedPauseOrder != null) {
            int i = 0;
            while (i < expectedResults.length) {
                ExtendedOperationTests.assertEquals((int)7, (int)op.getExecutionState());
                op.resume(null, null);
                ++i;
            }
        }
        ExtendedOperationTests.assertEquals((int)11, (int)op.getExecutionState());
        this.checkResults(expectedResults, expectedPauseOrder);
        executionList.clear();
        this.pauseListener.pausedOperations.clear();
    }

    private void checkRedo(IDataModelPausibleOperation op, String[] expectedResults, String[] expectedPauseOrder) throws Exception {
        ExtendedOperationTests.assertEquals((int)11, (int)op.getExecutionState());
        op.redo(null, null);
        if (expectedPauseOrder != null) {
            int i = 0;
            while (i < expectedResults.length) {
                ExtendedOperationTests.assertEquals((int)8, (int)op.getExecutionState());
                op.resume(null, null);
                ++i;
            }
        }
        ExtendedOperationTests.assertEquals((int)12, (int)op.getExecutionState());
        this.checkResults(expectedResults, expectedPauseOrder);
        executionList.clear();
        this.pauseListener.pausedOperations.clear();
    }

    private void checkRollBackResults(List cachedExecutionList, String[] expectedResults) {
        ExtendedOperationTests.assertEquals((int)(cachedExecutionList.size() * 2), (int)executionList.size());
        int i = 0;
        while (i < cachedExecutionList.size()) {
            ExtendedOperationTests.assertEquals((String)expectedResults[i], (String)((String)executionList.get(i)));
            ExtendedOperationTests.assertEquals((String)((String)cachedExecutionList.get(i)), (String)((String)executionList.get(executionList.size() - 1 - i)));
            ++i;
        }
        executionList.clear();
    }

    private void checkResults(String[] expectedResults, String[] expectedPauseOrder) {
        ExtendedOperationTests.assertEquals((int)expectedResults.length, (int)executionList.size());
        int i = 0;
        while (i < expectedResults.length) {
            ExtendedOperationTests.assertEquals((String)expectedResults[i], (String)((String)executionList.get(i)));
            ++i;
        }
        if (expectedPauseOrder == null) {
            ExtendedOperationTests.assertEquals((int)0, (int)this.pauseListener.pausedOperations.size());
        } else {
            ExtendedOperationTests.assertEquals((int)expectedPauseOrder.length, (int)this.pauseListener.pausedOperations.size());
            i = 0;
            while (i < expectedPauseOrder.length) {
                ExtendedOperationTests.assertEquals((String)expectedPauseOrder[i], (String)((String)this.pauseListener.pausedOperations.get(i)));
                ++i;
            }
        }
    }

    protected class PauseListener
    implements IDataModelPausibleOperationListener {
        public List pausedOperations = new ArrayList();

        protected PauseListener() {
        }

        public int notify(IDataModelPausibleOperationEvent event) {
            String opID = event.getOperation().getID();
            if (this.pausedOperations.contains(opID)) {
                return 0;
            }
            this.pausedOperations.add(opID);
            return 1;
        }
    }
}

