/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jee.archive.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jst.jee.archive.IArchive;
import org.eclipse.jst.jee.archive.IArchiveLoadAdapter;
import org.eclipse.jst.jee.archive.IArchiveResource;
import org.eclipse.jst.jee.archive.internal.ArchiveImpl;

public class ArchiveResourceImpl
implements IArchiveResource {
    private IArchive archive = null;
    private int type = -1;
    private long size = -1L;
    private long lastModified = -1L;
    private IPath path = null;

    public IArchive getArchive() {
        return this.archive;
    }

    public int getType() {
        return this.type;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public IPath getPath() {
        return this.path;
    }

    public long getSize() {
        return this.size;
    }

    public void setArchive(IArchive archive) {
        this.archive = archive;
        ((ArchiveImpl)archive).addArchiveResourceInternal(this);
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public InputStream getInputStream() throws FileNotFoundException, IOException {
        switch (this.getType()) {
            case -1: 
            case 1: {
                return null;
            }
            case 0: 
            case 2: {
                IArchiveLoadAdapter loadAdapter = null;
                loadAdapter = this.getArchive().getLoadAdapter();
                return loadAdapter.getInputStream(this);
            }
        }
        return null;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        switch (this.getType()) {
            case 0: {
                buffer.append("File: ");
                break;
            }
            case 1: {
                buffer.append("Directory: ");
                break;
            }
            case 2: {
                buffer.append("Archive: ");
                break;
            }
            case -1: {
                buffer.append("Unknown: ");
            }
        }
        buffer.append(this.getPath());
        return buffer.toString();
    }
}

