/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.plugin;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualArchiveComponent;

public class BinaryEditorUtilities {
    public static IEditorInput getBinaryEditorInput(VirtualArchiveComponent component, String archiveRelativePath) {
        IEditorInput input = null;
        IPath archivePath = component.getWorkspaceRelativePath();
        if (archivePath != null) {
            input = BinaryEditorUtilities.getBinaryEditorInput(archivePath, archiveRelativePath);
        } else {
            String archiveOSPath = component.getUnderlyingDiskFile().getPath();
            input = BinaryEditorUtilities.getBinaryEditorInput(archiveOSPath, archiveRelativePath);
        }
        return input;
    }

    public static IEditorInput getBinaryEditorInput(IPath archivePath, String archiveRelativePath) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IResource resource = root.findMember(archivePath);
        if (resource == null) {
            return null;
        }
        String archiveOSPath = resource.getLocation().toOSString();
        IEditorInput editorInput = BinaryEditorUtilities.getBinaryEditorInput(archiveOSPath, archiveRelativePath);
        return editorInput;
    }

    public static IEditorInput getBinaryEditorInput(String archiveOSPath, String archiveRelativePath) {
        JarEntryFile jarFile = new JarEntryFile(archiveRelativePath, archiveOSPath);
        JarEntryEditorInput editorInput = new JarEntryEditorInput(jarFile);
        return editorInput;
    }

    private static class JarEntryEditorInput
    implements IStorageEditorInput {
        private IStorage fJarEntryFile;

        public JarEntryEditorInput(IStorage jarEntryFile) {
            this.fJarEntryFile = jarEntryFile;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof JarEntryEditorInput)) {
                return false;
            }
            JarEntryEditorInput other = (JarEntryEditorInput)obj;
            return this.fJarEntryFile.equals(other.fJarEntryFile);
        }

        public IPersistableElement getPersistable() {
            return null;
        }

        public String getName() {
            return this.fJarEntryFile.getName();
        }

        public String getFullPath() {
            return this.fJarEntryFile.getFullPath().toString();
        }

        public String getContentType() {
            return this.fJarEntryFile.getFullPath().getFileExtension();
        }

        public String getToolTipText() {
            return this.fJarEntryFile.getFullPath().toString();
        }

        public ImageDescriptor getImageDescriptor() {
            IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
            return registry.getImageDescriptor(this.fJarEntryFile.getFullPath().getFileExtension());
        }

        public boolean exists() {
            return true;
        }

        public Object getAdapter(Class adapter) {
            return null;
        }

        public IStorage getStorage() {
            return this.fJarEntryFile;
        }
    }

    private static class JarEntryFile
    extends PlatformObject
    implements IStorage {
        private String entryName;
        private String zipName;
        private IPath path;

        public JarEntryFile(String entryName, String zipName) {
            this.entryName = entryName;
            this.zipName = zipName;
            this.path = new Path(this.entryName);
        }

        public InputStream getContents() throws CoreException {
            try {
                ZipFile zipFile;
                ZipEntry zipEntry;
                if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                    System.out.println("(" + Thread.currentThread() + ") [JarEntryFile.getContents()] Creating ZipFile on " + this.zipName);
                }
                if ((zipEntry = (zipFile = new ZipFile(this.zipName)).getEntry(this.entryName)) == null) {
                    throw new JavaModelException((IJavaModelStatus)new JavaModelStatus(979, this.entryName));
                }
                return zipFile.getInputStream(zipEntry);
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 985);
            }
        }

        public IPath getFullPath() {
            return this.path;
        }

        public String getName() {
            return this.path.lastSegment();
        }

        public boolean isReadOnly() {
            return true;
        }

        public String toString() {
            return "JarEntryFile[" + this.zipName + "::" + this.entryName + "]";
        }
    }
}

