/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.common;

import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;

public class J2EEVersionUtil {
    public static String getServletTextVersion(int aVersion) {
        switch (aVersion) {
            case 22: {
                return "2.2";
            }
            case 23: {
                return "2.3";
            }
            case 24: {
                return "2.4";
            }
            case 25: {
                return "2.5";
            }
        }
        return "";
    }

    public static String getEJBTextVersion(int aVersion) {
        switch (aVersion) {
            case 10: {
                return "1.0";
            }
            case 11: {
                return "1.1";
            }
            case 20: {
                return "2.0";
            }
            case 21: {
                return "2.1";
            }
            case 30: {
                return "3.0";
            }
        }
        return "";
    }

    public static String getJCATextVersion(int aVersion) {
        switch (aVersion) {
            case 10: {
                return "1.0";
            }
            case 15: {
                return "1.5";
            }
        }
        return "";
    }

    public static String getJ2EETextVersion(int aVersion) {
        switch (aVersion) {
            case 12: {
                return "1.2";
            }
            case 13: {
                return "1.3";
            }
            case 14: {
                return "1.4";
            }
            case 50: {
                return "5.0";
            }
        }
        return "";
    }

    public static int convertAppClientVersionStringToJ2EEVersionID(String version) {
        if (version.equals("1.2")) {
            return 12;
        }
        if (version.equals("1.3")) {
            return 13;
        }
        if (version.equals("1.4")) {
            return 14;
        }
        if (version.equals("5.0")) {
            return 50;
        }
        return 50;
    }

    public static int convertEJBVersionStringToJ2EEVersionID(String version) {
        if (version.equals("1.1")) {
            return 12;
        }
        if (version.equals("2.0")) {
            return 13;
        }
        if (version.equals("2.1")) {
            return 14;
        }
        if (version.equals("3.0")) {
            return 50;
        }
        return 50;
    }

    public static int convertWebVersionStringToJ2EEVersionID(String version) {
        if (version.equals("2.2")) {
            return 12;
        }
        if (version.equals("2.3")) {
            return 13;
        }
        if (version.equals("2.4")) {
            return 14;
        }
        if (version.equals("2.5")) {
            return 50;
        }
        return 14;
    }

    public static int convertConnectorVersionStringToJ2EEVersionID(String version) {
        if (version.equals("1.0")) {
            return 13;
        }
        if (version.equals("1.5")) {
            return 14;
        }
        return 14;
    }

    public static int convertJ2EEVersionIDToEJBVersionID(int j2eeVersionId) {
        switch (j2eeVersionId) {
            case 12: {
                return 11;
            }
            case 13: {
                return 20;
            }
            case 14: {
                return 21;
            }
            case 50: {
                return 30;
            }
        }
        return 30;
    }

    public static int convertJ2EEVersionIDToWebVersionID(int j2eeVersionId) {
        switch (j2eeVersionId) {
            case 12: {
                return 22;
            }
            case 13: {
                return 23;
            }
            case 14: {
                return 24;
            }
            case 50: {
                return 25;
            }
        }
        return 25;
    }

    public static int convertJ2EEVersionIDToConnectorVersionID(int j2eeVersionId) {
        switch (j2eeVersionId) {
            case 13: {
                return 10;
            }
            case 14: {
                return 15;
            }
        }
        return 15;
    }

    public static int convertVersionStringToInt(IVirtualComponent comp) {
        String version = J2EEProjectUtilities.getJ2EEProjectVersion(comp.getProject());
        if (J2EEProjectUtilities.isDynamicWebProject(comp.getProject())) {
            return J2EEVersionUtil.convertWebVersionStringToJ2EEVersionID(version);
        }
        if (J2EEProjectUtilities.isEJBProject(comp.getProject())) {
            return J2EEVersionUtil.convertEJBVersionStringToJ2EEVersionID(version);
        }
        if (J2EEProjectUtilities.isEARProject(comp.getProject())) {
            return J2EEVersionUtil.convertVersionStringToInt(version);
        }
        if (J2EEProjectUtilities.isJCAProject(comp.getProject())) {
            return J2EEVersionUtil.convertConnectorVersionStringToJ2EEVersionID(version);
        }
        if (J2EEProjectUtilities.isApplicationClientProject(comp.getProject())) {
            return J2EEVersionUtil.convertAppClientVersionStringToJ2EEVersionID(version);
        }
        return 0;
    }

    public static int convertVersionStringToInt(String version) {
        int nVersion = 0;
        if (version.endsWith("")) {
            nVersion = 0;
        }
        if (version.equals("1.0")) {
            nVersion = 10;
        } else if (version.equals("1.1")) {
            nVersion = 11;
        } else if (version.equals("1.2")) {
            nVersion = 12;
        } else if (version.equals("1.3")) {
            nVersion = 13;
        } else if (version.equals("1.4")) {
            nVersion = 14;
        } else if (version.equals("1.5")) {
            nVersion = 15;
        } else if (version.equals("2.0")) {
            nVersion = 20;
        } else if (version.equals("2.1")) {
            nVersion = 21;
        } else if (version.equals("2.2")) {
            nVersion = 22;
        } else if (version.equals("2.3")) {
            nVersion = 23;
        } else if (version.equals("2.4")) {
            nVersion = 24;
        } else if (version.equals("2.5")) {
            nVersion = 25;
        } else if (version.equals("5.0")) {
            nVersion = 50;
        } else if (version.equals("3.0")) {
            nVersion = 30;
        }
        return nVersion;
    }

    public static String convertVersionIntToString(int version) {
        String nVersion = null;
        if (version == 10) {
            nVersion = "1.0";
        } else if (version == 11) {
            nVersion = "1.1";
        } else if (version == 12) {
            nVersion = "1.2";
        } else if (version == 13) {
            nVersion = "1.3";
        } else if (version == 14) {
            nVersion = "1.4";
        } else if (version == 15) {
            nVersion = "1.5";
        } else if (version == 20) {
            nVersion = "2.0";
        } else if (version == 21) {
            nVersion = "2.1";
        } else if (version == 22) {
            nVersion = "2.2";
        } else if (version == 23) {
            nVersion = "2.3";
        } else if (version == 24) {
            nVersion = "2.4";
        } else if (version == 25) {
            nVersion = "2.5";
        } else if (version == 30) {
            nVersion = "3.0";
        } else if (version == 50) {
            nVersion = "5.0";
        }
        return nVersion;
    }
}

