/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.metadata.internal;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.xml.type.SimpleAnyType;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.jst.jsf.common.metadata.Entity;
import org.eclipse.jst.jsf.common.metadata.MetadataFactory;
import org.eclipse.jst.jsf.common.metadata.MetadataPackage;
import org.eclipse.jst.jsf.common.metadata.Model;
import org.eclipse.jst.jsf.common.metadata.Trait;
import org.eclipse.jst.jsf.common.metadata.internal.IMetaDataModelMergeAssistant;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;

public abstract class AbstractTagLibDomainContentModelMetaDataTranslator {
    protected IMetaDataModelMergeAssistant _assistant;

    protected void setAssistant(IMetaDataModelMergeAssistant assistant) {
        this._assistant = assistant;
    }

    protected void doTranslate(CMDocument doc) {
        this.createTags(doc);
        this.createTagfileTraits(doc);
    }

    protected void createSimpleStringEntityTraitIfNecessary(Entity entity, String key, String value) {
        Trait t = this.findTraitOnEntityById(entity, key);
        if (t == null) {
            t = this.internalCreateTrait(entity, key);
            SimpleAnyType val = XMLTypeFactory.eINSTANCE.createSimpleAnyType();
            val.setInstanceType(EcorePackage.eINSTANCE.getEString());
            val.setValue((Object)value);
            t.setValue((EObject)val);
        }
    }

    protected void createSimpleBooleanObjectEntityTraitIfNecessary(Entity entity, String key, boolean value) {
        Trait t = this.findTraitOnEntityById(entity, key);
        if (t == null) {
            t = this.internalCreateTrait(entity, key);
            SimpleAnyType val = XMLTypeFactory.eINSTANCE.createSimpleAnyType();
            val.setInstanceType(EcorePackage.eINSTANCE.getEBoolean());
            val.setRawValue(value ? "true" : "false");
            t.setValue((EObject)val);
        }
    }

    protected Trait internalCreateTrait(Entity entity, String key) {
        Trait t = MetadataFactory.eINSTANCE.createTrait();
        t.setId(key);
        t.setSourceModelProvider(this._assistant.getSourceModelProvider());
        entity.getTraits().add((Object)t);
        return t;
    }

    protected Trait findTraitOnEntityById(Entity entity, String key) {
        for (Trait t : entity.getTraits()) {
            if (!key.equals(t.getId())) continue;
            return t;
        }
        return null;
    }

    protected Entity findTagEntity(String nodeName) {
        for (Entity entity : this.getMergedModel().getChildEntities()) {
            if (!nodeName.equals(entity.getId())) continue;
            return entity;
        }
        return null;
    }

    protected Entity findAttributeEntityForTagEntity(Entity tag, String attributeName) {
        for (Entity attr : tag.getChildEntities()) {
            if (!attributeName.equals(attr.getId())) continue;
            return attr;
        }
        return null;
    }

    protected void createTags(CMDocument doc) {
        for (CMElementDeclaration tag : doc.getElements()) {
            Entity entity = this.findTagEntity(tag.getNodeName());
            if (entity == null) {
                entity = MetadataFactory.eINSTANCE.createEntity();
                entity.setId(this.getTagNodeName(tag));
                entity.setType("tag");
                this.getMergedModel().getChildEntities().add((Object)entity);
            }
            this.setTagEntityTraits(tag, entity);
        }
    }

    protected String getTagNodeName(CMElementDeclaration tag) {
        return tag.getNodeName();
    }

    protected void setTagEntityTraits(CMElementDeclaration tag, Entity entity) {
        this.createSimpleStringEntityTraitIfNecessary(entity, "display-label", this.getTagDisplayName(tag));
        this.createSimpleStringEntityTraitIfNecessary(entity, "description", this.getTagDescription(tag));
        this.createSimpleStringEntityTraitIfNecessary(entity, "small-icon", this.getTagSmallIcon(tag));
        this.createSimpleStringEntityTraitIfNecessary(entity, "large-icon", this.getTagLargeIcon(tag));
        this.createSimpleBooleanObjectEntityTraitIfNecessary(entity, "expert", this.getTagIsExpert(tag));
        this.createSimpleBooleanObjectEntityTraitIfNecessary(entity, "hidden", this.getTagIsHidden(tag));
        this.createAttributeEntities(entity, tag);
    }

    protected void createAttributeEntities(Entity tagEntity, CMElementDeclaration tag) {
        for (CMAttributeDeclaration cmAttr : tag.getAttributes()) {
            Entity attr = this.findAttributeEntityForTagEntity(tagEntity, cmAttr.getAttrName());
            if (attr == null) {
                attr = MetadataFactory.eINSTANCE.createEntity();
                attr.setId(cmAttr.getAttrName());
                tagEntity.getChildEntities().add((Object)attr);
            }
            this.createAttributeTraits(attr, cmAttr);
        }
    }

    protected void createAttributeTraits(Entity attr, CMAttributeDeclaration cmAttr) {
        this.createSimpleStringEntityTraitIfNecessary(attr, "description", this.getTagAttributeDescription(cmAttr));
        this.createSimpleBooleanObjectEntityTraitIfNecessary(attr, "required", this.getTagAttributeIsRequired(cmAttr));
        this.createSimpleStringEntityTraitIfNecessary(attr, "default-value", this.getTagAttributeDefaultValue(cmAttr));
    }

    protected String getTagAttributeDescription(CMAttributeDeclaration cmAttr) {
        return null;
    }

    protected boolean getTagAttributeIsRequired(CMAttributeDeclaration cmAttr) {
        return cmAttr.getUsage() == 2;
    }

    protected String getTagAttributeDefaultValue(CMAttributeDeclaration cmAttr) {
        return null;
    }

    protected boolean getTagIsHidden(CMElementDeclaration tag) {
        return false;
    }

    protected boolean getTagIsExpert(CMElementDeclaration tag) {
        return false;
    }

    protected String getTagLargeIcon(CMElementDeclaration tag) {
        return null;
    }

    protected String getTagSmallIcon(CMElementDeclaration tag) {
        return null;
    }

    protected String getTagDescription(CMElementDeclaration tag) {
        return null;
    }

    protected String getTagDisplayName(CMElementDeclaration tag) {
        return tag.getElementName();
    }

    protected void createTagfileTraits(CMDocument doc) {
        Model model = this.getMergedModel();
        this.createSimpleStringEntityTraitIfNecessary(model, "display-label", this.getURIDisplayLabel());
        this.createSimpleStringEntityTraitIfNecessary(model, "description", this.getURIDescription());
        this.createSimpleStringEntityTraitIfNecessary(model, "default-prefix", this.getURIDefaultPrefix());
        this.createSimpleBooleanObjectEntityTraitIfNecessary(model, "expert", this.getURIExpert());
        this.createSimpleBooleanObjectEntityTraitIfNecessary(model, "hidden", this.getURIHidden());
    }

    protected String getURIDisplayLabel() {
        return this.getMergedModel().getId();
    }

    protected String getURIDefaultPrefix() {
        return null;
    }

    protected String getURIDescription() {
        return this.getMergedModel().getId();
    }

    protected boolean getURIExpert() {
        return false;
    }

    protected boolean getURIHidden() {
        return false;
    }

    protected Model getMergedModel() {
        Model model = (Model)this._assistant.getMergedModel().getRoot();
        if (model == null) {
            Model tld = this.createTLDModel();
            this._assistant.getMergedModel().setRoot(tld);
            model = (Model)this._assistant.getMergedModel().getRoot();
        }
        return model;
    }

    protected Model createTLDModel() {
        Model entity = this.getFactory().createModel();
        entity.setId(this._assistant.getMergedModel().getModelKey().getUri());
        return entity;
    }

    protected MetadataFactory getFactory() {
        return (MetadataFactory)MetadataPackage.eINSTANCE.getEFactoryInstance();
    }

    protected CMDocument getSourceModel() {
        return (CMDocument)this._assistant.getSourceModelProvider().getSourceModel();
    }
}

