/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.sse.core.internal.encoding.CodedIO;
import org.eclipse.wst.sse.core.internal.encoding.util.Logger;
import org.osgi.framework.Bundle;

public final class CommonCharsetNames {
    private static Properties defaultIANAmappings = null;
    private static ArrayList encodings = null;
    private static Hashtable supportedEncodingDisplayNames = null;

    public static String[] getCommonCharsetNames() {
        String[] enc = new String[CommonCharsetNames.getEncodings().size()];
        CommonCharsetNames.getEncodings().toArray(enc);
        return enc;
    }

    private static Properties getDefaultIANAMappings() {
        if (defaultIANAmappings == null) {
            defaultIANAmappings = new Properties();
            Bundle keyBundle = Platform.getBundle((String)"org.eclipse.wst.sse.core");
            Path keyPath = new Path("config/defaultIANA.properties");
            URL location = Platform.find((Bundle)keyBundle, (IPath)keyPath);
            InputStream propertiesInputStream = null;
            try {
                propertiesInputStream = location.openStream();
                defaultIANAmappings.load(propertiesInputStream);
            }
            catch (IOException iOException) {}
        }
        return defaultIANAmappings;
    }

    public static String getDisplayString(String charsetName) {
        if (charsetName == null) {
            return null;
        }
        String result = (String)CommonCharsetNames.getSupportedEncodingDisplayNames().get(charsetName);
        if (result == null) {
            try {
                Charset charset = Charset.forName(charsetName);
                result = charset.displayName();
            }
            catch (UnsupportedCharsetException unsupportedCharsetException) {}
        }
        return result;
    }

    private static ArrayList getEncodings() {
        if (encodings == null) {
            CommonCharsetNames.initHashTables();
        }
        return encodings;
    }

    public static String getIanaPreferredCharsetName(String charsetName) {
        String preferredName = charsetName;
        try {
            Charset charset = Charset.forName(charsetName);
            if (charset.name() != null) {
                preferredName = charset.name();
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {}
        return preferredName;
    }

    public static String getPreferredDefaultIanaName(String charsetName, String defaultIanaName) {
        String preferredName = defaultIanaName;
        String guessedName = charsetName;
        try {
            guessedName = CodedIO.getAppropriateJavaCharset(charsetName);
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {}
        preferredName = CommonCharsetNames.getEncodings().contains(guessedName) ? guessedName : CommonCharsetNames.getDefaultIANAMappings().getProperty(guessedName, preferredName);
        return preferredName;
    }

    private static Hashtable getSupportedEncodingDisplayNames() {
        if (supportedEncodingDisplayNames == null) {
            CommonCharsetNames.initHashTables();
        }
        return supportedEncodingDisplayNames;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void initHashTables() {
        if (supportedEncodingDisplayNames != null) return;
        supportedEncodingDisplayNames = new Hashtable();
        encodings = new ArrayList();
        ResourceBundle bundle = null;
        InputStream bundleStream = null;
        try {
            try {
                URL bundleURL = Platform.find((Bundle)Platform.getBundle((String)"org.eclipse.wst.sse.core"), (IPath)Path.fromOSString((String)"$nl$/config/charset.properties"));
                if (bundleURL != null) {
                    bundleStream = bundleURL.openStream();
                    bundle = new PropertyResourceBundle(bundleStream);
                }
                String totalNumString = bundle.getString("totalnumber");
                int totalNum = 0;
                if (totalNumString.length() != 0) {
                    try {
                        totalNum = Integer.valueOf(totalNumString);
                    }
                    catch (NumberFormatException numberFormatException) {
                        totalNum = 0;
                    }
                }
                int i = 0;
                while (i < totalNum) {
                    String iana = bundle.getString("codeset." + i + ".iana");
                    String displayName = bundle.getString("codeset." + i + ".label");
                    encodings.add(iana);
                    supportedEncodingDisplayNames.put(iana, displayName);
                    ++i;
                }
            }
            catch (IOException e) {
                Logger.logException("invalid install or configuration", e);
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            try {
                if (bundleStream == null) throw throwable;
                bundleStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var8_11 = null;
        }
        try {}
        catch (IOException iOException) {
            return;
        }
        if (bundleStream == null) return;
        bundleStream.close();
    }

    public static void main(String[] args) {
        String test = "Cp1252";
        String result = CommonCharsetNames.getIanaPreferredCharsetName(test);
        System.out.println(String.valueOf(test) + " --> " + result);
        test = "MS932";
        result = CommonCharsetNames.getIanaPreferredCharsetName(test);
        System.out.println(String.valueOf(test) + " --> " + result);
    }

    public CommonCharsetNames() {
        CommonCharsetNames.initHashTables();
    }
}

