/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.wsil.actions;

import java.util.Hashtable;
import org.eclipse.wst.ws.internal.explorer.platform.engine.transformer.ITransformer;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.wsdl.actions.OpenWSDLAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.actions.MultipleLinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.datamodel.WsilWsdlServiceElement;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.perspective.WSILPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.wsil.transformer.WSILViewSelectionTransformer;

public class WsilAddToWSDLPerspectiveAction
extends MultipleLinkAction {
    public WsilAddToWSDLPerspectiveAction(Controller controller) {
        super(controller);
    }

    public static String getActionLink(int nodeID, int toolID, int viewID, int viewToolID) {
        StringBuffer actionLink = new StringBuffer("wsil/actions/WsilAddToWSDLPerspectiveActionJSP.jsp?");
        actionLink.append("nodeId");
        actionLink.append('=');
        actionLink.append(nodeID);
        actionLink.append('&');
        actionLink.append("toolId");
        actionLink.append('=');
        actionLink.append(toolID);
        actionLink.append('&');
        actionLink.append("viewId");
        actionLink.append('=');
        actionLink.append(viewID);
        actionLink.append('&');
        actionLink.append("viewToolId");
        actionLink.append('=');
        actionLink.append(viewToolID);
        return actionLink.toString();
    }

    public static String getBaseActionLink() {
        return "wsil/actions/WsilAddToWSDLPerspectiveActionJSP.jsp";
    }

    public ITransformer[] getTransformers() {
        ITransformer[] parentTransformers = super.getTransformers();
        ITransformer[] transformers = new ITransformer[parentTransformers.length + 1];
        System.arraycopy(parentTransformers, 0, transformers, 0, parentTransformers.length);
        transformers[transformers.length - 1] = new WSILViewSelectionTransformer(this.controller_, "wsdlServices", "viewId", 1);
        return transformers;
    }

    protected boolean executeSingleLinkAction() {
        int nodeID = Integer.parseInt((String)this.propertyTable_.get("nodeId"));
        int viewID = Integer.parseInt((String)this.propertyTable_.get("viewId"));
        WSILPerspective wsilPerspective = this.controller_.getWSILPerspective();
        Node selectedNode = wsilPerspective.getNodeManager().getNode(nodeID);
        WsilElement wsilElement = (WsilElement)selectedNode.getTreeElement();
        WsilWsdlServiceElement wsilWsdlServiceElement = (WsilWsdlServiceElement)((Object)wsilElement.getAllWSDLServices().getElementWithViewId(viewID).getObject());
        String wsdlUrl = wsilWsdlServiceElement.getWSDLServiceURL();
        OpenWSDLAction openWSDLAction = new OpenWSDLAction(this.controller_);
        Hashtable propertyTable = openWSDLAction.getPropertyTable();
        propertyTable.put("wsdlURL", wsdlUrl);
        boolean actionResult = openWSDLAction.run();
        if (actionResult) {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_INFO_ADD_WSDL_TO_WSDL_PERSPECTIVE_SUCCESSFUL", wsdlUrl));
        } else {
            wsilPerspective.getMessageQueue().addMessage(wsilPerspective.getMessage("MSG_ERROR_ADD_WSDL_TO_WSDL_PERSPECTIVE", wsdlUrl));
        }
        return actionResult;
    }
}

