/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.changes;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.AddToClasspathChange;

public class DeleteFromClasspathChange
extends JDTChange {
    private final String fProjectHandle;
    private final IPath fPathToDelete;
    private IPath fPath;
    private IPath fSourceAttachmentPath;
    private IPath fSourceAttachmentRootPath;
    private int fEntryKind;

    public DeleteFromClasspathChange(IPackageFragmentRoot root) {
        this(root.getPath(), root.getJavaScriptProject());
    }

    DeleteFromClasspathChange(IPath pathToDelete, IJavaScriptProject project) {
        Assert.isNotNull((Object)pathToDelete);
        this.fPathToDelete = pathToDelete;
        this.fProjectHandle = project.getHandleIdentifier();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 3);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        AddToClasspathChange addToClasspathChange;
        pm.beginTask(this.getName(), 1);
        try {
            IJavaScriptProject project = this.getJavaProject();
            IIncludePathEntry[] cp = project.getRawIncludepath();
            IIncludePathEntry[] newCp = new IIncludePathEntry[cp.length - 1];
            int i = 0;
            int j = 0;
            while (j < newCp.length) {
                IIncludePathEntry current = JavaScriptCore.getResolvedIncludepathEntry((IIncludePathEntry)cp[i]);
                if (current != null && this.toBeDeleted(current)) {
                    ++i;
                    this.setDeletedEntryProperties(current);
                }
                newCp[j] = cp[i];
                ++i;
                ++j;
            }
            IIncludePathEntry last = JavaScriptCore.getResolvedIncludepathEntry((IIncludePathEntry)cp[cp.length - 1]);
            if (last != null && this.toBeDeleted(last)) {
                this.setDeletedEntryProperties(last);
            }
            project.setRawIncludepath(newCp, pm);
            addToClasspathChange = new AddToClasspathChange(this.getJavaProject(), this.fEntryKind, this.fPath, this.fSourceAttachmentPath, this.fSourceAttachmentRootPath);
            Object var8_9 = null;
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return addToClasspathChange;
    }

    private boolean toBeDeleted(IIncludePathEntry entry) {
        if (entry == null) {
            return false;
        }
        return this.fPathToDelete.equals((Object)entry.getPath());
    }

    private void setDeletedEntryProperties(IIncludePathEntry entry) {
        this.fEntryKind = entry.getEntryKind();
        this.fPath = entry.getPath();
        this.fSourceAttachmentPath = entry.getSourceAttachmentPath();
        this.fSourceAttachmentRootPath = entry.getSourceAttachmentRootPath();
    }

    private IJavaScriptProject getJavaProject() {
        return (IJavaScriptProject)JavaScriptCore.create((String)this.fProjectHandle);
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.DeleteFromClassPathChange_remove) + this.getJavaProject().getElementName();
    }

    public Object getModifiedElement() {
        return this.getJavaProject();
    }
}

